/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.interop.ExportValueNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.JSTruffleOptions;
import com.oracle.truffle.js.runtime.LargeInteger;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=ExportValueNode.class)
public final class ExportValueNodeGen
extends ExportValueNode
implements Introspection.Provider {
    private static final Uncached UNCACHED = new Uncached();
    @CompilerDirectives.CompilationFinal
    private int state_;
    @CompilerDirectives.CompilationFinal
    private int exclude_;

    private ExportValueNodeGen() {
    }

    @Override
    public Object execute(Object arg0Value, Object arg1Value, boolean arg2Value) {
        int state = this.state_;
        if ((state & Short.MAX_VALUE) != 0) {
            Object arg0Value_;
            if ((state & 0x1F) != 0 && JSTypes.isDynamicObject(arg0Value)) {
                arg0Value_ = (DynamicObject)arg0Value;
                if (!((state & 1) == 0 || !JSFunction.isJSFunction(arg0Value_) || arg2Value || JSTruffleOptions.InteropCompletePromises && JSFunction.isAsyncFunction(arg0Value_))) {
                    return ExportValueNode.doFunctionNoBind(arg0Value_, arg1Value, arg2Value);
                }
                if ((state & 2) != 0 && JSFunction.isJSFunction(arg0Value_) && arg2Value && JSGuards.isUndefined(arg1Value) && (!JSTruffleOptions.InteropCompletePromises || !JSFunction.isAsyncFunction(arg0Value_))) {
                    return ExportValueNode.doFunctionUndefinedThis(arg0Value_, arg1Value, arg2Value);
                }
                if (!((state & 4) == 0 || !JSFunction.isJSFunction(arg0Value_) || !arg2Value || JSGuards.isUndefined(arg1Value) || JSGuards.isBoundJSFunction(arg0Value_) || JSTruffleOptions.InteropCompletePromises && JSFunction.isAsyncFunction(arg0Value_))) {
                    return ExportValueNode.doBindUnboundFunction(arg0Value_, arg1Value, arg2Value);
                }
                if ((state & 8) != 0 && JSFunction.isJSFunction(arg0Value_) && arg2Value && JSGuards.isBoundJSFunction(arg0Value_) && (!JSTruffleOptions.InteropCompletePromises || !JSFunction.isAsyncFunction(arg0Value_))) {
                    return ExportValueNode.doBoundFunction(arg0Value_, arg1Value, arg2Value);
                }
                if ((state & 0x10) != 0 && JSFunction.isJSFunction(arg0Value_)) {
                    assert (JSTruffleOptions.InteropCompletePromises);
                    if (JSFunction.isAsyncFunction(arg0Value_)) {
                        return ExportValueNode.doAsyncFunction(arg0Value_, arg1Value, arg2Value);
                    }
                }
            }
            if ((state & 0x20) != 0 && arg0Value instanceof LargeInteger) {
                arg0Value_ = (LargeInteger)arg0Value;
                return ExportValueNode.doLargeInteger((LargeInteger)arg0Value_, arg1Value, arg2Value);
            }
            if ((state & 0x40) != 0 && JSTypes.isDynamicObject(arg0Value) && !JSFunction.isJSFunction(arg0Value_ = (DynamicObject)arg0Value)) {
                return ExportValueNode.doObject(arg0Value_, arg1Value, arg2Value);
            }
            if ((state & 0x80) != 0 && arg0Value instanceof Integer) {
                int arg0Value_2 = (Integer)arg0Value;
                return ExportValueNode.doInt(arg0Value_2, arg1Value, arg2Value);
            }
            if ((state & 0x100) != 0 && arg0Value instanceof Long) {
                long arg0Value_3 = (Long)arg0Value;
                return ExportValueNode.doLong(arg0Value_3, arg1Value, arg2Value);
            }
            if ((state & 0x200) != 0 && JSTypesGen.isImplicitDouble((state & 0x78000) >>> 15, arg0Value)) {
                double arg0Value_4 = JSTypesGen.asImplicitDouble((state & 0x78000) >>> 15, arg0Value);
                return ExportValueNode.doDouble(arg0Value_4, arg1Value, arg2Value);
            }
            if ((state & 0x400) != 0 && arg0Value instanceof Boolean) {
                boolean arg0Value_5 = (Boolean)arg0Value;
                return ExportValueNode.doBoolean(arg0Value_5, arg1Value, arg2Value);
            }
            if ((state & 0x800) != 0 && arg0Value instanceof BigInt) {
                arg0Value_ = (BigInt)arg0Value;
                return ExportValueNode.doBigInt((BigInt)arg0Value_, arg1Value, arg2Value);
            }
            if ((state & 0x1000) != 0 && JSTypesGen.isImplicitString((state & 0x780000) >>> 19, arg0Value)) {
                arg0Value_ = JSTypesGen.asImplicitString((state & 0x780000) >>> 19, arg0Value);
                return ExportValueNode.doString((String)arg0Value_, arg1Value, arg2Value);
            }
            if ((state & 0x2000) != 0 && arg0Value instanceof TruffleObject && !JSFunction.isJSFunction(arg0Value_ = (TruffleObject)arg0Value)) {
                return ExportValueNode.doTruffleObject((TruffleObject)arg0Value_, arg1Value, arg2Value);
            }
            if ((state & 0x4000) != 0 && ExportValueNodeGen.fallbackGuard_(state, arg0Value, arg1Value, arg2Value)) {
                return ExportValueNode.doOther(arg0Value, arg1Value, arg2Value);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeAndSpecialize(Object arg0Value, Object arg1Value, boolean arg2Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        int exclude = this.exclude_;
        try {
            TruffleObject arg0Value_;
            Object arg0Value_2;
            if (JSTypes.isDynamicObject(arg0Value)) {
                arg0Value_2 = (DynamicObject)arg0Value;
                if (!(!JSFunction.isJSFunction(arg0Value_2) || arg2Value || JSTruffleOptions.InteropCompletePromises && JSFunction.isAsyncFunction(arg0Value_2))) {
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    DynamicObject dynamicObject = ExportValueNode.doFunctionNoBind(arg0Value_2, arg1Value, arg2Value);
                    return dynamicObject;
                }
                if (JSFunction.isJSFunction(arg0Value_2) && arg2Value && JSGuards.isUndefined(arg1Value) && (!JSTruffleOptions.InteropCompletePromises || !JSFunction.isAsyncFunction(arg0Value_2))) {
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    DynamicObject dynamicObject = ExportValueNode.doFunctionUndefinedThis(arg0Value_2, arg1Value, arg2Value);
                    return dynamicObject;
                }
                if (!(!JSFunction.isJSFunction(arg0Value_2) || !arg2Value || JSGuards.isUndefined(arg1Value) || JSGuards.isBoundJSFunction(arg0Value_2) || JSTruffleOptions.InteropCompletePromises && JSFunction.isAsyncFunction(arg0Value_2))) {
                    this.state_ = state |= 4;
                    lock.unlock();
                    hasLock = false;
                    TruffleObject truffleObject = ExportValueNode.doBindUnboundFunction(arg0Value_2, arg1Value, arg2Value);
                    return truffleObject;
                }
                if (JSFunction.isJSFunction(arg0Value_2) && arg2Value && JSGuards.isBoundJSFunction(arg0Value_2) && (!JSTruffleOptions.InteropCompletePromises || !JSFunction.isAsyncFunction(arg0Value_2))) {
                    this.state_ = state |= 8;
                    lock.unlock();
                    hasLock = false;
                    DynamicObject dynamicObject = ExportValueNode.doBoundFunction(arg0Value_2, arg1Value, arg2Value);
                    return dynamicObject;
                }
                if (JSFunction.isJSFunction(arg0Value_2) && JSTruffleOptions.InteropCompletePromises && JSFunction.isAsyncFunction(arg0Value_2)) {
                    this.state_ = state |= 0x10;
                    lock.unlock();
                    hasLock = false;
                    TruffleObject truffleObject = ExportValueNode.doAsyncFunction(arg0Value_2, arg1Value, arg2Value);
                    return truffleObject;
                }
            }
            if (arg0Value instanceof LargeInteger) {
                arg0Value_2 = (LargeInteger)arg0Value;
                this.state_ = state |= 0x20;
                lock.unlock();
                hasLock = false;
                Double d = ExportValueNode.doLargeInteger((LargeInteger)arg0Value_2, arg1Value, arg2Value);
                return d;
            }
            if (exclude == 0 && JSTypes.isDynamicObject(arg0Value) && !JSFunction.isJSFunction(arg0Value_2 = (DynamicObject)arg0Value)) {
                this.state_ = state |= 0x40;
                lock.unlock();
                hasLock = false;
                DynamicObject dynamicObject = ExportValueNode.doObject(arg0Value_2, arg1Value, arg2Value);
                return dynamicObject;
            }
            if (arg0Value instanceof Integer) {
                int arg0Value_3 = (Integer)arg0Value;
                this.state_ = state |= 0x80;
                lock.unlock();
                hasLock = false;
                Integer n = ExportValueNode.doInt(arg0Value_3, arg1Value, arg2Value);
                return n;
            }
            if (arg0Value instanceof Long) {
                long arg0Value_4 = (Long)arg0Value;
                this.state_ = state |= 0x100;
                lock.unlock();
                hasLock = false;
                Long l = ExportValueNode.doLong(arg0Value_4, arg1Value, arg2Value);
                return l;
            }
            int doubleCast0 = JSTypesGen.specializeImplicitDouble(arg0Value);
            if (doubleCast0 != 0) {
                double arg0Value_5 = JSTypesGen.asImplicitDouble(doubleCast0, arg0Value);
                state |= doubleCast0 << 15;
                this.state_ = state |= 0x200;
                lock.unlock();
                hasLock = false;
                Double d = ExportValueNode.doDouble(arg0Value_5, arg1Value, arg2Value);
                return d;
            }
            if (arg0Value instanceof Boolean) {
                boolean arg0Value_6 = (Boolean)arg0Value;
                this.state_ = state |= 0x400;
                lock.unlock();
                hasLock = false;
                Boolean arg0Value_5 = ExportValueNode.doBoolean(arg0Value_6, arg1Value, arg2Value);
                return arg0Value_5;
            }
            if (arg0Value instanceof BigInt) {
                BigInt arg0Value_7 = (BigInt)arg0Value;
                this.state_ = state |= 0x800;
                lock.unlock();
                hasLock = false;
                BigInt arg0Value_5 = ExportValueNode.doBigInt(arg0Value_7, arg1Value, arg2Value);
                return arg0Value_5;
            }
            int stringCast0 = JSTypesGen.specializeImplicitString(arg0Value);
            if (stringCast0 != 0) {
                String arg0Value_8 = JSTypesGen.asImplicitString(stringCast0, arg0Value);
                state |= stringCast0 << 19;
                this.state_ = state |= 0x1000;
                lock.unlock();
                hasLock = false;
                String string = ExportValueNode.doString(arg0Value_8, arg1Value, arg2Value);
                return string;
            }
            if (arg0Value instanceof TruffleObject && !JSFunction.isJSFunction(arg0Value_ = (TruffleObject)arg0Value)) {
                this.exclude_ = exclude |= 1;
                state &= 0xFFFFFFBF;
                this.state_ = state |= 0x2000;
                lock.unlock();
                hasLock = false;
                TruffleObject truffleObject = ExportValueNode.doTruffleObject(arg0Value_, arg1Value, arg2Value);
                return truffleObject;
            }
            this.state_ = state |= 0x4000;
            lock.unlock();
            hasLock = false;
            Object object = ExportValueNode.doOther(arg0Value, arg1Value, arg2Value);
            return object;
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if ((state & Short.MAX_VALUE) == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & Short.MAX_VALUE & (state & Short.MAX_VALUE) - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public Introspection getIntrospectionData() {
        Object[] data = new Object[16];
        data[0] = 0;
        int state = this.state_;
        int exclude = this.exclude_;
        Object[] s = new Object[3];
        s[0] = "doFunctionNoBind";
        s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[1] = s;
        s = new Object[3];
        s[0] = "doFunctionUndefinedThis";
        s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[2] = s;
        s = new Object[3];
        s[0] = "doBindUnboundFunction";
        s[1] = (state & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[3] = s;
        s = new Object[3];
        s[0] = "doBoundFunction";
        s[1] = (state & 8) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[4] = s;
        s = new Object[3];
        s[0] = "doAsyncFunction";
        s[1] = (state & 0x10) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[5] = s;
        s = new Object[3];
        s[0] = "doLargeInteger";
        s[1] = (state & 0x20) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[6] = s;
        s = new Object[3];
        s[0] = "doObject";
        s[1] = (state & 0x40) != 0 ? Byte.valueOf((byte)1) : (exclude != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
        data[7] = s;
        s = new Object[3];
        s[0] = "doInt";
        s[1] = (state & 0x80) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[8] = s;
        s = new Object[3];
        s[0] = "doLong";
        s[1] = (state & 0x100) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[9] = s;
        s = new Object[3];
        s[0] = "doDouble";
        s[1] = (state & 0x200) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[10] = s;
        s = new Object[3];
        s[0] = "doBoolean";
        s[1] = (state & 0x400) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[11] = s;
        s = new Object[3];
        s[0] = "doBigInt";
        s[1] = (state & 0x800) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[12] = s;
        s = new Object[3];
        s[0] = "doString";
        s[1] = (state & 0x1000) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[13] = s;
        s = new Object[3];
        s[0] = "doTruffleObject";
        s[1] = (state & 0x2000) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[14] = s;
        s = new Object[3];
        s[0] = "doOther";
        s[1] = (state & 0x4000) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[15] = s;
        return Introspection.Provider.create((Object[])data);
    }

    private static boolean fallbackGuard_(int state, Object arg0Value, Object arg1Value, boolean arg2Value) {
        DynamicObject arg0Value_;
        if (JSTypes.isDynamicObject(arg0Value)) {
            arg0Value_ = (DynamicObject)arg0Value;
            if (!(!JSFunction.isJSFunction(arg0Value_) || arg2Value || JSTruffleOptions.InteropCompletePromises && JSFunction.isAsyncFunction(arg0Value_))) {
                return false;
            }
            arg0Value_ = (DynamicObject)arg0Value;
            if (JSFunction.isJSFunction(arg0Value_) && arg2Value && JSGuards.isUndefined(arg1Value) && (!JSTruffleOptions.InteropCompletePromises || !JSFunction.isAsyncFunction(arg0Value_))) {
                return false;
            }
            arg0Value_ = (DynamicObject)arg0Value;
            if (!(!JSFunction.isJSFunction(arg0Value_) || !arg2Value || JSGuards.isUndefined(arg1Value) || JSGuards.isBoundJSFunction(arg0Value_) || JSTruffleOptions.InteropCompletePromises && JSFunction.isAsyncFunction(arg0Value_))) {
                return false;
            }
            arg0Value_ = (DynamicObject)arg0Value;
            if (JSFunction.isJSFunction(arg0Value_) && arg2Value && JSGuards.isBoundJSFunction(arg0Value_) && (!JSTruffleOptions.InteropCompletePromises || !JSFunction.isAsyncFunction(arg0Value_))) {
                return false;
            }
            arg0Value_ = (DynamicObject)arg0Value;
            if (JSFunction.isJSFunction(arg0Value_)) {
                assert (JSTruffleOptions.InteropCompletePromises);
                if (JSFunction.isAsyncFunction(arg0Value_)) {
                    return false;
                }
            }
        }
        if (JSTypesGen.isImplicitDouble(arg0Value)) {
            return false;
        }
        if ((state & 0x400) == 0 && arg0Value instanceof Boolean) {
            return false;
        }
        if ((state & 0x800) == 0 && arg0Value instanceof BigInt) {
            return false;
        }
        if (JSTypesGen.isImplicitString(arg0Value)) {
            return false;
        }
        return !(arg0Value instanceof TruffleObject) || JSFunction.isJSFunction((Object)(arg0Value_ = (TruffleObject)arg0Value));
    }

    public static ExportValueNode create() {
        return new ExportValueNodeGen();
    }

    public static ExportValueNode getUncached() {
        return UNCACHED;
    }

    @GeneratedBy(value=ExportValueNode.class)
    private static final class Uncached
    extends ExportValueNode {
        private Uncached() {
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object execute(Object arg0Value, Object arg1Value, boolean arg2Value) {
            Object arg0Value_;
            if (JSTypes.isDynamicObject(arg0Value)) {
                arg0Value_ = (DynamicObject)arg0Value;
                if (!(!JSFunction.isJSFunction(arg0Value_) || arg2Value || JSTruffleOptions.InteropCompletePromises && JSFunction.isAsyncFunction(arg0Value_))) {
                    return ExportValueNode.doFunctionNoBind(arg0Value_, arg1Value, arg2Value);
                }
                if (JSFunction.isJSFunction(arg0Value_) && arg2Value && JSGuards.isUndefined(arg1Value) && (!JSTruffleOptions.InteropCompletePromises || !JSFunction.isAsyncFunction(arg0Value_))) {
                    return ExportValueNode.doFunctionUndefinedThis(arg0Value_, arg1Value, arg2Value);
                }
                if (!(!JSFunction.isJSFunction(arg0Value_) || !arg2Value || JSGuards.isUndefined(arg1Value) || JSGuards.isBoundJSFunction(arg0Value_) || JSTruffleOptions.InteropCompletePromises && JSFunction.isAsyncFunction(arg0Value_))) {
                    return ExportValueNode.doBindUnboundFunction(arg0Value_, arg1Value, arg2Value);
                }
                if (JSFunction.isJSFunction(arg0Value_) && arg2Value && JSGuards.isBoundJSFunction(arg0Value_) && (!JSTruffleOptions.InteropCompletePromises || !JSFunction.isAsyncFunction(arg0Value_))) {
                    return ExportValueNode.doBoundFunction(arg0Value_, arg1Value, arg2Value);
                }
                if (JSFunction.isJSFunction(arg0Value_) && JSTruffleOptions.InteropCompletePromises && JSFunction.isAsyncFunction(arg0Value_)) {
                    return ExportValueNode.doAsyncFunction(arg0Value_, arg1Value, arg2Value);
                }
            }
            if (arg0Value instanceof LargeInteger) {
                arg0Value_ = (LargeInteger)arg0Value;
                return ExportValueNode.doLargeInteger((LargeInteger)arg0Value_, arg1Value, arg2Value);
            }
            if (arg0Value instanceof Integer) {
                int arg0Value_2 = (Integer)arg0Value;
                return ExportValueNode.doInt(arg0Value_2, arg1Value, arg2Value);
            }
            if (arg0Value instanceof Long) {
                long arg0Value_3 = (Long)arg0Value;
                return ExportValueNode.doLong(arg0Value_3, arg1Value, arg2Value);
            }
            if (JSTypesGen.isImplicitDouble(arg0Value)) {
                double arg0Value_4 = JSTypesGen.asImplicitDouble(arg0Value);
                return ExportValueNode.doDouble(arg0Value_4, arg1Value, arg2Value);
            }
            if (arg0Value instanceof Boolean) {
                boolean arg0Value_5 = (Boolean)arg0Value;
                return ExportValueNode.doBoolean(arg0Value_5, arg1Value, arg2Value);
            }
            if (arg0Value instanceof BigInt) {
                arg0Value_ = (BigInt)arg0Value;
                return ExportValueNode.doBigInt((BigInt)arg0Value_, arg1Value, arg2Value);
            }
            if (JSTypesGen.isImplicitString(arg0Value)) {
                arg0Value_ = JSTypesGen.asImplicitString(arg0Value);
                return ExportValueNode.doString((String)arg0Value_, arg1Value, arg2Value);
            }
            if (arg0Value instanceof TruffleObject && !JSFunction.isJSFunction(arg0Value_ = (TruffleObject)arg0Value)) {
                return ExportValueNode.doTruffleObject((TruffleObject)arg0Value_, arg1Value, arg2Value);
            }
            return ExportValueNode.doOther(arg0Value, arg1Value, arg2Value);
        }

        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        public boolean isAdoptable() {
            return false;
        }
    }
}

