/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.promise;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.CreateDataPropertyNode;
import com.oracle.truffle.js.nodes.access.CreateObjectNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.arguments.AccessIndexedArgumentNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.nodes.promise.PerformPromiseAllNode;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSFrameUtil;
import com.oracle.truffle.js.runtime.JavaScriptRootNode;
import com.oracle.truffle.js.runtime.builtins.JSArray;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import com.oracle.truffle.js.runtime.objects.PromiseCapabilityRecord;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.SimpleArrayList;

public class PerformPromiseAllSettledNode
extends PerformPromiseAllNode {
    protected PerformPromiseAllSettledNode(JSContext context) {
        super(context);
    }

    public static PerformPromiseAllSettledNode create(JSContext context) {
        return new PerformPromiseAllSettledNode(context);
    }

    @Override
    protected DynamicObject createResolveElementFunction(int index, SimpleArrayList<Object> values, PromiseCapabilityRecord resultCapability, PerformPromiseAllNode.BoxedInt remainingElementsCount) {
        JSFunctionData functionData = this.context.getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.PromiseAllSettledResolveElement, c -> PerformPromiseAllSettledNode.createResolveElementFunctionImpl(c));
        DynamicObject function = JSFunction.create(this.context.getRealm(), functionData);
        this.setArgs.setValue(function, new PerformPromiseAllNode.ResolveElementArgs(index, values, resultCapability, remainingElementsCount));
        return function;
    }

    @Override
    protected Object createRejectElementFunction(int index, SimpleArrayList<Object> values, PromiseCapabilityRecord resultCapability, PerformPromiseAllNode.BoxedInt remainingElementsCount) {
        JSFunctionData functionData = this.context.getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.PromiseAllSettledRejectElement, c -> PerformPromiseAllSettledNode.createRejectElementFunctionImpl(c));
        DynamicObject function = JSFunction.create(this.context.getRealm(), functionData);
        this.setArgs.setValue(function, new PerformPromiseAllNode.ResolveElementArgs(index, values, resultCapability, remainingElementsCount));
        return function;
    }

    private static JSFunctionData createResolveElementFunctionImpl(JSContext context) {
        class PromiseAllSEttledResolveElementRootNode
        extends JavaScriptRootNode {
            @Node.Child
            private JavaScriptNode valueNode = AccessIndexedArgumentNode.create(0);
            @Node.Child
            private PropertyGetNode getArgs = PropertyGetNode.createGetHidden(PerformPromiseAllNode.RESOLVE_ELEMENT_ARGS_KEY, this.val$context);
            @Node.Child
            private JSFunctionCallNode callResolve = JSFunctionCallNode.createCall();
            @Node.Child
            private CreateObjectNode objectCreateNode = CreateObjectNode.create(this.val$context);
            @Node.Child
            private CreateDataPropertyNode createStatusPropertyNode = CreateDataPropertyNode.create(this.val$context, "status");
            @Node.Child
            private CreateDataPropertyNode createValuePropertyNode = CreateDataPropertyNode.create(this.val$context, "value");
            final /* synthetic */ JSContext val$context;

            PromiseAllSEttledResolveElementRootNode(JSContext jSContext) {
                this.val$context = jSContext;
            }

            public Object execute(VirtualFrame frame) {
                DynamicObject functionObject = JSFrameUtil.getFunctionObject((Frame)frame);
                PerformPromiseAllNode.ResolveElementArgs args = (PerformPromiseAllNode.ResolveElementArgs)this.getArgs.getValue(functionObject);
                if (args.alreadyCalled) {
                    return Undefined.instance;
                }
                args.alreadyCalled = true;
                Object value = this.valueNode.execute(frame);
                DynamicObject obj = this.objectCreateNode.execute(frame);
                this.createStatusPropertyNode.executeVoid(obj, "fulfilled");
                this.createValuePropertyNode.executeVoid(obj, value);
                args.values.set(args.index, obj);
                --args.remainingElements.value;
                if (args.remainingElements.value == 0) {
                    DynamicObject valuesArray = JSArray.createConstantObjectArray(this.val$context, args.values.toArray());
                    return this.callResolve.executeCall(JSArguments.createOneArg(Undefined.instance, args.capability.getResolve(), valuesArray));
                }
                return Undefined.instance;
            }
        }
        RootCallTarget callTarget = Truffle.getRuntime().createCallTarget((RootNode)new PromiseAllSEttledResolveElementRootNode(context));
        return JSFunctionData.createCallOnly(context, (CallTarget)callTarget, 1, "");
    }

    private static JSFunctionData createRejectElementFunctionImpl(JSContext context) {
        class PromiseAllSettledRejectElementRootNode
        extends JavaScriptRootNode {
            @Node.Child
            private JavaScriptNode valueNode = AccessIndexedArgumentNode.create(0);
            @Node.Child
            private PropertyGetNode getArgs = PropertyGetNode.createGetHidden(PerformPromiseAllNode.RESOLVE_ELEMENT_ARGS_KEY, this.val$context);
            @Node.Child
            private JSFunctionCallNode callResolve = JSFunctionCallNode.createCall();
            @Node.Child
            private CreateObjectNode objectCreateNode = CreateObjectNode.create(this.val$context);
            @Node.Child
            private CreateDataPropertyNode createStatusPropertyNode = CreateDataPropertyNode.create(this.val$context, "status");
            @Node.Child
            private CreateDataPropertyNode createReasonPropertyNode = CreateDataPropertyNode.create(this.val$context, "reason");
            final /* synthetic */ JSContext val$context;

            PromiseAllSettledRejectElementRootNode(JSContext jSContext) {
                this.val$context = jSContext;
            }

            public Object execute(VirtualFrame frame) {
                DynamicObject functionObject = JSFrameUtil.getFunctionObject((Frame)frame);
                PerformPromiseAllNode.ResolveElementArgs args = (PerformPromiseAllNode.ResolveElementArgs)this.getArgs.getValue(functionObject);
                if (args.alreadyCalled) {
                    return Undefined.instance;
                }
                args.alreadyCalled = true;
                Object value = this.valueNode.execute(frame);
                DynamicObject obj = this.objectCreateNode.execute(frame);
                this.createStatusPropertyNode.executeVoid(obj, "rejected");
                this.createReasonPropertyNode.executeVoid(obj, value);
                args.values.set(args.index, obj);
                --args.remainingElements.value;
                if (args.remainingElements.value == 0) {
                    DynamicObject valuesArray = JSArray.createConstantObjectArray(this.val$context, args.values.toArray());
                    return this.callResolve.executeCall(JSArguments.createOneArg(Undefined.instance, args.capability.getResolve(), valuesArray));
                }
                return Undefined.instance;
            }
        }
        RootCallTarget callTarget = Truffle.getRuntime().createCallTarget((RootNode)new PromiseAllSettledRejectElementRootNode(context));
        return JSFunctionData.createCallOnly(context, (CallTarget)callTarget, 1, "");
    }
}

