/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.array.dyn;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSTruffleOptions;
import com.oracle.truffle.js.runtime.array.DynamicArray;
import com.oracle.truffle.js.runtime.array.ScriptArray;
import com.oracle.truffle.js.runtime.array.dyn.AbstractWritableArray;
import com.oracle.truffle.js.runtime.array.dyn.HolesObjectArray;
import com.oracle.truffle.js.runtime.builtins.JSAbstractArray;

public abstract class AbstractObjectArray
extends AbstractWritableArray {
    protected AbstractObjectArray(int integrityLevel, DynamicArray.DynamicArrayCache cache) {
        super(integrityLevel, cache);
    }

    @Override
    AbstractWritableArray sameTypeHolesArray(DynamicObject object, int length, Object array, long indexOffset, int arrayOffset, int usedLength, int holeCount) {
        return HolesObjectArray.makeHolesObjectArray(object, length, (Object[])array, indexOffset, arrayOffset, usedLength, holeCount, this.integrityLevel);
    }

    public abstract void setInBoundsFast(DynamicObject var1, int var2, Object var3, boolean var4);

    @Override
    public final ScriptArray setElementImpl(DynamicObject object, long index, Object value, boolean strict, boolean condition) {
        assert (index >= 0L);
        if (CompilerDirectives.injectBranchProbability((double)0.9999, (boolean)this.isSupported(object, index, condition))) {
            assert (value != null);
            this.setSupported(object, (int)index, value, condition);
            return this;
        }
        return this.rewrite(object, index, value, condition).setElementImpl(object, index, value, strict, condition);
    }

    private ScriptArray rewrite(DynamicObject object, long index, Object value, boolean condition) {
        if (this.isSupportedContiguous(object, index, condition)) {
            return this.toContiguous(object, index, value, condition);
        }
        if (this.isSupportedHoles(object, index, condition)) {
            return this.toHoles(object, index, value, condition);
        }
        return this.toSparse(object, index, value);
    }

    @Override
    public Object getInBoundsFast(DynamicObject object, int index, boolean condition) {
        return this.getInBoundsFastObject(object, index, condition);
    }

    @Override
    int getArrayLength(Object array) {
        return ((Object[])array).length;
    }

    protected static Object[] getArray(DynamicObject object) {
        return AbstractObjectArray.getArray(object, AbstractObjectArray.arrayCondition());
    }

    protected static Object[] getArray(DynamicObject object, boolean condition) {
        return AbstractObjectArray.arrayCast(JSAbstractArray.arrayGetArray(object, condition), Object[].class, condition);
    }

    public abstract Object getInBoundsFastObject(DynamicObject var1, int var2, boolean var3);

    public final void setInBounds(DynamicObject object, int index, Object value, boolean condition, ScriptArray.ProfileHolder profile) {
        AbstractObjectArray.getArray((DynamicObject)object, (boolean)condition)[this.prepareInBounds((DynamicObject)object, (int)index, (boolean)condition, (ScriptArray.ProfileHolder)profile)] = AbstractObjectArray.checkNonNull(value);
        if (JSTruffleOptions.TraceArrayWrites) {
            this.traceWriteValue("InBounds", index, value);
        }
    }

    public final void setSupported(DynamicObject object, int index, Object value, boolean condition) {
        int preparedIndex = this.prepareSupported(object, index, condition, ScriptArray.ProfileHolder.empty());
        AbstractObjectArray.getArray((DynamicObject)object, (boolean)condition)[preparedIndex] = AbstractObjectArray.checkNonNull(value);
        if (JSTruffleOptions.TraceArrayWrites) {
            this.traceWriteValue("Supported", index, value);
        }
    }

    @Override
    void fillWithHoles(Object array, int fromIndex, int toIndex) {
        Object[] objectArray = (Object[])array;
        for (int i = fromIndex; i < toIndex; ++i) {
            objectArray[i] = null;
        }
    }

    @Override
    protected final void setHoleValue(DynamicObject object, int preparedIndex) {
        AbstractObjectArray.getArray((DynamicObject)object)[preparedIndex] = null;
    }

    @Override
    protected final void fillHoles(DynamicObject object, int internalIndex, int grown, ScriptArray.ProfileHolder profile) {
        if (grown != 0) {
            this.incrementHolesCount(object, Math.abs(grown) - 1);
        }
    }

    @Override
    protected final boolean isHolePrepared(DynamicObject object, int preparedIndex, boolean condition) {
        return HolesObjectArray.isHoleValue(AbstractObjectArray.getArray(object, condition)[preparedIndex]);
    }

    @Override
    protected final int getArrayCapacity(DynamicObject object, boolean condition) {
        return AbstractObjectArray.getArray(object, condition).length;
    }

    @Override
    protected final void resizeArray(DynamicObject object, int newCapacity, int oldCapacity, int offset, boolean condition) {
        Object[] newArray = new Object[newCapacity];
        System.arraycopy(AbstractObjectArray.getArray(object, condition), 0, newArray, offset, oldCapacity);
        JSAbstractArray.arraySetArray(object, newArray);
    }

    @Override
    public abstract AbstractObjectArray toHoles(DynamicObject var1, long var2, Object var4, boolean var5);

    @Override
    public final AbstractWritableArray toDouble(DynamicObject object, long index, double value, boolean condition) {
        return this;
    }

    @Override
    public final AbstractWritableArray toObject(DynamicObject object, long index, Object value, boolean condition) {
        return this;
    }

    @Override
    public ScriptArray deleteElementImpl(DynamicObject object, long index, boolean strict, boolean condition) {
        return this.toHoles(object, index, null, condition).deleteElementImpl(object, index, strict, condition);
    }

    @Override
    protected final void moveRangePrepared(DynamicObject object, int src, int dst, int len) {
        Object[] array = AbstractObjectArray.getArray(object);
        System.arraycopy(array, src, array, dst, len);
    }

    @Override
    public final Object allocateArray(int length) {
        return new Object[length];
    }

    @Override
    protected abstract AbstractObjectArray withIntegrityLevel(int var1);

    protected static Object checkNonNull(Object value) {
        assert (value != null);
        return value;
    }

    protected Object castNonNull(Object value) {
        if (JSTruffleOptions.MarkElementsNonNull && value == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw Errors.shouldNotReachHere();
        }
        return value;
    }
}

