/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.util;

import com.ibm.icu.text.CaseMap;
import com.ibm.icu.util.ULocale;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSException;
import com.oracle.truffle.js.runtime.builtins.JSUserObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.util.LazyValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.IllformedLocaleException;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Set;

public final class IntlUtil {
    private static final List<String> BCP47_NU_KEYS = Arrays.asList("adlm", "ahom", "arab", "arabext", "armn", "armnlow", "bali", "beng", "bhks", "brah", "cakm", "cham", "cyrl", "deva", "ethi", "finance", "fullwide", "geor", "gonm", "grek", "greklow", "gujr", "guru", "hanidays", "hanidec", "hans", "hansfin", "hant", "hantfin", "hebr", "hmng", "java", "jpan", "jpanfin", "kali", "khmr", "knda", "lana", "lanatham", "laoo", "latn", "lepc", "limb", "mathbold", "mathdbl", "mathmono", "mathsanb", "mathsans", "mlym", "modi", "mong", "mroo", "mtei", "mymr", "mymrshan", "mymrtlng", "native", "newa", "nkoo", "olck", "orya", "osma", "roman", "romanlow", "saur", "shrd", "sind", "sinh", "sora", "sund", "takr", "talu", "taml", "tamldec", "telu", "thai", "tirh", "tibt", "traditio", "vaii", "wara");
    private static final List<String> BANNED_BCP47_NU_KEYS = Arrays.asList("native", "traditio", "finance");
    public static final String _2_DIGIT = "2-digit";
    public static final String ACCENT = "accent";
    public static final String ALWAYS = "always";
    public static final String AUTO = "auto";
    public static final String BEST_FIT = "best fit";
    public static final String BASE = "base";
    public static final String BASIC = "basic";
    public static final String BREAK_TYPE = "breakType";
    public static final String CALENDAR = "calendar";
    public static final String CARDINAL = "cardinal";
    public static final String CASE = "case";
    public static final String CASE_FIRST = "caseFirst";
    public static final String CODE = "code";
    public static final String COLLATION = "collation";
    public static final String CONJUNCTION = "conjunction";
    public static final String CURRENCY = "currency";
    public static final String CURRENCY_DISPLAY = "currencyDisplay";
    public static final String DAY = "day";
    public static final String DEFAULT = "default";
    public static final String DECIMAL = "decimal";
    public static final String DISJUNCTION = "disjunction";
    public static final String ELEMENT = "element";
    public static final String ERA = "era";
    public static final String FALSE = "false";
    public static final String FORMAT_MATCHER = "formatMatcher";
    public static final String GRANULARITY = "granularity";
    public static final String GRAPHEME = "grapheme";
    public static final String H11 = "h11";
    public static final String H12 = "h12";
    public static final String H23 = "h23";
    public static final String H24 = "h24";
    public static final String HOUR = "hour";
    public static final String HOUR_CYCLE = "hourCycle";
    public static final String HOUR12 = "hour12";
    public static final String INDEX = "index";
    public static final String IGNORE_PUNCTUATION = "ignorePunctuation";
    public static final String LITERAL = "literal";
    public static final String LOCALE = "locale";
    public static final String LOCALE_MATCHER = "localeMatcher";
    public static final String LONG = "long";
    public static final String LOOKUP = "lookup";
    public static final String LOOSE = "loose";
    public static final String LOWER = "lower";
    public static final String MAXIMUM_FRACTION_DIGITS = "maximumFractionDigits";
    public static final String MAXIMUM_SIGNIFICANT_DIGITS = "maximumSignificantDigits";
    public static final String MINIMUM_FRACTION_DIGITS = "minimumFractionDigits";
    public static final String MINIMUM_INTEGER_DIGITS = "minimumIntegerDigits";
    public static final String MINIMUM_SIGNIFICANT_DIGITS = "minimumSignificantDigits";
    public static final String MINUTE = "minute";
    public static final String MONTH = "month";
    public static final String NAME = "name";
    public static final String NARROW = "narrow";
    public static final String NONE = "none";
    public static final String NORMAL = "normal";
    public static final String NUMERIC = "numeric";
    public static final String NUMBERING_SYSTEM = "numberingSystem";
    public static final String OR = "or";
    public static final String OR_NARROW = "or-narrow";
    public static final String OR_SHORT = "or-short";
    public static final String ORDINAL = "ordinal";
    public static final String PERCENT = "percent";
    public static final String SEARCH = "search";
    public static final String SEP = "sep";
    public static final String SECOND = "second";
    public static final String SEGMENT = "segment";
    public static final String SENTENCE = "sentence";
    public static final String SENSITIVITY = "sensitivity";
    public static final String SHORT = "short";
    public static final String SORT = "sort";
    public static final String STANDARD = "standard";
    public static final String STANDARD_NARROW = "standard-narrow";
    public static final String STANDARD_SHORT = "standard-short";
    public static final String STRICT = "strict";
    public static final String STYLE = "style";
    public static final String SYMBOL = "symbol";
    public static final String TERM = "term";
    public static final String TIME_ZONE = "timeZone";
    public static final String TIME_ZONE_NAME = "timeZoneName";
    public static final String TYPE = "type";
    public static final String UND = "und";
    public static final String UNIT = "unit";
    public static final String UNIT_NARROW = "unit-narrow";
    public static final String UNIT_SHORT = "unit-short";
    public static final String UPPER = "upper";
    public static final String USAGE = "usage";
    public static final String USE_GROUPING = "useGrouping";
    public static final String VALUE = "value";
    public static final String VARIANT = "variant";
    public static final String WORD = "word";
    public static final String WEEKDAY = "weekday";
    public static final String YEAR = "year";
    private static final LazyValue<Set<Locale>> AVAILABLE_LOCALES = new LazyValue<Set>(IntlUtil::initAvailableLocales);

    private IntlUtil() {
    }

    public static String selectedLocale(JSContext ctx, String[] locales) {
        Locale matchedLocale = IntlUtil.lookupMatcher(ctx, locales);
        return matchedLocale != null ? matchedLocale.toLanguageTag() : null;
    }

    @CompilerDirectives.TruffleBoundary
    private static Locale lookupMatcher(JSContext ctx, String[] languageTags) {
        block0: for (String lt : languageTags) {
            Locale candidate = Locale.forLanguageTag(lt);
            while (!IntlUtil.lookupMatch(ctx, candidate, true)) {
                String candidateLanguageTag = candidate.toLanguageTag();
                int pos = candidateLanguageTag.lastIndexOf(45);
                if (pos == -1) continue block0;
                if (pos >= 2 && candidateLanguageTag.charAt(pos - 2) == '-') {
                    pos -= 2;
                }
                candidateLanguageTag = candidateLanguageTag.substring(0, pos);
                candidate = Locale.forLanguageTag(candidateLanguageTag);
            }
            return candidate;
        }
        return null;
    }

    @CompilerDirectives.TruffleBoundary
    public static List<Object> supportedLocales(JSContext ctx, String[] locales, String matcher) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (String l : locales) {
            if (!IntlUtil.lookupMatch(ctx, Locale.forLanguageTag(l), true)) continue;
            result.add(l);
        }
        return result;
    }

    private static boolean lookupMatch(JSContext ctx, Locale locale, boolean stripIt) {
        Locale lookForLocale = stripIt ? locale.stripExtensions() : locale;
        Set<Locale> availableLocales = IntlUtil.getAvailableLocales();
        if (availableLocales.contains(lookForLocale)) {
            return true;
        }
        if (ctx.getLocale().equals(lookForLocale)) {
            return true;
        }
        ULocale ulocale = ULocale.forLocale((Locale)lookForLocale);
        ulocale = ULocale.addLikelySubtags((ULocale)ulocale);
        return availableLocales.contains(ulocale.toLocale());
    }

    private static Set<Locale> getAvailableLocales() {
        return AVAILABLE_LOCALES.get();
    }

    private static Set<Locale> initAvailableLocales() {
        HashSet<Locale> result = new HashSet<Locale>();
        try {
            for (ULocale ul : ULocale.getAvailableLocales()) {
                result.add(ul.toLocale());
            }
        }
        catch (MissingResourceException e) {
            throw Errors.createICU4JDataError(e);
        }
        return result;
    }

    public static boolean isSupportedNumberSystemKey(String nuKey) {
        return BCP47_NU_KEYS.contains(nuKey) && !BANNED_BCP47_NU_KEYS.contains(nuKey);
    }

    @CompilerDirectives.TruffleBoundary
    public static Locale withoutUnicodeExtension(Locale originalLocale, String key) {
        if (!originalLocale.getUnicodeLocaleKeys().contains(key)) {
            return originalLocale;
        }
        String value = originalLocale.getUnicodeLocaleType(key);
        String originalTag = originalLocale.toLanguageTag();
        String toRemove = "-u-" + key + "-" + value;
        String strippedTag = originalTag.replace(toRemove, "");
        return new Locale(strippedTag);
    }

    @CompilerDirectives.TruffleBoundary
    public static void ensureIsStructurallyValidLanguageTag(String languageTag) {
        IntlUtil.createValidatedLocale(languageTag);
    }

    private static Locale createValidatedLocale(String languageTag) throws JSException {
        try {
            return new Locale.Builder().setLanguageTag(languageTag).build();
        }
        catch (IllformedLocaleException e) {
            throw Errors.createRangeError(e.getMessage());
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static String validateAndCanonicalizeLanguageTag(String languageTag) {
        return IntlUtil.createValidatedLocale(languageTag).toLanguageTag();
    }

    @CompilerDirectives.TruffleBoundary
    public static String toUpperCase(String in) {
        StringBuilder result = new StringBuilder(in.length());
        for (int i = 0; i < in.length(); ++i) {
            int c = in.codePointAt(i);
            if (c >= 97 && c <= 122) {
                result.append((char)(c - 32));
                continue;
            }
            result.append((char)c);
        }
        return result.toString();
    }

    @CompilerDirectives.TruffleBoundary
    public static String toLowerCase(JSContext ctx, String s, String[] locales) {
        Locale strippedLocale = IntlUtil.selectedLocaleStripped(ctx, locales);
        StringBuilder result = new StringBuilder();
        CaseMap.Lower tr = CaseMap.toLower();
        tr.apply(strippedLocale, (CharSequence)s, (Appendable)result, null);
        return result.toString();
    }

    @CompilerDirectives.TruffleBoundary
    public static String toUpperCase(JSContext ctx, String s, String[] locales) {
        Locale strippedLocale = IntlUtil.selectedLocaleStripped(ctx, locales);
        StringBuilder result = new StringBuilder();
        CaseMap.Upper tr = CaseMap.toUpper();
        tr.apply(strippedLocale, (CharSequence)s, (Appendable)result, null);
        return result.toString();
    }

    @CompilerDirectives.TruffleBoundary
    public static Locale selectedLocaleStripped(JSContext ctx, String[] locales) {
        String selectedTag = IntlUtil.selectedLocale(ctx, locales);
        Locale selectedLocale = selectedTag != null ? Locale.forLanguageTag(selectedTag) : ctx.getLocale();
        return selectedLocale.stripExtensions();
    }

    public static DynamicObject makePart(JSContext context, String type, String value) {
        return IntlUtil.makePart(context, type, value, null);
    }

    public static DynamicObject makePart(JSContext context, String type, String value, String unit) {
        DynamicObject p = JSUserObject.create(context);
        JSObject.set(p, TYPE, (Object)type);
        JSObject.set(p, VALUE, (Object)value);
        if (unit != null) {
            JSObject.set(p, UNIT, (Object)unit);
        }
        return p;
    }
}

