/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.matchers;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.regex.tregex.matchers.InvertibleCharMatcher;
import com.oracle.truffle.regex.tregex.matchers.TwoCharMatcherNodeGen;
import com.oracle.truffle.regex.tregex.util.DebugUtil;

public abstract class TwoCharMatcher
extends InvertibleCharMatcher {
    private final char c1;
    private final char c2;

    TwoCharMatcher(boolean invert, char c1, char c2) {
        super(invert);
        this.c1 = c1;
        this.c2 = c2;
    }

    public static TwoCharMatcher create(boolean invert, char c1, char c2) {
        return TwoCharMatcherNodeGen.create(invert, c1, c2);
    }

    @Specialization
    public boolean match(char m, boolean compactString) {
        return this.result((!compactString || this.c1 < '\u0100') && m == this.c1 || (!compactString || this.c2 < '\u0100') && m == this.c2);
    }

    @Override
    public int estimatedCost() {
        return 2;
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        return this.modifiersToString() + DebugUtil.charToString(this.c1) + "||" + DebugUtil.charToString(this.c2);
    }
}

