/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.server.redis;

import io.debezium.server.redis.RedisStreamChangeConsumerConfig;
import io.debezium.storage.redis.RedisClient;
import io.debezium.util.IoUtil;
import io.smallrye.mutiny.tuples.Tuple2;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisMemoryThreshold {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisMemoryThreshold.class);
    private static final String INFO_MEMORY = "memory";
    private static final String INFO_MEMORY_SECTION_MAXMEMORY = "maxmemory";
    private static final String INFO_MEMORY_SECTION_USEDMEMORY = "used_memory";
    private static final Supplier<Boolean> MEMORY_OK = () -> true;
    private RedisClient client;
    private int memoryThreshold;
    private long memoryLimit;
    private Supplier<Boolean> isMemoryOk;

    public RedisMemoryThreshold(RedisClient client, RedisStreamChangeConsumerConfig config) {
        this.client = client;
        this.memoryThreshold = config.getMemoryThreshold();
        this.memoryLimit = 0x100000L * (long)config.getMemoryLimitMb();
        if (this.memoryThreshold == 0 || this.memoryTuple(this.memoryLimit) == null) {
            this.disable();
        } else {
            this.isMemoryOk = () -> this.isMemoryOk();
        }
    }

    public boolean check() {
        return this.isMemoryOk.get();
    }

    private boolean isMemoryOk() {
        long usedMemory;
        long percentage;
        Tuple2<Long, Long> memoryTuple = this.memoryTuple(this.memoryLimit);
        if (memoryTuple == null) {
            this.disable();
            return true;
        }
        long maxMemory = (Long)memoryTuple.getItem2();
        if (maxMemory > 0L && (percentage = (usedMemory = ((Long)memoryTuple.getItem1()).longValue()) * 100L / maxMemory) >= (long)this.memoryThreshold) {
            LOGGER.warn("Memory threshold percentage was reached (current: {}%, configured: {}%, used_memory: {}, maxmemory: {}).", new Object[]{percentage, this.memoryThreshold, usedMemory, maxMemory});
            return false;
        }
        return true;
    }

    private Tuple2<Long, Long> memoryTuple(long defaultMaxMemory) {
        String memory = this.client.info(INFO_MEMORY);
        HashMap infoMemory = new HashMap();
        try {
            IoUtil.readLines((InputStream)new ByteArrayInputStream(memory.getBytes(StandardCharsets.UTF_8)), line -> {
                String[] pair = line.split(":");
                if (pair.length == 2) {
                    infoMemory.put(pair[0], pair[1]);
                }
            });
        }
        catch (IOException e) {
            LOGGER.error("Cannot parse Redis 'info memory' result '{}'.", (Object)memory, (Object)e);
            return null;
        }
        Long usedMemory = this.parseLong(INFO_MEMORY_SECTION_USEDMEMORY, (String)infoMemory.get(INFO_MEMORY_SECTION_USEDMEMORY));
        if (usedMemory == null) {
            return null;
        }
        Long maxMemory = this.parseLong(INFO_MEMORY_SECTION_MAXMEMORY, (String)infoMemory.get(INFO_MEMORY_SECTION_MAXMEMORY));
        if (maxMemory == null) {
            if (defaultMaxMemory == 0L) {
                LOGGER.warn("Memory limit is disabled '{}'.", (Object)defaultMaxMemory);
                return null;
            }
            LOGGER.debug("Using memory limit with value '{}'.", (Object)defaultMaxMemory);
            maxMemory = defaultMaxMemory;
        } else if (maxMemory == 0L) {
            LOGGER.debug("Redis 'info memory' field '{}' is {}. Consider configuring it.", (Object)INFO_MEMORY_SECTION_MAXMEMORY, (Object)maxMemory);
            if (defaultMaxMemory > 0L) {
                maxMemory = defaultMaxMemory;
                LOGGER.debug("Using memory limit with value '{}'.", (Object)defaultMaxMemory);
            }
        }
        return Tuple2.of((Object)usedMemory, (Object)maxMemory);
    }

    private void disable() {
        this.isMemoryOk = MEMORY_OK;
        LOGGER.warn("Memory threshold percentage check is disabled!");
    }

    private Long parseLong(String name, String value) {
        try {
            return Long.valueOf(value);
        }
        catch (NumberFormatException e) {
            LOGGER.debug("Cannot parse Redis 'info memory' field '{}' with value '{}'.", (Object)name, (Object)value);
            return null;
        }
    }
}

