/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.impl.ConsumerInterceptors;
import org.apache.pulsar.client.impl.MultiTopicsConsumerImpl;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.apache.pulsar.client.impl.conf.ConsumerConfigurationData;
import org.apache.pulsar.client.util.ExecutorProvider;
import org.apache.pulsar.common.api.proto.CommandGetTopicsOfNamespace;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.shade.com.google.common.annotations.VisibleForTesting;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shade.com.google.common.collect.Lists;
import org.apache.pulsar.shade.io.netty.util.Timeout;
import org.apache.pulsar.shade.io.netty.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatternMultiTopicsConsumerImpl<T>
extends MultiTopicsConsumerImpl<T>
implements TimerTask {
    private final Pattern topicsPattern;
    private final TopicsChangedListener topicsChangeListener;
    private final CommandGetTopicsOfNamespace.Mode subscriptionMode;
    protected NamespaceName namespaceName;
    private volatile Timeout recheckPatternTimeout = null;
    private static final Logger log = LoggerFactory.getLogger(PatternMultiTopicsConsumerImpl.class);

    public PatternMultiTopicsConsumerImpl(Pattern topicsPattern, PulsarClientImpl client, ConsumerConfigurationData<T> conf, ExecutorProvider executorProvider, CompletableFuture<Consumer<T>> subscribeFuture, Schema<T> schema, CommandGetTopicsOfNamespace.Mode subscriptionMode, ConsumerInterceptors<T> interceptors) {
        super(client, conf, executorProvider, subscribeFuture, schema, interceptors, false);
        this.topicsPattern = topicsPattern;
        this.subscriptionMode = subscriptionMode;
        if (this.namespaceName == null) {
            this.namespaceName = PatternMultiTopicsConsumerImpl.getNameSpaceFromPattern(topicsPattern);
        }
        Preconditions.checkArgument(PatternMultiTopicsConsumerImpl.getNameSpaceFromPattern(topicsPattern).toString().equals(this.namespaceName.toString()));
        this.topicsChangeListener = new PatternTopicsChangedListener();
        this.recheckPatternTimeout = client.timer().newTimeout(this, Math.max(1, conf.getPatternAutoDiscoveryPeriod()), TimeUnit.SECONDS);
    }

    public static NamespaceName getNameSpaceFromPattern(Pattern pattern) {
        return TopicName.get(pattern.pattern()).getNamespaceObject();
    }

    @Override
    public void run(Timeout timeout) throws Exception {
        if (timeout.isCancelled()) {
            return;
        }
        ((CompletableFuture)((CompletableFuture)this.client.getLookup().getTopicsUnderNamespace(this.namespaceName, this.subscriptionMode).thenCompose(topics -> {
            if (log.isDebugEnabled()) {
                log.debug("Get topics under namespace {}, topics.size: {}", (Object)this.namespaceName.toString(), (Object)topics.size());
                topics.forEach(topicName -> log.debug("Get topics under namespace {}, topic: {}", (Object)this.namespaceName.toString(), topicName));
            }
            List<String> newTopics = PulsarClientImpl.topicsPatternFilter(topics, this.topicsPattern);
            ArrayList<String> oldTopics = new ArrayList<String>(this.getPartitionedTopics());
            for (String partition : this.getPartitions()) {
                TopicName topicName2 = TopicName.get(partition);
                if (topicName2.isPartitioned() && oldTopics.contains(topicName2.getPartitionedTopicName())) continue;
                oldTopics.add(partition);
            }
            ArrayList<CompletableFuture<Void>> listenersCallback = new ArrayList<CompletableFuture<Void>>(2);
            listenersCallback.add(this.topicsChangeListener.onTopicsAdded(PatternMultiTopicsConsumerImpl.topicsListsMinus(newTopics, oldTopics)));
            listenersCallback.add(this.topicsChangeListener.onTopicsRemoved(PatternMultiTopicsConsumerImpl.topicsListsMinus(oldTopics, newTopics)));
            return FutureUtil.waitForAll(Collections.unmodifiableList(listenersCallback));
        })).exceptionally(ex -> {
            log.warn("[{}] Failed to recheck topics change: {}", (Object)this.topic, (Object)ex.getMessage());
            return null;
        })).thenAccept(__ -> {
            this.recheckPatternTimeout = this.client.timer().newTimeout(this, Math.max(1, this.conf.getPatternAutoDiscoveryPeriod()), TimeUnit.SECONDS);
        });
    }

    public Pattern getPattern() {
        return this.topicsPattern;
    }

    public static List<String> topicsListsMinus(List<String> list1, List<String> list2) {
        HashSet<String> s1 = new HashSet<String>(list1);
        s1.removeAll(list2);
        return s1.stream().collect(Collectors.toList());
    }

    @Override
    public CompletableFuture<Void> closeAsync() {
        Timeout timeout = this.recheckPatternTimeout;
        if (timeout != null) {
            timeout.cancel();
            this.recheckPatternTimeout = null;
        }
        return super.closeAsync();
    }

    @VisibleForTesting
    Timeout getRecheckPatternTimeout() {
        return this.recheckPatternTimeout;
    }

    private class PatternTopicsChangedListener
    implements TopicsChangedListener {
        private PatternTopicsChangedListener() {
        }

        @Override
        public CompletableFuture<Void> onTopicsRemoved(Collection<String> removedTopics) {
            CompletableFuture<Void> removeFuture = new CompletableFuture<Void>();
            if (removedTopics.isEmpty()) {
                removeFuture.complete(null);
                return removeFuture;
            }
            ArrayList futures = Lists.newArrayListWithExpectedSize(PatternMultiTopicsConsumerImpl.this.partitionedTopics.size());
            removedTopics.stream().forEach(topic -> futures.add(PatternMultiTopicsConsumerImpl.this.removeConsumerAsync((String)topic)));
            ((CompletableFuture)FutureUtil.waitForAll(futures).thenAccept(finalFuture -> removeFuture.complete(null))).exceptionally(ex -> {
                log.warn("[{}] Failed to subscribe topics: {}", (Object)PatternMultiTopicsConsumerImpl.this.topic, (Object)ex.getMessage());
                removeFuture.completeExceptionally((Throwable)ex);
                return null;
            });
            return removeFuture;
        }

        @Override
        public CompletableFuture<Void> onTopicsAdded(Collection<String> addedTopics) {
            CompletableFuture<Void> addFuture = new CompletableFuture<Void>();
            if (addedTopics.isEmpty()) {
                addFuture.complete(null);
                return addFuture;
            }
            ArrayList futures = Lists.newArrayListWithExpectedSize(PatternMultiTopicsConsumerImpl.this.partitionedTopics.size());
            addedTopics.stream().forEach(topic -> futures.add(PatternMultiTopicsConsumerImpl.this.subscribeAsync((String)topic, false)));
            ((CompletableFuture)FutureUtil.waitForAll(futures).thenAccept(finalFuture -> addFuture.complete(null))).exceptionally(ex -> {
                log.warn("[{}] Failed to unsubscribe topics: {}", (Object)PatternMultiTopicsConsumerImpl.this.topic, (Object)ex.getMessage());
                addFuture.completeExceptionally((Throwable)ex);
                return null;
            });
            return addFuture;
        }
    }

    static interface TopicsChangedListener {
        public CompletableFuture<Void> onTopicsRemoved(Collection<String> var1);

        public CompletableFuture<Void> onTopicsAdded(Collection<String> var1);
    }
}

