/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.shared.controller.event;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.ObjectBuilder;
import io.pravega.common.io.serialization.RevisionDataInput;
import io.pravega.common.io.serialization.RevisionDataOutput;
import io.pravega.common.io.serialization.VersionedSerializer;
import io.pravega.shared.controller.event.ControllerEvent;
import io.pravega.shared.controller.event.RequestProcessor;
import io.pravega.shared.controller.event.StreamRequestProcessor;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;

public class AbortEvent
implements ControllerEvent {
    private static final long serialVersionUID = 1L;
    private final String scope;
    private final String stream;
    private final int epoch;
    private final UUID txid;

    @Override
    public String getKey() {
        return String.format("%s/%s", this.scope, this.stream);
    }

    @Override
    public CompletableFuture<Void> process(RequestProcessor processor) {
        return ((StreamRequestProcessor)processor).processAbortTxnRequest(this);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static AbortEventBuilder builder() {
        return new AbortEventBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getScope() {
        return this.scope;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getStream() {
        return this.stream;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getEpoch() {
        return this.epoch;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public UUID getTxid() {
        return this.txid;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbortEvent)) {
            return false;
        }
        AbortEvent other = (AbortEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$scope = this.getScope();
        String other$scope = other.getScope();
        if (this$scope == null ? other$scope != null : !this$scope.equals(other$scope)) {
            return false;
        }
        String this$stream = this.getStream();
        String other$stream = other.getStream();
        if (this$stream == null ? other$stream != null : !this$stream.equals(other$stream)) {
            return false;
        }
        if (this.getEpoch() != other.getEpoch()) {
            return false;
        }
        UUID this$txid = this.getTxid();
        UUID other$txid = other.getTxid();
        return !(this$txid == null ? other$txid != null : !((Object)this$txid).equals(other$txid));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AbortEvent;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
        String $stream = this.getStream();
        result = result * 59 + ($stream == null ? 43 : $stream.hashCode());
        result = result * 59 + this.getEpoch();
        UUID $txid = this.getTxid();
        result = result * 59 + ($txid == null ? 43 : ((Object)$txid).hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "AbortEvent(scope=" + this.getScope() + ", stream=" + this.getStream() + ", epoch=" + this.getEpoch() + ", txid=" + this.getTxid() + ")";
    }

    @ConstructorProperties(value={"scope", "stream", "epoch", "txid"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public AbortEvent(String scope, String stream, int epoch, UUID txid) {
        this.scope = scope;
        this.stream = stream;
        this.epoch = epoch;
        this.txid = txid;
    }

    public static class Serializer
    extends VersionedSerializer.WithBuilder<AbortEvent, AbortEventBuilder> {
        protected AbortEventBuilder newBuilder() {
            return AbortEvent.builder();
        }

        protected byte getWriteVersion() {
            return 0;
        }

        protected void declareVersions() {
            this.version(0).revision(0, this::write00, this::read00);
        }

        private void write00(AbortEvent e, RevisionDataOutput target) throws IOException {
            target.writeUTF(e.scope);
            target.writeUTF(e.stream);
            target.writeCompactInt(e.epoch);
            target.writeUUID(e.txid);
        }

        private void read00(RevisionDataInput source, AbortEventBuilder b) throws IOException {
            b.scope(source.readUTF());
            b.stream(source.readUTF());
            b.epoch(source.readCompactInt());
            b.txid(source.readUUID());
        }
    }

    private static class AbortEventBuilder
    implements ObjectBuilder<AbortEvent> {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String scope;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String stream;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int epoch;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private UUID txid;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        AbortEventBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public AbortEventBuilder scope(String scope) {
            this.scope = scope;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public AbortEventBuilder stream(String stream) {
            this.stream = stream;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public AbortEventBuilder epoch(int epoch) {
            this.epoch = epoch;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public AbortEventBuilder txid(UUID txid) {
            this.txid = txid;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public AbortEvent build() {
            return new AbortEvent(this.scope, this.stream, this.epoch, this.txid);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "AbortEvent.AbortEventBuilder(scope=" + this.scope + ", stream=" + this.stream + ", epoch=" + this.epoch + ", txid=" + this.txid + ")";
        }
    }
}

