/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventhubs.implementation;

import com.azure.core.amqp.AmqpEndpointState;
import com.azure.core.amqp.exception.AmqpErrorCondition;
import com.azure.core.amqp.exception.AmqpException;
import com.azure.core.amqp.exception.LinkErrorContext;
import com.azure.core.amqp.implementation.AmqpReceiveLink;
import com.azure.core.util.logging.ClientLogger;
import java.util.Deque;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.apache.qpid.proton.message.Message;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Disposable;
import reactor.core.Disposables;
import reactor.core.Exceptions;
import reactor.core.publisher.BufferOverflowStrategy;
import reactor.core.publisher.FluxProcessor;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Operators;
import reactor.core.scheduler.Schedulers;
import reactor.util.context.Context;

public class AmqpReceiveLinkProcessor
extends FluxProcessor<AmqpReceiveLink, Message>
implements Subscription {
    private static final ClientLogger LOGGER = new ClientLogger(AmqpReceiveLinkProcessor.class);
    private final Object lock = new Object();
    private final AtomicBoolean isTerminated = new AtomicBoolean();
    private final AtomicInteger retryAttempts = new AtomicInteger();
    private final Deque<Message> messageQueue = new ConcurrentLinkedDeque<Message>();
    private final AtomicBoolean linkHasNoCredits = new AtomicBoolean();
    private final Object creditsAdded = new Object();
    private final AtomicReference<CoreSubscriber<? super Message>> downstream = new AtomicReference();
    private final AtomicInteger wip = new AtomicInteger();
    private final int prefetch;
    private final String entityPath;
    private final Disposable connectionProcessor;
    private final int maxQueueSize;
    private volatile Throwable lastError;
    private volatile boolean isCancelled;
    private volatile AmqpReceiveLink currentLink;
    private volatile String currentLinkName;
    private volatile Disposable currentLinkSubscriptions;
    private volatile Subscription upstream;
    private static final AtomicReferenceFieldUpdater<AmqpReceiveLinkProcessor, Subscription> UPSTREAM = AtomicReferenceFieldUpdater.newUpdater(AmqpReceiveLinkProcessor.class, Subscription.class, "upstream");
    private volatile long requested;
    private static final AtomicLongFieldUpdater<AmqpReceiveLinkProcessor> REQUESTED = AtomicLongFieldUpdater.newUpdater(AmqpReceiveLinkProcessor.class, "requested");

    public AmqpReceiveLinkProcessor(String entityPath, int prefetch, Disposable connectionProcessor) {
        this.entityPath = Objects.requireNonNull(entityPath, "'entityPath' cannot be null.");
        this.connectionProcessor = Objects.requireNonNull(connectionProcessor, "'connectionProcessor' cannot be null.");
        if (prefetch < 0) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'prefetch' cannot be less than 0."));
        }
        this.prefetch = prefetch;
        this.maxQueueSize = prefetch * 2;
    }

    public Throwable getError() {
        return this.lastError;
    }

    public boolean isTerminated() {
        return this.isTerminated.get() || this.isCancelled;
    }

    public void onSubscribe(Subscription subscription) {
        Objects.requireNonNull(subscription, "'subscription' cannot be null");
        LOGGER.info("Setting new subscription for receive link processor");
        if (!Operators.setOnce(UPSTREAM, (Object)((Object)this), (Subscription)subscription)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("Cannot set upstream twice."));
        }
        this.requestUpstream();
    }

    public int getPrefetch() {
        return this.prefetch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNext(AmqpReceiveLink next) {
        Disposable oldSubscription;
        AmqpReceiveLink oldChannel;
        Objects.requireNonNull(next, "'next' cannot be null.");
        if (this.isTerminated()) {
            LOGGER.atWarning().addKeyValue("linkName", next.getLinkName()).addKeyValue("entityPath", next.getEntityPath()).log("Got another link when we have already terminated processor.");
            Operators.onNextDropped((Object)next, (Context)this.currentContext());
            return;
        }
        String linkName = next.getLinkName();
        LOGGER.atInfo().addKeyValue("linkName", linkName).addKeyValue("entityPath", next.getEntityPath()).log("Setting next AMQP receive link.");
        Object object = this.lock;
        synchronized (object) {
            oldChannel = this.currentLink;
            oldSubscription = this.currentLinkSubscriptions;
            this.currentLink = next;
            this.currentLinkName = next.getLinkName();
            next.setEmptyCreditListener(() -> {
                int credits;
                Object object = this.creditsAdded;
                synchronized (object) {
                    credits = this.getCreditsToAdd();
                    if (credits < 1) {
                        this.linkHasNoCredits.compareAndSet(false, true);
                    } else {
                        LOGGER.atInfo().addKeyValue("linkName", linkName).addKeyValue("entityPath", next.getEntityPath()).addKeyValue("credits", (long)credits).log("Link is empty. Adding more credits.");
                    }
                }
                return credits;
            });
            this.currentLinkSubscriptions = Disposables.composite((Disposable[])new Disposable[]{next.getEndpointStates().filter(e -> e == AmqpEndpointState.ACTIVE).next().flatMap(state -> {
                Mono operation;
                Object object = this.creditsAdded;
                synchronized (object) {
                    int creditsToAdd = this.getCreditsToAdd();
                    int total = Math.max(this.prefetch, creditsToAdd);
                    LOGGER.atVerbose().addKeyValue("linkName", linkName).addKeyValue("prefetch", (long)this.prefetch).addKeyValue("credits", (long)creditsToAdd).log("Adding initial credits.");
                    operation = next.addCredits(total);
                }
                return operation;
            }).subscribe(noop -> {}, error -> LOGGER.atInfo().addKeyValue("linkName", linkName).log("Link was already closed. Could not add credits.")), next.getEndpointStates().subscribeOn(Schedulers.boundedElastic()).subscribe(state -> {
                if (state == AmqpEndpointState.ACTIVE) {
                    LOGGER.atInfo().addKeyValue("linkName", linkName).addKeyValue("credits", (long)next.getCredits()).log("Link is active.");
                    this.retryAttempts.set(0);
                }
            }, error -> {
                AmqpException amqpException;
                if (error instanceof AmqpException && (amqpException = (AmqpException)error).getErrorCondition() == AmqpErrorCondition.LINK_STOLEN && amqpException.getContext() != null && amqpException.getContext() instanceof LinkErrorContext) {
                    LinkErrorContext errorContext = (LinkErrorContext)amqpException.getContext();
                    if (this.currentLink != null && !this.currentLink.getLinkName().equals(errorContext.getTrackingId())) {
                        LOGGER.atInfo().addKeyValue("linkName", linkName).addKeyValue("entityPath", this.entityPath).addKeyValue("trackingId", errorContext.getTrackingId()).log("Link lost signal received for a link that is not current. Ignoring the error.");
                        return;
                    }
                }
                this.currentLink = null;
                this.onError((Throwable)error);
            }, () -> {
                if (this.connectionProcessor.isDisposed() || this.isTerminated() || UPSTREAM.get(this) == Operators.cancelledSubscription()) {
                    LOGGER.atInfo().addKeyValue("linkName", linkName).addKeyValue("entityPath", this.entityPath).log("Terminal state reached. Disposing of link processor.");
                    this.dispose();
                } else {
                    LOGGER.atInfo().addKeyValue("linkName", linkName).addKeyValue("entityPath", this.entityPath).log("Receive link endpoint states are closed. Requesting another.");
                    AmqpReceiveLink existing = this.currentLink;
                    this.currentLink = null;
                    this.currentLinkName = null;
                    this.disposeReceiver(existing);
                    this.requestUpstream();
                }
            }), next.receive().onBackpressureBuffer(this.maxQueueSize, BufferOverflowStrategy.ERROR).subscribe(message -> {
                this.messageQueue.add((Message)message);
                this.drain();
            }, error -> LOGGER.atVerbose().addKeyValue("linkName", linkName).addKeyValue("entityPath", this.entityPath).log("Receiver is terminated.", new Object[]{error}))});
        }
        this.disposeReceiver(oldChannel);
        if (oldSubscription != null) {
            oldSubscription.dispose();
        }
    }

    public void subscribe(CoreSubscriber<? super Message> actual) {
        boolean terminateSubscriber;
        Objects.requireNonNull(actual, "'actual' cannot be null.");
        boolean bl = terminateSubscriber = this.isTerminated() || this.currentLink == null && this.upstream == Operators.cancelledSubscription();
        if (this.isTerminated()) {
            LOGGER.atInfo().addKeyValue("linkName", this.currentLinkName).addKeyValue("entityPath", this.entityPath).log("AmqpReceiveLink is already terminated.");
        } else if (this.currentLink == null && this.upstream == Operators.cancelledSubscription()) {
            LOGGER.info("There is no current link and upstream is terminated.");
        }
        if (terminateSubscriber) {
            actual.onSubscribe(Operators.emptySubscription());
            if (this.hasError()) {
                actual.onError(this.lastError);
            } else {
                actual.onComplete();
            }
            return;
        }
        if (this.downstream.compareAndSet(null, actual)) {
            actual.onSubscribe((Subscription)this);
            this.drain();
        } else {
            Operators.error(actual, (Throwable)LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("There is already one downstream subscriber.'")));
        }
    }

    public void onError(Throwable throwable) {
        Objects.requireNonNull(throwable, "'throwable' is required.");
        LOGGER.atInfo().addKeyValue("linkName", this.currentLinkName).log("Error on receive link.", new Object[]{throwable});
        if (this.isTerminated() || this.isCancelled) {
            LOGGER.atInfo().addKeyValue("linkName", this.currentLinkName).log("AmqpReceiveLinkProcessor is terminated. Cannot process another error.", new Object[]{throwable});
            Operators.onErrorDropped((Throwable)throwable, (Context)this.currentContext());
            return;
        }
        if (this.connectionProcessor.isDisposed()) {
            LOGGER.atInfo().addKeyValue("linkName", this.currentLinkName).log("Parent connection is disposed. Not reopening on error.");
        }
        this.lastError = throwable;
        this.isTerminated.set(true);
        CoreSubscriber<? super Message> subscriber = this.downstream.get();
        if (subscriber != null) {
            subscriber.onError(throwable);
        }
        this.onDispose();
    }

    public void onComplete() {
        LOGGER.atInfo().addKeyValue("linkName", this.currentLinkName).log("Receive link completed from upstream.");
        UPSTREAM.set(this, Operators.cancelledSubscription());
    }

    public void dispose() {
        if (this.isTerminated.getAndSet(true)) {
            return;
        }
        LOGGER.atInfo().addKeyValue("linkName", this.currentLinkName).log("Disposing receive link.");
        this.drain();
        this.onDispose();
    }

    public void request(long request) {
        if (!Operators.validate((long)request)) {
            LOGGER.warning("Invalid request: {}", new Object[]{request});
            return;
        }
        Operators.addCap(REQUESTED, (Object)((Object)this), (long)request);
        this.addCreditsToLink("Backpressure request from downstream. Request: " + request);
        this.drain();
    }

    public void cancel() {
        if (this.isCancelled) {
            return;
        }
        this.isCancelled = true;
        this.drain();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestUpstream() {
        if (this.isTerminated()) {
            LOGGER.info("Processor is terminated. Not requesting another link.");
            return;
        }
        if (UPSTREAM.get(this) == null) {
            LOGGER.info("There is no upstream. Not requesting another link.");
            return;
        }
        if (UPSTREAM.get(this) == Operators.cancelledSubscription()) {
            LOGGER.info("Upstream is cancelled or complete. Not requesting another link.");
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.currentLink != null) {
                LOGGER.info("Current link exists. Not requesting another link.");
                return;
            }
        }
        LOGGER.info("Requesting a new AmqpReceiveLink from upstream.");
        UPSTREAM.get(this).request(1L);
    }

    private void onDispose() {
        this.disposeReceiver(this.currentLink);
        this.currentLink = null;
        this.currentLinkName = null;
        if (this.currentLinkSubscriptions != null) {
            this.currentLinkSubscriptions.dispose();
        }
        Operators.onDiscardQueueWithClear(this.messageQueue, (Context)this.currentContext(), null);
    }

    private void drain() {
        if (this.wip.getAndIncrement() != 0) {
            return;
        }
        int missed = 1;
        while (missed != 0) {
            this.drainQueue();
            missed = this.wip.addAndGet(-missed);
        }
    }

    private void drainQueue() {
        CoreSubscriber<? super Message> subscriber = this.downstream.get();
        if (subscriber == null || this.checkAndSetTerminated()) {
            return;
        }
        long numberRequested = REQUESTED.get(this);
        boolean isEmpty = this.messageQueue.isEmpty();
        while (numberRequested != 0L && !isEmpty && !this.checkAndSetTerminated()) {
            Message message;
            long numberEmitted;
            for (numberEmitted = 0L; !(numberRequested == numberEmitted || isEmpty && this.checkAndSetTerminated() || (message = this.messageQueue.poll()) == null); ++numberEmitted) {
                if (this.isCancelled) {
                    Operators.onDiscard((Object)message, (Context)subscriber.currentContext());
                    Operators.onDiscardQueueWithClear(this.messageQueue, (Context)subscriber.currentContext(), null);
                    return;
                }
                try {
                    subscriber.onNext((Object)message);
                }
                catch (Exception e) {
                    LOGGER.atError().addKeyValue("linkName", this.currentLinkName).addKeyValue("entityPath", this.entityPath).log("Exception occurred while handling downstream onNext operation.", new Object[]{e});
                    throw LOGGER.logExceptionAsError(Exceptions.propagate((Throwable)Operators.onOperatorError((Subscription)this.upstream, (Throwable)e, (Object)message, (Context)subscriber.currentContext())));
                }
                isEmpty = this.messageQueue.isEmpty();
            }
            long requestedMessages = REQUESTED.get(this);
            if (requestedMessages == Long.MAX_VALUE) continue;
            numberRequested = REQUESTED.addAndGet(this, -numberEmitted);
        }
        AmqpReceiveLink link = this.currentLink;
        if (numberRequested > 0L && isEmpty && link != null && link.getCredits() <= 0) {
            this.addCreditsToLink("Adding more credits in drain loop.");
        }
    }

    private boolean checkAndSetTerminated() {
        if (!this.isTerminated()) {
            return false;
        }
        CoreSubscriber<? super Message> subscriber = this.downstream.get();
        Throwable error = this.lastError;
        if (error != null) {
            subscriber.onError(error);
        } else {
            subscriber.onComplete();
        }
        this.disposeReceiver(this.currentLink);
        this.messageQueue.clear();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCreditsToLink(String message) {
        Object object = this.creditsAdded;
        synchronized (object) {
            AmqpReceiveLink link = this.currentLink;
            int credits = this.getCreditsToAdd();
            if (link == null) {
                LOGGER.atVerbose().addKeyValue("entityPath", this.entityPath).addKeyValue("credits", (long)credits).log("There is no link to add credits to.");
                return;
            }
            String linkName = link.getLinkName();
            if (credits < 1) {
                LOGGER.atVerbose().addKeyValue("linkName", linkName).addKeyValue("entityPath", this.entityPath).addKeyValue("credits", (long)credits).log("There are no additional credits to add.");
                return;
            }
            int currentLinkCredits = link.getCredits();
            if (currentLinkCredits < this.prefetch) {
                LOGGER.atInfo().addKeyValue("linkName", linkName).addKeyValue("entityPath", this.entityPath).addKeyValue("credits", (long)credits).addKeyValue("message", message).log("Link running low on credits. Adding more.");
                link.addCredits(credits).subscribe(noop -> {}, error -> {
                    LOGGER.atInfo().addKeyValue("linkName", linkName).addKeyValue("entityPath", this.entityPath).log("Link was already closed. Could not add credits.");
                    this.linkHasNoCredits.compareAndSet(false, true);
                });
            }
        }
    }

    private int getCreditsToAdd() {
        int credits;
        CoreSubscriber<? super Message> subscriber = this.downstream.get();
        long request = REQUESTED.get(this);
        if (subscriber == null || request == 0L) {
            credits = 0;
        } else if (request == Long.MAX_VALUE) {
            credits = this.prefetch;
        } else {
            int remaining = Long.valueOf(request).intValue() - this.messageQueue.size();
            credits = Math.max(remaining, 0);
        }
        return credits;
    }

    private void disposeReceiver(AmqpReceiveLink link) {
        if (link == null) {
            return;
        }
        try {
            link.closeAsync().subscribe();
        }
        catch (Exception error) {
            LOGGER.atWarning().addKeyValue("linkName", link.getLinkName()).addKeyValue("entityPath", this.entityPath).log("Unable to dispose of link.", new Object[]{error});
        }
    }
}

