/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.hub.api.codegen.pre;

import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.combined.visitors.CombinedVisitorAdapter;
import io.apicurio.datamodels.core.models.ExtensibleNode;
import io.apicurio.datamodels.core.models.Extension;
import io.apicurio.datamodels.core.models.Node;
import io.apicurio.datamodels.core.models.common.Components;
import io.apicurio.datamodels.core.models.common.IDefinition;
import io.apicurio.datamodels.core.visitors.IVisitor;
import io.apicurio.datamodels.core.visitors.TraverserDirection;
import io.apicurio.datamodels.openapi.v2.models.Oas20Definitions;
import io.apicurio.datamodels.openapi.v3.models.Oas30Components;

public class OpenApiInlinedSchemaRemover
extends CombinedVisitorAdapter {
    public void visitSchemaDefinition(IDefinition def) {
        ExtensibleNode node = (ExtensibleNode)def;
        if (this.wasInlined(node)) {
            final String definitionName = def.getName();
            Library.visitTree((Node)node.ownerDocument(), (IVisitor)new CombinedVisitorAdapter(){

                public void visitComponents(Components node) {
                    Oas30Components components = (Oas30Components)node;
                    components.removeSchemaDefinition(definitionName);
                }

                public void visitDefinitions(Oas20Definitions node) {
                    node.removeDefinition(definitionName);
                }
            }, (TraverserDirection)TraverserDirection.down);
        }
    }

    private boolean wasInlined(ExtensibleNode node) {
        Extension inlinedExt = node.getExtension("x-codegen-inlined");
        if (inlinedExt == null) {
            return false;
        }
        return "true".equals(String.valueOf(inlinedExt.value));
    }
}

