/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.segment.impl;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.auth.InvalidTokenException;
import io.pravega.auth.TokenExpiredException;
import io.pravega.client.connection.impl.ConnectionPool;
import io.pravega.client.connection.impl.RawClient;
import io.pravega.client.control.impl.Controller;
import io.pravega.client.security.auth.DelegationTokenProvider;
import io.pravega.client.security.auth.DelegationTokenProviderFactory;
import io.pravega.client.segment.impl.NoSuchSegmentException;
import io.pravega.client.segment.impl.Segment;
import io.pravega.client.segment.impl.SegmentAttribute;
import io.pravega.client.segment.impl.SegmentInfo;
import io.pravega.client.segment.impl.SegmentMetadataClient;
import io.pravega.client.segment.impl.SegmentTruncatedException;
import io.pravega.client.stream.impl.ConnectionClosedException;
import io.pravega.common.Exceptions;
import io.pravega.common.concurrent.Futures;
import io.pravega.common.util.Retry;
import io.pravega.shared.protocol.netty.ConnectionFailedException;
import io.pravega.shared.protocol.netty.Reply;
import io.pravega.shared.protocol.netty.WireCommands;
import io.pravega.shared.security.auth.AccessOperation;
import java.beans.ConstructorProperties;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.concurrent.GuardedBy;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SegmentMetadataClientImpl
implements SegmentMetadataClient {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SegmentMetadataClientImpl.class);
    private static final Retry.RetryWithBackoff RETRY_SCHEDULE = Retry.withExpBackoff((long)1L, (int)10, (int)10, (long)30000L);
    private final Segment segmentId;
    private final Controller controller;
    private final ConnectionPool connectionPool;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private RawClient client = null;
    private final DelegationTokenProvider tokenProvider;

    @VisibleForTesting
    public SegmentMetadataClientImpl(Segment segment, Controller controller, ConnectionPool connectionPool, String delegationToken) {
        this(segment, controller, connectionPool, DelegationTokenProviderFactory.create(delegationToken, controller, segment, AccessOperation.READ));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeConnection(Reply badReply) {
        RawClient c;
        log.info("Closing connection as a result of receiving: {}", (Object)badReply);
        Object object = this.lock;
        synchronized (object) {
            c = this.client;
            this.client = null;
        }
        if (c != null) {
            try {
                c.close();
            }
            catch (Exception e) {
                log.warn("Exception tearing down connection: ", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeConnection(Throwable exceptionToInflightRequests) {
        RawClient c;
        log.debug("Closing connection with exception: {}", (Object)exceptionToInflightRequests.getMessage());
        Object object = this.lock;
        synchronized (object) {
            c = this.client;
            this.client = null;
        }
        if (c != null) {
            try {
                c.close();
            }
            catch (Exception e) {
                log.warn("Exception tearing down connection: ", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RawClient getConnection() {
        Object object = this.lock;
        synchronized (object) {
            if (this.client == null || this.client.isClosed()) {
                this.client = new RawClient(this.controller, this.connectionPool, this.segmentId);
            }
            return this.client;
        }
    }

    private <T extends Reply> T transformReply(Reply reply, Class<T> klass) {
        if (klass.isAssignableFrom(reply.getClass())) {
            return (T)reply;
        }
        this.closeConnection(reply);
        if (reply instanceof WireCommands.NoSuchSegment) {
            throw new NoSuchSegmentException(reply.toString());
        }
        if (reply instanceof WireCommands.WrongHost) {
            throw new ConnectionFailedException(reply.toString());
        }
        if (reply instanceof WireCommands.SegmentIsTruncated) {
            throw new ConnectionFailedException((Throwable)new SegmentTruncatedException(reply.toString()));
        }
        if (reply instanceof WireCommands.AuthTokenCheckFailed) {
            WireCommands.AuthTokenCheckFailed authTokenCheckReply = (WireCommands.AuthTokenCheckFailed)reply;
            if (authTokenCheckReply.isTokenExpired()) {
                log.info("Delegation token expired");
                this.tokenProvider.signalTokenExpired();
                throw new ConnectionFailedException((Throwable)new TokenExpiredException(authTokenCheckReply.toString()));
            }
            log.info("Delegation token invalid");
            throw new InvalidTokenException(authTokenCheckReply.toString());
        }
        throw new ConnectionFailedException("Unexpected reply of " + reply + " when expecting a " + klass.getName());
    }

    @VisibleForTesting
    CompletableFuture<WireCommands.StreamSegmentInfo> getStreamSegmentInfo() {
        log.debug("Getting segment info for segment: {}", (Object)this.segmentId);
        RawClient connection = this.getConnection();
        long requestId = connection.getFlow().getNextSequenceNumber();
        return ((CompletableFuture)this.tokenProvider.retrieveToken().thenCompose(token -> connection.sendRequest(requestId, new WireCommands.GetStreamSegmentInfo(requestId, this.segmentId.getScopedName(), token)))).thenApply(r -> this.transformReply((Reply)r, (Class)WireCommands.StreamSegmentInfo.class));
    }

    private CompletableFuture<WireCommands.SegmentAttribute> getPropertyAsync(UUID attributeId) {
        log.debug("Getting segment attribute: {}", (Object)attributeId);
        RawClient connection = this.getConnection();
        long requestId = connection.getFlow().getNextSequenceNumber();
        return ((CompletableFuture)this.tokenProvider.retrieveToken().thenCompose(token -> connection.sendRequest(requestId, new WireCommands.GetSegmentAttribute(requestId, this.segmentId.getScopedName(), attributeId, token)))).thenApply(r -> this.transformReply((Reply)r, (Class)WireCommands.SegmentAttribute.class));
    }

    private CompletableFuture<WireCommands.SegmentAttributeUpdated> updatePropertyAsync(UUID attributeId, long expected, long value) {
        log.trace("Updating segment attribute: {}", (Object)attributeId);
        RawClient connection = this.getConnection();
        long requestId = connection.getFlow().getNextSequenceNumber();
        return ((CompletableFuture)this.tokenProvider.retrieveToken().thenCompose(token -> connection.sendRequest(requestId, new WireCommands.UpdateSegmentAttribute(requestId, this.segmentId.getScopedName(), attributeId, value, expected, token)))).thenApply(r -> this.transformReply((Reply)r, (Class)WireCommands.SegmentAttributeUpdated.class));
    }

    private CompletableFuture<WireCommands.SegmentTruncated> truncateSegmentAsync(Segment segment, long offset, DelegationTokenProvider tokenProvider) {
        log.trace("Truncating segment: {}", (Object)segment);
        RawClient connection = this.getConnection();
        long requestId = connection.getFlow().getNextSequenceNumber();
        return ((CompletableFuture)tokenProvider.retrieveToken().thenCompose(token -> connection.sendRequest(requestId, new WireCommands.TruncateSegment(requestId, segment.getScopedName(), offset, token)))).thenApply(r -> this.transformReply((Reply)r, (Class)WireCommands.SegmentTruncated.class));
    }

    private CompletableFuture<WireCommands.SegmentSealed> sealSegmentAsync(Segment segment, DelegationTokenProvider tokenProvider) {
        log.trace("Sealing segment: {}", (Object)segment);
        RawClient connection = this.getConnection();
        long requestId = connection.getFlow().getNextSequenceNumber();
        return ((CompletableFuture)tokenProvider.retrieveToken().thenCompose(token -> connection.sendRequest(requestId, new WireCommands.SealSegment(requestId, segment.getScopedName(), token)))).thenApply(r -> this.transformReply((Reply)r, (Class)WireCommands.SegmentSealed.class));
    }

    @Override
    public long fetchCurrentSegmentLength() {
        Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
        WireCommands.StreamSegmentInfo result = (WireCommands.StreamSegmentInfo)RETRY_SCHEDULE.retryingOn(ConnectionFailedException.class).throwingOn(NoSuchSegmentException.class).run(() -> (WireCommands.StreamSegmentInfo)Futures.getThrowingException(this.getStreamSegmentInfo()));
        return result.getWriteOffset();
    }

    @Override
    public long fetchProperty(SegmentAttribute attribute) {
        Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
        WireCommands.SegmentAttribute result = (WireCommands.SegmentAttribute)RETRY_SCHEDULE.retryingOn(ConnectionFailedException.class).throwingOn(NoSuchSegmentException.class).run(() -> (WireCommands.SegmentAttribute)Futures.getThrowingException(this.getPropertyAsync(attribute.getValue())));
        return result.getValue();
    }

    @Override
    public boolean compareAndSetAttribute(SegmentAttribute attribute, long expectedValue, long newValue) {
        Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
        WireCommands.SegmentAttributeUpdated result = (WireCommands.SegmentAttributeUpdated)RETRY_SCHEDULE.retryingOn(ConnectionFailedException.class).throwingOn(NoSuchSegmentException.class).run(() -> (WireCommands.SegmentAttributeUpdated)Futures.getThrowingException(this.updatePropertyAsync(attribute.getValue(), expectedValue, newValue)));
        return result.isSuccess();
    }

    @Override
    public void close() {
        log.info("Closing segment metadata connection for {}", (Object)this.segmentId);
        if (this.closed.compareAndSet(false, true)) {
            this.closeConnection(new ConnectionClosedException());
        }
    }

    @Override
    public SegmentInfo getSegmentInfo() {
        WireCommands.StreamSegmentInfo info = (WireCommands.StreamSegmentInfo)RETRY_SCHEDULE.retryingOn(ConnectionFailedException.class).throwingOn(NoSuchSegmentException.class).run(() -> (WireCommands.StreamSegmentInfo)Futures.getThrowingException(this.getStreamSegmentInfo()));
        return new SegmentInfo(this.segmentId, info.getStartOffset(), info.getWriteOffset(), info.isSealed(), info.getLastModified());
    }

    @Override
    public void truncateSegment(long offset) {
        RETRY_SCHEDULE.retryingOn(ConnectionFailedException.class).throwingOn(NoSuchSegmentException.class).run(() -> {
            ((CompletableFuture)this.truncateSegmentAsync(this.segmentId, offset, this.tokenProvider).exceptionally(t -> {
                Throwable ex = Exceptions.unwrap((Throwable)t);
                if (ex.getCause() instanceof SegmentTruncatedException) {
                    log.debug("Segment already truncated at offset {}. Details: {}", (Object)offset, (Object)ex.getCause().getMessage());
                    return null;
                }
                throw new CompletionException(ex);
            })).join();
            return null;
        });
    }

    @Override
    public void sealSegment() {
        RETRY_SCHEDULE.retryingOn(ConnectionFailedException.class).throwingOn(NoSuchSegmentException.class).run(() -> {
            this.sealSegmentAsync(this.segmentId, this.tokenProvider).join();
            return null;
        });
    }

    @ConstructorProperties(value={"segmentId", "controller", "connectionPool", "tokenProvider"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SegmentMetadataClientImpl(Segment segmentId, Controller controller, ConnectionPool connectionPool, DelegationTokenProvider tokenProvider) {
        this.segmentId = segmentId;
        this.controller = controller;
        this.connectionPool = connectionPool;
        this.tokenProvider = tokenProvider;
    }
}

