/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import com.mongodb.ReadPreference;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.connector.SnapshotRecord;
import io.debezium.connector.mongodb.CollectionId;
import io.debezium.connector.mongodb.ConnectionContext;
import io.debezium.connector.mongodb.DisconnectEvent;
import io.debezium.connector.mongodb.MongoDbChangeSnapshotOplogRecordEmitter;
import io.debezium.connector.mongodb.MongoDbConnector;
import io.debezium.connector.mongodb.MongoDbConnectorConfig;
import io.debezium.connector.mongodb.MongoDbIncrementalSnapshotContext;
import io.debezium.connector.mongodb.MongoDbOffsetContext;
import io.debezium.connector.mongodb.MongoDbPartition;
import io.debezium.connector.mongodb.MongoDbTaskContext;
import io.debezium.connector.mongodb.MongoUtil;
import io.debezium.connector.mongodb.ReplicaSet;
import io.debezium.connector.mongodb.ReplicaSetOffsetContext;
import io.debezium.connector.mongodb.ReplicaSetPartition;
import io.debezium.connector.mongodb.ReplicaSets;
import io.debezium.connector.mongodb.SourceInfo;
import io.debezium.function.BlockingConsumer;
import io.debezium.pipeline.ConnectorEvent;
import io.debezium.pipeline.ErrorHandler;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.source.AbstractSnapshotChangeEventSource;
import io.debezium.pipeline.source.spi.ChangeEventSource;
import io.debezium.pipeline.source.spi.SnapshotProgressListener;
import io.debezium.pipeline.spi.ChangeRecordEmitter;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.Partition;
import io.debezium.pipeline.spi.SnapshotResult;
import io.debezium.pipeline.txmetadata.TransactionContext;
import io.debezium.spi.schema.DataCollectionId;
import io.debezium.util.Clock;
import io.debezium.util.Strings;
import io.debezium.util.Threads;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.kafka.connect.errors.ConnectException;
import org.bson.BsonDocument;
import org.bson.BsonTimestamp;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDbSnapshotChangeEventSource
extends AbstractSnapshotChangeEventSource<MongoDbPartition, MongoDbOffsetContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoDbSnapshotChangeEventSource.class);
    private static final String AUTHORIZATION_FAILURE_MESSAGE = "Command failed with error 13";
    private final MongoDbConnectorConfig connectorConfig;
    private final MongoDbTaskContext taskContext;
    private final ConnectionContext connectionContext;
    private final ReplicaSets replicaSets;
    private final EventDispatcher<MongoDbPartition, CollectionId> dispatcher;
    protected final Clock clock;
    private final SnapshotProgressListener<MongoDbPartition> snapshotProgressListener;
    private final ErrorHandler errorHandler;
    private AtomicBoolean aborted = new AtomicBoolean(false);

    public MongoDbSnapshotChangeEventSource(MongoDbConnectorConfig connectorConfig, MongoDbTaskContext taskContext, ReplicaSets replicaSets, EventDispatcher<MongoDbPartition, CollectionId> dispatcher, Clock clock, SnapshotProgressListener<MongoDbPartition> snapshotProgressListener, ErrorHandler errorHandler) {
        super((CommonConnectorConfig)connectorConfig, snapshotProgressListener);
        this.connectorConfig = connectorConfig;
        this.taskContext = taskContext;
        this.connectionContext = taskContext.getConnectionContext();
        this.replicaSets = replicaSets;
        this.dispatcher = dispatcher;
        this.clock = clock;
        this.snapshotProgressListener = snapshotProgressListener;
        this.errorHandler = errorHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SnapshotResult<MongoDbOffsetContext> doExecute(ChangeEventSource.ChangeEventSourceContext context, MongoDbOffsetContext previousOffset, AbstractSnapshotChangeEventSource.SnapshotContext<MongoDbPartition, MongoDbOffsetContext> snapshotContext, AbstractSnapshotChangeEventSource.SnapshottingTask snapshottingTask) throws Exception {
        MongoDbSnapshottingTask mongoDbSnapshottingTask = (MongoDbSnapshottingTask)snapshottingTask;
        MongoDbSnapshotContext mongoDbSnapshotContext = (MongoDbSnapshotContext)snapshotContext;
        LOGGER.info("Snapshot step 1 - Preparing");
        if (previousOffset != null && previousOffset.isSnapshotRunning()) {
            LOGGER.info("Previous snapshot was cancelled before completion; a new snapshot will be taken.");
        }
        LOGGER.info("Snapshot step 2 - Determining snapshot offsets");
        this.determineSnapshotOffsets(mongoDbSnapshotContext, this.replicaSets);
        List<ReplicaSet> replicaSetsToSnapshot = mongoDbSnapshottingTask.getReplicaSetsToSnapshot();
        int threads = replicaSetsToSnapshot.size();
        ExecutorService executor = Threads.newFixedThreadPool(MongoDbConnector.class, (String)this.taskContext.serverName(), (String)"replicator-snapshot", (int)threads);
        CountDownLatch latch = new CountDownLatch(threads);
        LOGGER.info("Ignoring unnamed replica sets: {}", this.replicaSets.unnamedReplicaSets());
        LOGGER.info("Starting {} thread(s) to snapshot replica sets: {}", (Object)threads, replicaSetsToSnapshot);
        LOGGER.info("Snapshot step 3 - Snapshotting data");
        replicaSetsToSnapshot.forEach(replicaSet -> executor.submit(() -> {
            try {
                this.taskContext.configureLoggingContext(replicaSet.replicaSetName());
                try {
                    this.snapshotReplicaSet(context, mongoDbSnapshotContext, (ReplicaSet)replicaSet);
                }
                finally {
                    MongoDbOffsetContext mongoDbOffsetContext = (MongoDbOffsetContext)snapshotContext.offset;
                }
            }
            catch (Throwable t) {
                LOGGER.error("Snapshot for replica set {} failed", (Object)replicaSet.replicaSetName(), (Object)t);
                this.errorHandler.setProducerThrowable(t);
            }
            finally {
                latch.countDown();
            }
        }));
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.aborted.set(true);
        }
        try {
            executor.shutdown();
        }
        finally {
            LOGGER.info("Stopping mongodb connections");
            this.taskContext.getConnectionContext().shutdown();
        }
        if (this.aborted.get()) {
            return SnapshotResult.aborted();
        }
        return SnapshotResult.completed((OffsetContext)((MongoDbOffsetContext)snapshotContext.offset));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractSnapshotChangeEventSource.SnapshottingTask getSnapshottingTask(MongoDbPartition partition, MongoDbOffsetContext previousOffset) {
        if (previousOffset == null) {
            LOGGER.info("No previous offset has been found");
            if (this.connectorConfig.getSnapshotMode().equals((Object)MongoDbConnectorConfig.SnapshotMode.NEVER)) {
                LOGGER.info("According to the connector configuration, no snapshot will occur.");
                return new MongoDbSnapshottingTask(Collections.emptyList());
            }
            return new MongoDbSnapshottingTask(this.replicaSets.all());
        }
        if (this.connectorConfig.getSnapshotMode().equals((Object)MongoDbConnectorConfig.SnapshotMode.NEVER)) {
            LOGGER.info("According to the connector configuration, no snapshot will occur.");
            return new MongoDbSnapshottingTask(Collections.emptyList());
        }
        ArrayList<ReplicaSet> replicaSetSnapshots = new ArrayList<ReplicaSet>();
        MongoDbOffsetContext offsetContext = previousOffset;
        try {
            this.replicaSets.onEachReplicaSet(replicaSet -> {
                ConnectionContext.MongoPreferredNode mongo = null;
                try {
                    mongo = this.establishConnection(partition, (ReplicaSet)replicaSet, ReadPreference.primaryPreferred());
                    ReplicaSetOffsetContext rsOffsetContext = offsetContext.getReplicaSetOffsetContext((ReplicaSet)replicaSet);
                    if (mongo != null && this.isSnapshotExpected(mongo, rsOffsetContext)) {
                        replicaSetSnapshots.add((ReplicaSet)replicaSet);
                    }
                }
                finally {
                    if (mongo != null) {
                        mongo.stop();
                    }
                }
            });
        }
        finally {
            this.taskContext.getConnectionContext().shutdown();
        }
        return new MongoDbSnapshottingTask(replicaSetSnapshots);
    }

    protected AbstractSnapshotChangeEventSource.SnapshotContext<MongoDbPartition, MongoDbOffsetContext> prepare(MongoDbPartition partition) throws Exception {
        return new MongoDbSnapshotContext(partition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void snapshotReplicaSet(ChangeEventSource.ChangeEventSourceContext sourceContext, MongoDbSnapshotContext ctx, ReplicaSet replicaSet) throws InterruptedException {
        ConnectionContext.MongoPreferredNode mongo = null;
        try {
            mongo = this.establishConnection((MongoDbPartition)ctx.partition, replicaSet, ReadPreference.secondaryPreferred());
            if (mongo != null) {
                this.createDataEvents(sourceContext, ctx, replicaSet, mongo);
            }
        }
        finally {
            if (mongo != null) {
                mongo.stop();
            }
        }
    }

    private ConnectionContext.MongoPreferredNode establishConnection(MongoDbPartition partition, ReplicaSet replicaSet, ReadPreference preference) {
        return this.connectionContext.preferredFor(replicaSet, preference, this.taskContext.filters(), (desc, error) -> {
            if (error.getMessage() != null && error.getMessage().startsWith(AUTHORIZATION_FAILURE_MESSAGE)) {
                throw new ConnectException("Error while attempting to " + desc, error);
            }
            this.dispatcher.dispatchConnectorEvent((Partition)partition, (ConnectorEvent)new DisconnectEvent());
            LOGGER.error("Error while attempting to {}: {}", new Object[]{desc, error.getMessage(), error});
            throw new ConnectException("Error while attempting to " + desc, error);
        });
    }

    private boolean isSnapshotExpected(ConnectionContext.MongoPreferredNode mongo, ReplicaSetOffsetContext offsetContext) {
        boolean performSnapshot = true;
        if (offsetContext.hasOffset()) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Found existing offset for replica set '{}' at {}", (Object)offsetContext.getReplicaSetName(), offsetContext.getOffset());
            }
            performSnapshot = false;
            if (offsetContext.isSnapshotOngoing()) {
                LOGGER.info("The previous snapshot was incomplete for '{}', so restarting the snapshot", (Object)offsetContext.getReplicaSetName());
                performSnapshot = true;
            } else {
                BsonTimestamp lastRecordedTs = offsetContext.lastOffsetTimestamp();
                BsonTimestamp firstAvailableTs = mongo.execute("get oplog position", client -> SourceInfo.extractEventTimestamp(MongoUtil.getOplogEntry(client, 1, LOGGER)));
                if (firstAvailableTs == null) {
                    LOGGER.info("The oplog contains no entries, so performing snapshot of replica set '{}'", (Object)offsetContext.getReplicaSetName());
                    performSnapshot = true;
                } else if (lastRecordedTs.compareTo(firstAvailableTs) < 0) {
                    LOGGER.info("Snapshot is required since the oplog for replica set '{}' starts at {}, which is later than the timestamp of the last offset {}", new Object[]{offsetContext.getReplicaSetName(), firstAvailableTs, lastRecordedTs});
                    performSnapshot = true;
                } else {
                    LOGGER.info("The oplog contains the last entry previously read for '{}', so no snapshot will be performed", (Object)offsetContext.getReplicaSetName());
                }
            }
        } else {
            LOGGER.info("No existing offset found for replica set '{}', starting snapshot", (Object)offsetContext.getReplicaSetName());
            performSnapshot = true;
        }
        return performSnapshot;
    }

    protected void determineSnapshotOffsets(MongoDbSnapshotContext ctx, ReplicaSets replicaSets) {
        LinkedHashMap<ReplicaSet, BsonDocument> positions = new LinkedHashMap<ReplicaSet, BsonDocument>();
        replicaSets.onEachReplicaSet(replicaSet -> {
            LOGGER.info("Determine Snapshot Offset for replica-set {}", (Object)replicaSet.replicaSetName());
            ConnectionContext.MongoPreferredNode mongo = this.establishConnection((MongoDbPartition)ctx.partition, (ReplicaSet)replicaSet, ReadPreference.primaryPreferred());
            if (mongo != null) {
                try {
                    mongo.execute("get oplog position", client -> positions.put((ReplicaSet)replicaSet, MongoUtil.getOplogEntry(client, -1, LOGGER)));
                }
                finally {
                    LOGGER.info("Stopping primary client");
                    mongo.stop();
                }
            }
        });
        ctx.offset = new MongoDbOffsetContext(new SourceInfo(this.connectorConfig), new TransactionContext(), new MongoDbIncrementalSnapshotContext<CollectionId>(false), positions);
    }

    private void createDataEvents(ChangeEventSource.ChangeEventSourceContext sourceContext, MongoDbSnapshotContext snapshotContext, ReplicaSet replicaSet, ConnectionContext.MongoPreferredNode mongo) throws InterruptedException {
        EventDispatcher.SnapshotReceiver snapshotReceiver = this.dispatcher.getSnapshotChangeEventReceiver();
        ((MongoDbOffsetContext)snapshotContext.offset).preSnapshotStart();
        this.createDataEventsForReplicaSet(sourceContext, snapshotContext, (EventDispatcher.SnapshotReceiver<MongoDbPartition>)snapshotReceiver, replicaSet, mongo);
        ((MongoDbOffsetContext)snapshotContext.offset).preSnapshotCompletion();
        snapshotReceiver.completeSnapshot();
        ((MongoDbOffsetContext)snapshotContext.offset).postSnapshotCompletion();
    }

    private void createDataEventsForReplicaSet(ChangeEventSource.ChangeEventSourceContext sourceContext, MongoDbSnapshotContext snapshotContext, EventDispatcher.SnapshotReceiver<MongoDbPartition> snapshotReceiver, ReplicaSet replicaSet, ConnectionContext.MongoPreferredNode mongo) throws InterruptedException {
        String rsName = replicaSet.replicaSetName();
        MongoDbOffsetContext offsetContext = (MongoDbOffsetContext)snapshotContext.offset;
        ReplicaSetOffsetContext rsOffsetContext = offsetContext.getReplicaSetOffsetContext(replicaSet);
        snapshotContext.lastCollection = false;
        offsetContext.startReplicaSetSnapshot(replicaSet.replicaSetName());
        LOGGER.info("Beginning snapshot of '{}' at {}", (Object)rsName, rsOffsetContext.getOffset());
        List collections = this.determineDataCollectionsToBeSnapshotted(mongo.collections()).collect(Collectors.toList());
        this.snapshotProgressListener.monitoredDataCollectionsDetermined((Partition)((MongoDbPartition)snapshotContext.partition), collections);
        if (this.connectorConfig.getSnapshotMaxThreads() > 1) {
            int numThreads = Math.min(collections.size(), this.connectorConfig.getSnapshotMaxThreads());
            ConcurrentLinkedQueue collectionsToCopy = new ConcurrentLinkedQueue(collections);
            String snapshotThreadName = "snapshot-" + (replicaSet.hasReplicaSetName() ? replicaSet.replicaSetName() : "main");
            ExecutorService snapshotThreads = Threads.newFixedThreadPool(MongoDbConnector.class, (String)this.taskContext.serverName(), (String)snapshotThreadName, (int)this.connectorConfig.getSnapshotMaxThreads());
            CountDownLatch latch = new CountDownLatch(numThreads);
            AtomicBoolean aborted = new AtomicBoolean(false);
            AtomicInteger threadCounter = new AtomicInteger(0);
            LOGGER.info("Preparing to use {} thread(s) to snapshot {} collection(s): {}", new Object[]{numThreads, collections.size(), Strings.join((CharSequence)", ", collections)});
            for (int i = 0; i < numThreads; ++i) {
                snapshotThreads.submit(() -> {
                    this.taskContext.configureLoggingContext(replicaSet.replicaSetName() + "-snapshot" + threadCounter.incrementAndGet());
                    try {
                        CollectionId id = null;
                        while (!aborted.get() && (id = (CollectionId)collectionsToCopy.poll()) != null) {
                            if (!sourceContext.isRunning()) {
                                throw new InterruptedException("Interrupted while snapshotting replica set " + replicaSet.replicaSetName());
                            }
                            if (collectionsToCopy.isEmpty()) {
                                snapshotContext.lastCollection = true;
                            }
                            this.createDataEventsForCollection(sourceContext, snapshotContext, snapshotReceiver, replicaSet, id, mongo);
                        }
                    }
                    catch (InterruptedException e) {
                        aborted.set(true);
                    }
                    finally {
                        latch.countDown();
                    }
                });
            }
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                aborted.set(true);
            }
            snapshotThreads.shutdown();
        } else {
            Iterator it = collections.iterator();
            while (it.hasNext()) {
                CollectionId collectionId = (CollectionId)it.next();
                if (!sourceContext.isRunning()) {
                    throw new InterruptedException("Interrupted while snapshotting replica set " + replicaSet.replicaSetName());
                }
                if (!it.hasNext()) {
                    snapshotContext.lastCollection = true;
                }
                this.createDataEventsForCollection(sourceContext, snapshotContext, snapshotReceiver, replicaSet, collectionId, mongo);
            }
        }
        offsetContext.stopReplicaSetSnapshot(replicaSet.replicaSetName());
    }

    private void createDataEventsForCollection(ChangeEventSource.ChangeEventSourceContext sourceContext, MongoDbSnapshotContext snapshotContext, EventDispatcher.SnapshotReceiver<MongoDbPartition> snapshotReceiver, ReplicaSet replicaSet, CollectionId collectionId, ConnectionContext.MongoPreferredNode mongo) throws InterruptedException {
        long exportStart = this.clock.currentTimeInMillis();
        LOGGER.info("\t Exporting data for collection '{}'", (Object)collectionId);
        mongo.executeBlocking("sync '" + collectionId + "'", (BlockingConsumer<MongoClient>)((BlockingConsumer)client -> {
            MongoDatabase database = client.getDatabase(collectionId.dbName());
            MongoCollection collection = database.getCollection(collectionId.name(), BsonDocument.class);
            int batchSize = this.taskContext.getConnectorConfig().getSnapshotFetchSize();
            long docs = 0L;
            Document filterQuery = Document.parse((String)this.connectorConfig.getSnapshotFilterQueryForCollection(collectionId).orElseGet(() -> "{}"));
            try (MongoCursor cursor = collection.find((Bson)filterQuery).batchSize(batchSize).iterator();){
                snapshotContext.lastRecordInCollection = false;
                if (cursor.hasNext()) {
                    while (cursor.hasNext()) {
                        if (!sourceContext.isRunning()) {
                            throw new InterruptedException("Interrupted while snapshotting collection " + collectionId.name());
                        }
                        BsonDocument document = (BsonDocument)cursor.next();
                        ++docs;
                        boolean bl = snapshotContext.lastRecordInCollection = !cursor.hasNext();
                        if (snapshotContext.lastCollection && snapshotContext.lastRecordInCollection) {
                            ((MongoDbOffsetContext)snapshotContext.offset).markSnapshotRecord(SnapshotRecord.LAST);
                        }
                        this.dispatcher.dispatchSnapshotEvent((Partition)((MongoDbPartition)snapshotContext.partition), (DataCollectionId)collectionId, this.getChangeRecordEmitter(snapshotContext, collectionId, document, replicaSet), snapshotReceiver);
                    }
                } else if (snapshotContext.lastCollection) {
                    ((MongoDbOffsetContext)snapshotContext.offset).markSnapshotRecord(SnapshotRecord.LAST);
                }
                LOGGER.info("\t Finished snapshotting {} records for collection '{}'; total duration '{}'", new Object[]{docs, collectionId, Strings.duration((long)(this.clock.currentTimeInMillis() - exportStart))});
                this.snapshotProgressListener.dataCollectionSnapshotCompleted((Partition)((MongoDbPartition)snapshotContext.partition), (DataCollectionId)collectionId, docs);
            }
        }));
    }

    protected ChangeRecordEmitter<MongoDbPartition> getChangeRecordEmitter(AbstractSnapshotChangeEventSource.SnapshotContext<MongoDbPartition, MongoDbOffsetContext> snapshotContext, CollectionId collectionId, BsonDocument document, ReplicaSet replicaSet) {
        MongoDbOffsetContext offsetContext = (MongoDbOffsetContext)snapshotContext.offset;
        ReplicaSetPartition replicaSetPartition = offsetContext.getReplicaSetPartition(replicaSet);
        ReplicaSetOffsetContext replicaSetOffsetContext = offsetContext.getReplicaSetOffsetContext(replicaSet);
        replicaSetOffsetContext.readEvent(collectionId, this.getClock().currentTime());
        return new MongoDbChangeSnapshotOplogRecordEmitter(replicaSetPartition, (OffsetContext)replicaSetOffsetContext, this.getClock(), document, true);
    }

    protected Clock getClock() {
        return this.clock;
    }

    public static class MongoDbSnapshottingTask
    extends AbstractSnapshotChangeEventSource.SnapshottingTask {
        private final List<ReplicaSet> replicaSetsToSnapshot;

        public MongoDbSnapshottingTask(List<ReplicaSet> replicaSetsToSnapshot) {
            super(false, !replicaSetsToSnapshot.isEmpty());
            this.replicaSetsToSnapshot = replicaSetsToSnapshot;
        }

        public List<ReplicaSet> getReplicaSetsToSnapshot() {
            return Collections.unmodifiableList(this.replicaSetsToSnapshot);
        }

        public boolean shouldSkipSnapshot() {
            return !this.snapshotData();
        }

        public String toString() {
            return "SnapshottingTask [replicaSetsToSnapshot=" + this.replicaSetsToSnapshot + "]";
        }
    }

    private static class MongoDbSnapshotContext
    extends AbstractSnapshotChangeEventSource.SnapshotContext<MongoDbPartition, MongoDbOffsetContext> {
        public boolean lastCollection;
        public boolean lastRecordInCollection;

        MongoDbSnapshotContext(MongoDbPartition partition) {
            super((Partition)partition);
        }
    }
}

