/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import com.mongodb.MongoException;
import com.mongodb.MongoInterruptedException;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoClient;
import com.mongodb.connection.ClusterDescription;
import com.mongodb.connection.ClusterType;
import com.mongodb.connection.ServerConnectionState;
import com.mongodb.connection.ServerDescription;
import io.debezium.annotation.ThreadSafe;
import io.debezium.connector.mongodb.ConnectionContext;
import io.debezium.connector.mongodb.MongoDbTaskContext;
import io.debezium.connector.mongodb.MongoUtil;
import io.debezium.connector.mongodb.ReplicaSet;
import io.debezium.connector.mongodb.ReplicaSets;
import io.debezium.function.BlockingConsumer;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class ReplicaSetDiscovery {
    public static final String CONFIG_DATABASE_NAME = "config";
    public static final String ADMIN_DATABASE_NAME = "admin";
    private static final Logger LOGGER = LoggerFactory.getLogger(ReplicaSetDiscovery.class);
    private final MongoDbTaskContext context;
    private final String maskedConnectionSeed;

    public ReplicaSetDiscovery(MongoDbTaskContext context) {
        this.context = context;
        this.maskedConnectionSeed = context.getConnectionContext().maskedConnectionSeed();
    }

    public ReplicaSets getReplicaSets() {
        ConnectionContext connectionContext = this.context.getConnectionContext();
        MongoClient client = connectionContext.clientForSeedConnection();
        HashSet<ReplicaSet> replicaSetSpecs = new HashSet<ReplicaSet>();
        ClusterDescription clusterDescription = MongoUtil.clusterDescription(client);
        if (clusterDescription.getType() == ClusterType.SHARDED) {
            String shardsCollection = "shards";
            try {
                MongoUtil.onCollectionDocuments(client, CONFIG_DATABASE_NAME, shardsCollection, (BlockingConsumer<Document>)((BlockingConsumer)doc -> {
                    LOGGER.info("Checking shard details from configuration replica set {}", (Object)this.maskedConnectionSeed);
                    String shardName = doc.getString((Object)"_id");
                    String hostStr = doc.getString((Object)"host");
                    String replicaSetName = MongoUtil.replicaSetUsedIn(hostStr);
                    replicaSetSpecs.add(new ReplicaSet(hostStr, replicaSetName, shardName));
                }));
            }
            catch (MongoInterruptedException e) {
                LOGGER.error("Interrupted while reading the '{}' collection in the '{}' database: {}", new Object[]{shardsCollection, CONFIG_DATABASE_NAME, e.getMessage(), e});
                Thread.currentThread().interrupt();
            }
            catch (MongoException e) {
                LOGGER.error("Error while reading the '{}' collection in the '{}' database: {}", new Object[]{shardsCollection, CONFIG_DATABASE_NAME, e.getMessage(), e});
            }
        }
        if (clusterDescription.getType() == ClusterType.REPLICA_SET) {
            LOGGER.info("Checking current members of replica set at {}", (Object)this.maskedConnectionSeed);
            List serverDescriptions = clusterDescription.getServerDescriptions().stream().filter(x -> x.getState() == ServerConnectionState.CONNECTED).collect(Collectors.toList());
            if (serverDescriptions.size() == 0) {
                LOGGER.warn("Server descriptions not available, got '{}'", serverDescriptions);
            } else {
                List<ServerAddress> addresses = serverDescriptions.stream().map(ServerDescription::getAddress).collect(Collectors.toList());
                String replicaSetName = ((ServerDescription)serverDescriptions.get(0)).getSetName();
                replicaSetSpecs.add(new ReplicaSet(addresses, replicaSetName, null));
            }
        }
        if (replicaSetSpecs.isEmpty()) {
            LOGGER.error("Found no replica sets at {}, so there is nothing to monitor and no connector tasks will be started. Check seed addresses in connector configuration.", (Object)this.maskedConnectionSeed);
        }
        return new ReplicaSets(replicaSetSpecs);
    }
}

