/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import com.mongodb.client.model.changestream.ChangeStreamDocument;
import io.debezium.annotation.Immutable;
import io.debezium.annotation.NotThreadSafe;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.connector.SnapshotRecord;
import io.debezium.connector.common.BaseSourceInfo;
import io.debezium.connector.mongodb.CollectionId;
import io.debezium.connector.mongodb.MongoDbConnectorConfig;
import io.debezium.connector.mongodb.MongoUtil;
import io.debezium.util.Collect;
import java.time.Instant;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.kafka.connect.errors.ConnectException;
import org.bson.BsonDocument;
import org.bson.BsonTimestamp;

@NotThreadSafe
public final class SourceInfo
extends BaseSourceInfo {
    private static final String RESUME_TOKEN = "resume_token";
    public static final int SCHEMA_VERSION = 1;
    public static final String SERVER_ID_KEY = "server_id";
    public static final String REPLICA_SET_NAME = "rs";
    public static final String NAMESPACE = "ns";
    public static final String TIMESTAMP = "sec";
    public static final String ORDER = "ord";
    public static final String INITIAL_SYNC = "initsync";
    public static final String COLLECTION = "collection";
    public static final String LSID = "lsid";
    public static final String TXN_NUMBER = "txnNumber";
    private static final BsonTimestamp INITIAL_TIMESTAMP = new BsonTimestamp();
    private static final Position INITIAL_POSITION = new Position(INITIAL_TIMESTAMP, null, null);
    private final ConcurrentMap<String, Map<String, String>> sourcePartitionsByReplicaSetName = new ConcurrentHashMap<String, Map<String, String>>();
    private final ConcurrentMap<String, Position> positionsByReplicaSetName = new ConcurrentHashMap<String, Position>();
    private final Set<String> initialSyncReplicaSets = Collections.newSetFromMap(new ConcurrentHashMap());
    private String replicaSetName;
    private CollectionId collectionId;
    private Position position = new Position(INITIAL_TIMESTAMP, null, null);

    public static String replicaSetNameForPartition(Map<String, ?> partition) {
        return partition != null ? (String)partition.get(REPLICA_SET_NAME) : null;
    }

    public SourceInfo(MongoDbConnectorConfig connectorConfig) {
        super((CommonConnectorConfig)connectorConfig);
    }

    CollectionId collectionId() {
        return this.collectionId;
    }

    Position position() {
        return this.position;
    }

    public String serverId() {
        return this.serverName();
    }

    public Map<String, String> partition(String replicaSetName) {
        if (replicaSetName == null) {
            throw new IllegalArgumentException("Replica set name may not be null");
        }
        return this.sourcePartitionsByReplicaSetName.computeIfAbsent(replicaSetName, rsName -> Collect.hashMapOf((Object)SERVER_ID_KEY, (Object)this.serverName(), (Object)REPLICA_SET_NAME, (Object)rsName));
    }

    public BsonTimestamp lastOffsetTimestamp(String replicaSetName) {
        Position existing = (Position)this.positionsByReplicaSetName.get(replicaSetName);
        return existing != null ? existing.ts : INITIAL_TIMESTAMP;
    }

    public String lastResumeToken(String replicaSetName) {
        Position existing = (Position)this.positionsByReplicaSetName.get(replicaSetName);
        return existing != null ? existing.resumeToken : null;
    }

    public Position lastPosition(String replicaSetName) {
        return (Position)this.positionsByReplicaSetName.get(replicaSetName);
    }

    public Map<String, ?> lastOffset(String replicaSetName) {
        Position existing = (Position)this.positionsByReplicaSetName.get(replicaSetName);
        if (existing == null) {
            existing = INITIAL_POSITION;
        }
        if (this.isInitialSyncOngoing(replicaSetName)) {
            return this.addSessionTxnIdToOffset(existing, Collect.hashMapOf((Object)TIMESTAMP, (Object)existing.getTime(), (Object)ORDER, (Object)existing.getInc(), (Object)INITIAL_SYNC, (Object)true));
        }
        Map offset = Collect.hashMapOf((Object)TIMESTAMP, (Object)existing.getTime(), (Object)ORDER, (Object)existing.getInc());
        existing.getResumeToken().ifPresent(resumeToken -> offset.put(RESUME_TOKEN, resumeToken));
        return this.addSessionTxnIdToOffset(existing, offset);
    }

    private Map<String, ?> addSessionTxnIdToOffset(Position position, Map<String, Object> offset) {
        if (position.getChangeStreamSessionTxnId() != null) {
            offset.put(LSID, position.getChangeStreamSessionTxnId().lsid);
            offset.put(TXN_NUMBER, position.getChangeStreamSessionTxnId().txnNumber);
        }
        return offset;
    }

    public void collectionEvent(String replicaSetName, CollectionId collectionId) {
        this.onEvent(replicaSetName, collectionId, (Position)this.positionsByReplicaSetName.get(replicaSetName));
    }

    public void initialPosition(String replicaSetName, BsonDocument oplogEvent) {
        Position position = INITIAL_POSITION;
        String namespace = "";
        if (oplogEvent != null) {
            BsonTimestamp ts = SourceInfo.extractEventTimestamp(oplogEvent);
            position = Position.snapshotPosition(ts);
            namespace = oplogEvent.getString((Object)NAMESPACE).getValue();
        }
        this.positionsByReplicaSetName.put(replicaSetName, position);
        this.onEvent(replicaSetName, CollectionId.parse(replicaSetName, namespace), position);
    }

    public void changeStreamEvent(String replicaSetName, ChangeStreamDocument<BsonDocument> changeStreamEvent) {
        Position position = INITIAL_POSITION;
        String namespace = "";
        if (changeStreamEvent != null) {
            BsonTimestamp ts = changeStreamEvent.getClusterTime();
            position = Position.changeStreamPosition(ts, changeStreamEvent.getResumeToken().getString((Object)"_data").getValue(), MongoUtil.getChangeStreamSessionTransactionId(changeStreamEvent));
            namespace = changeStreamEvent.getNamespace().getFullName();
        }
        this.positionsByReplicaSetName.put(replicaSetName, position);
        this.onEvent(replicaSetName, CollectionId.parse(replicaSetName, namespace), position);
    }

    protected static BsonTimestamp extractEventTimestamp(BsonDocument oplogEvent) {
        return oplogEvent != null ? oplogEvent.getTimestamp((Object)"ts") : null;
    }

    private void onEvent(String replicaSetName, CollectionId collectionId, Position position) {
        this.replicaSetName = replicaSetName;
        this.position = position == null ? INITIAL_POSITION : position;
        this.collectionId = collectionId;
    }

    public boolean hasOffset(String replicaSetName) {
        return this.positionsByReplicaSetName.containsKey(replicaSetName);
    }

    public boolean setOffsetFor(String replicaSetName, Map<String, ?> sourceOffset) {
        if (replicaSetName == null) {
            throw new IllegalArgumentException("The replica set name may not be null");
        }
        if (sourceOffset == null) {
            return false;
        }
        boolean initSync = SourceInfo.booleanOffsetValue(sourceOffset, INITIAL_SYNC);
        if (initSync) {
            return false;
        }
        int time = SourceInfo.intOffsetValue(sourceOffset, TIMESTAMP);
        int order = SourceInfo.intOffsetValue(sourceOffset, ORDER);
        String changeStreamLsid = SourceInfo.stringOffsetValue(sourceOffset, LSID);
        Long changeStreamTxnNumber = SourceInfo.longOffsetValue(sourceOffset, TXN_NUMBER);
        SessionTransactionId changeStreamTxnId = null;
        if (changeStreamLsid != null || changeStreamTxnNumber != null) {
            changeStreamTxnId = new SessionTransactionId(changeStreamLsid, changeStreamTxnNumber);
        }
        String resumeToken = SourceInfo.stringOffsetValue(sourceOffset, RESUME_TOKEN);
        this.positionsByReplicaSetName.put(replicaSetName, new Position(new BsonTimestamp(time, order), changeStreamTxnId, resumeToken));
        return true;
    }

    public boolean setOffsetFor(Map<String, String> partition, Map<String, ?> sourceOffset) {
        String replicaSetName = partition.get(REPLICA_SET_NAME);
        return this.setOffsetFor(replicaSetName, sourceOffset);
    }

    public void startInitialSync(String replicaSetName) {
        this.initialSyncReplicaSets.add(replicaSetName);
    }

    public void stopInitialSync(String replicaSetName) {
        this.initialSyncReplicaSets.remove(replicaSetName);
    }

    public boolean isInitialSyncOngoing(String replicaSetName) {
        return this.initialSyncReplicaSets.contains(replicaSetName);
    }

    public boolean isSnapshotRunning() {
        return !this.initialSyncReplicaSets.isEmpty();
    }

    private static int intOffsetValue(Map<String, ?> values, String key) {
        Object obj = values.get(key);
        if (obj == null) {
            return 0;
        }
        if (obj instanceof Number) {
            return ((Number)obj).intValue();
        }
        try {
            return Integer.parseInt(obj.toString());
        }
        catch (NumberFormatException e) {
            throw new ConnectException("Source offset '" + key + "' parameter value " + obj + " could not be converted to an integer");
        }
    }

    private static long longOffsetValue(Map<String, ?> values, String key) {
        Object obj = values.get(key);
        if (obj == null) {
            return 0L;
        }
        if (obj instanceof Number) {
            return ((Number)obj).longValue();
        }
        try {
            return Long.parseLong(obj.toString());
        }
        catch (NumberFormatException e) {
            throw new ConnectException("Source offset '" + key + "' parameter value " + obj + " could not be converted to a long");
        }
    }

    private static String stringOffsetValue(Map<String, ?> values, String key) {
        Object obj = values.get(key);
        if (obj == null) {
            return null;
        }
        return (String)obj;
    }

    private static boolean booleanOffsetValue(Map<String, ?> values, String key) {
        Object obj = values.get(key);
        if (obj != null && obj instanceof Boolean) {
            return (Boolean)obj;
        }
        return false;
    }

    protected Instant timestamp() {
        return Instant.ofEpochSecond(this.position().getTime());
    }

    protected SnapshotRecord snapshot() {
        return this.isInitialSyncOngoing(this.replicaSetName) ? SnapshotRecord.TRUE : (this.snapshotRecord == SnapshotRecord.INCREMENTAL ? SnapshotRecord.INCREMENTAL : SnapshotRecord.FALSE);
    }

    protected String database() {
        return this.collectionId != null ? this.collectionId.dbName() : null;
    }

    String replicaSetName() {
        return this.replicaSetName;
    }

    public String toString() {
        return "SourceInfo [sourcePartitionsByReplicaSetName=" + this.sourcePartitionsByReplicaSetName + ", positionsByReplicaSetName=" + this.positionsByReplicaSetName + ", initialSyncReplicaSets=" + this.initialSyncReplicaSets + ", replicaSetName=" + this.replicaSetName + ", collectionId=" + this.collectionId + ", position=" + this.position + "]";
    }

    @Immutable
    protected static final class Position {
        private final BsonTimestamp ts;
        private final SessionTransactionId changeStreamSessionTxnId;
        private final String resumeToken;

        public Position(BsonTimestamp ts, SessionTransactionId changeStreamsSessionTxnId, String resumeToken) {
            this.ts = ts;
            this.changeStreamSessionTxnId = changeStreamsSessionTxnId;
            this.resumeToken = resumeToken;
        }

        public static Position snapshotPosition(BsonTimestamp ts) {
            return new Position(ts, null, null);
        }

        public static Position changeStreamPosition(BsonTimestamp ts, String resumeToken, SessionTransactionId sessionTxnId) {
            return new Position(ts, sessionTxnId, resumeToken);
        }

        public BsonTimestamp getTimestamp() {
            return this.ts;
        }

        public int getTime() {
            return this.ts.getTime();
        }

        public int getInc() {
            return this.ts.getInc();
        }

        public SessionTransactionId getChangeStreamSessionTxnId() {
            return this.changeStreamSessionTxnId;
        }

        public Optional<String> getResumeToken() {
            return Optional.ofNullable(this.resumeToken);
        }

        public String toString() {
            return "Position [ts=" + this.ts + ", changeStreamSessionTxnId=" + this.changeStreamSessionTxnId + ", resumeToken=" + this.resumeToken + "]";
        }
    }

    static final class SessionTransactionId {
        public final String lsid;
        public final Long txnNumber;

        SessionTransactionId(String lsid, Long txnNumber) {
            this.txnNumber = txnNumber;
            this.lsid = lsid;
        }
    }
}

