/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.NumberPrototypeBuiltins;
import com.oracle.truffle.js.builtins.StringFunctionBuiltinsFactory;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.access.ReadElementNode;
import com.oracle.truffle.js.nodes.array.JSGetLengthNode;
import com.oracle.truffle.js.nodes.cast.JSToObjectNode;
import com.oracle.truffle.js.nodes.cast.JSToStringNode;
import com.oracle.truffle.js.nodes.cast.JSToUInt16Node;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.runtime.Boundaries;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;

public final class StringFunctionBuiltins
extends JSBuiltinsContainer.SwitchEnum<StringFunction> {
    public static final JSBuiltinsContainer BUILTINS = new StringFunctionBuiltins();

    protected StringFunctionBuiltins() {
        super("String", StringFunction.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, StringFunction builtinEnum) {
        switch (builtinEnum) {
            case fromCharCode: {
                return StringFunctionBuiltinsFactory.JSFromCharCodeNodeGen.create(context, builtin, StringFunctionBuiltins.args().varArgs().createArgumentNodes(context));
            }
            case fromCodePoint: {
                return StringFunctionBuiltinsFactory.JSFromCodePointNodeGen.create(context, builtin, StringFunctionBuiltins.args().varArgs().createArgumentNodes(context));
            }
            case raw: {
                return StringFunctionBuiltinsFactory.StringRawNodeGen.create(context, builtin, StringFunctionBuiltins.args().fixedArgs(1).varArgs().createArgumentNodes(context));
            }
        }
        return null;
    }

    public static abstract class StringRawNode
    extends JSBuiltinNode {
        @Node.Child
        private JSToObjectNode templateToObjectNode;
        @Node.Child
        private JSToObjectNode rawToObjectNode;
        @Node.Child
        private PropertyGetNode getRawNode;
        @Node.Child
        private JSGetLengthNode getRawLengthNode;
        @Node.Child
        private JSToStringNode segToStringNode;
        @Node.Child
        private JSToStringNode subToStringNode;
        @Node.Child
        private ReadElementNode readRawElementNode;
        private final ConditionProfile emptyProf = ConditionProfile.createBinaryProfile();

        public StringRawNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.templateToObjectNode = JSToObjectNode.createToObject(context);
            this.rawToObjectNode = JSToObjectNode.createToObject(context);
            this.getRawNode = PropertyGetNode.create("raw", false, context);
            this.getRawLengthNode = JSGetLengthNode.create(context);
            this.segToStringNode = JSToStringNode.create();
            this.subToStringNode = JSToStringNode.create();
            this.readRawElementNode = ReadElementNode.create(context);
        }

        @Specialization
        protected String raw(Object template, Object[] substitutions) {
            int numberOfSubstitutions = substitutions.length;
            Object cooked = this.templateToObjectNode.execute(template);
            Object raw = this.rawToObjectNode.execute(this.getRawNode.getValue(cooked));
            int literalSegments = this.getRawLength(raw);
            if (this.emptyProf.profile(literalSegments <= 0)) {
                return "";
            }
            StringBuilder result = new StringBuilder();
            int i = 0;
            while (true) {
                Object rawElement = this.readRawElementNode.executeWithTargetAndIndex(raw, i);
                String nextSeg = this.segToStringNode.executeString(rawElement);
                this.appendChecked(result, nextSeg);
                if (i + 1 == literalSegments) break;
                if (i < numberOfSubstitutions) {
                    String nextSub = this.subToStringNode.executeString(substitutions[i]);
                    this.appendChecked(result, nextSub);
                }
                ++i;
            }
            return Boundaries.builderToString(result);
        }

        private int getRawLength(Object raw) {
            long length = this.getRawLengthNode.executeLong(raw);
            try {
                return Math.toIntExact(length);
            }
            catch (ArithmeticException e) {
                return 0;
            }
        }

        private void appendChecked(StringBuilder result, String str) {
            if (result.length() + str.length() > this.getContext().getStringLengthLimit()) {
                CompilerDirectives.transferToInterpreter();
                throw Errors.createRangeErrorInvalidStringLength();
            }
            Boundaries.builderAppend(result, str);
        }
    }

    public static abstract class JSFromCodePointNode
    extends NumberPrototypeBuiltins.JSNumberOperation {
        public JSFromCodePointNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected String fromCodePoint(Object[] args) {
            StringBuilder st = new StringBuilder(args.length);
            for (Object arg : args) {
                Number value = this.toNumber(arg);
                double valueDouble = JSRuntime.doubleValue(value);
                int valueInt = JSRuntime.intValue(value);
                if (JSRuntime.isNegativeZero(valueDouble)) {
                    valueInt = 0;
                } else if (!JSRuntime.doubleIsRepresentableAsInt(valueDouble) || valueInt < 0 || 0x10FFFF < valueInt) {
                    JSFromCodePointNode.throwRangeError(value);
                }
                if (valueInt < 65536) {
                    Boundaries.builderAppend(st, (char)valueInt);
                    continue;
                }
                Boundaries.builderAppend(st, (char)(((valueInt -= 65536) >> 10) + 55296));
                Boundaries.builderAppend(st, (char)(valueInt % 1024 + 56320));
            }
            return Boundaries.builderToString(st);
        }

        @CompilerDirectives.TruffleBoundary
        private static void throwRangeError(Number value) {
            throw Errors.createRangeError("Invalid code point " + value);
        }
    }

    public static abstract class JSFromCharCodeNode
    extends NumberPrototypeBuiltins.JSNumberOperation {
        @Node.Child
        private JSToUInt16Node toUInt16Node;

        public JSFromCharCodeNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        private char toChar(Object target) {
            if (this.toUInt16Node == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toUInt16Node = (JSToUInt16Node)this.insert(JSToUInt16Node.create());
            }
            return (char)this.toUInt16Node.executeInt(target);
        }

        @Specialization(guards={"args.length == 0"})
        protected String fromCharCode(Object[] args) {
            return "";
        }

        @Specialization(guards={"args.length == 1"})
        protected String fromCharCodeOneArg(Object[] args) {
            return String.valueOf(this.toChar(args[0]));
        }

        @Specialization(guards={"args.length >= 2"})
        protected String fromCharCodeTwoOrMore(Object[] args) {
            StringBuilder buffer = new StringBuilder(args.length + 4);
            for (int i = 0; i < args.length; ++i) {
                Boundaries.builderAppend(buffer, this.toChar(args[i]));
            }
            return Boundaries.builderToString(buffer);
        }
    }

    public static enum StringFunction implements BuiltinEnum<StringFunction>
    {
        fromCharCode(1),
        fromCodePoint(1),
        raw(1);

        private final int length;

        private StringFunction(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public int getECMAScriptVersion() {
            if (this == fromCodePoint) {
                return 6;
            }
            return BuiltinEnum.super.getECMAScriptVersion();
        }
    }
}

