/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.helper;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSException;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.array.ScriptArray;
import com.oracle.truffle.js.runtime.builtins.JSAbstractArray;
import com.oracle.truffle.js.runtime.builtins.JSArray;
import com.oracle.truffle.js.runtime.builtins.JSUserObject;
import com.oracle.truffle.js.runtime.objects.Null;

public class TruffleJSONParser {
    protected final JSContext context;
    protected int pos;
    protected int len;
    protected String parseStr;
    protected int parseDepth;
    protected static final char[] NullLiteral = new char[]{'n', 'u', 'l', 'l'};
    protected static final char[] BooleanTrueLiteral = new char[]{'t', 'r', 'u', 'e'};
    protected static final char[] BooleanFalseLiteral = new char[]{'f', 'a', 'l', 's', 'e'};
    protected static final int MAX_PARSE_DEPTH = 100000;
    private static final String MALFORMED_NUMBER = "malformed number";

    public TruffleJSONParser(JSContext context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object parse(String value) {
        this.pos = 0;
        this.parseDepth = 0;
        this.parseStr = value;
        this.len = this.parseStr.length();
        try {
            this.skipWhitespace();
            Object result = this.parseJSONText();
            this.skipWhitespace();
            if (this.posValid()) {
                throw Errors.createSyntaxError("JSON cannot be fully parsed");
            }
            Object object = result;
            return object;
        }
        catch (StackOverflowError ex) {
            TruffleJSONParser.throwStackError();
        }
        catch (JSException ex) {
            throw ex;
        }
        catch (StringIndexOutOfBoundsException ex) {
            TruffleJSONParser.throwSyntaxError(this.unexpectedEndOfInputMessage());
        }
        catch (Exception ex) {
            TruffleJSONParser.throwSyntaxError(null);
        }
        finally {
            this.parseStr = null;
        }
        return null;
    }

    private String unexpectedEndOfInputMessage() {
        return this.context.isOptionV8CompatibilityMode() ? "Unexpected end of JSON input" : "Unexpected end of input";
    }

    private Object parseJSONText() {
        return this.parseJSONValue();
    }

    protected Object parseJSONValue() {
        char c = this.get();
        if (c == 'n' && this.isNullLiteral()) {
            return this.parseNullLiteral();
        }
        if ((c == 't' || c == 'f') && this.isBooleanLiteral()) {
            return this.parseBooleanLiteral();
        }
        if (TruffleJSONParser.isNumber(c)) {
            return this.parseJSONNumber();
        }
        if (TruffleJSONParser.isString(c)) {
            return this.parseJSONString();
        }
        if (TruffleJSONParser.isArray(c)) {
            return this.parseJSONArray();
        }
        if (TruffleJSONParser.isObject(c)) {
            return this.parseJSONObject();
        }
        return this.error("cannot parse JSONValue");
    }

    protected static boolean isNumber(char cur) {
        return cur == '-' || JSRuntime.isAsciiDigit(cur);
    }

    protected static boolean isString(char c) {
        return TruffleJSONParser.isStringQuote(c);
    }

    protected static boolean isObject(char c) {
        return c == '{';
    }

    protected static boolean isArray(char c) {
        return c == '[';
    }

    private Object parseJSONObject() {
        assert (TruffleJSONParser.isObject(this.get()));
        this.incDepth();
        this.read();
        DynamicObject object = JSUserObject.create(this.context);
        if (this.get() != '}') {
            this.parseJSONMemberList(object);
            if (this.get() != '}') {
                this.error("closing quote } expected");
            }
        }
        this.read('}');
        this.decDepth();
        return object;
    }

    private void parseJSONMemberList(DynamicObject object) {
        Member member = this.parseJSONMember();
        JSRuntime.createDataProperty(object, member.getKey(), member.getValue());
        while (this.get() == ',') {
            this.read();
            member = this.parseJSONMember();
            JSRuntime.createDataProperty(object, member.getKey(), member.getValue());
        }
    }

    private Member parseJSONMember() {
        String jsonString = this.parseJSONString();
        this.read(':');
        Object jsonValue = this.parseJSONValue();
        return new Member(jsonString, jsonValue);
    }

    private Object parseJSONArray() {
        assert (TruffleJSONParser.isArray(this.get()));
        this.incDepth();
        this.read();
        DynamicObject array = JSArray.createEmptyZeroLength(this.context);
        if (this.get() != ']') {
            this.parseJSONElementList(array);
            if (this.get() != ']') {
                this.error("closing quote ] expected");
            }
        }
        this.read(']');
        this.decDepth();
        return array;
    }

    private void incDepth() {
        ++this.parseDepth;
        if (this.parseDepth > 100000) {
            TruffleJSONParser.throwStackError();
        }
    }

    protected static void throwStackError() {
        throw Errors.createRangeError("Cannot parse JSON constructs nested that deep");
    }

    protected static void throwSyntaxError(String msg) {
        throw Errors.createSyntaxError(msg == null ? "Cannot parse JSON" : msg);
    }

    protected void decDepth() {
        --this.parseDepth;
    }

    protected ScriptArray parseJSONElementList(DynamicObject arrayObject) {
        int index = 0;
        ScriptArray scriptArray = JSAbstractArray.arrayGetArrayType(arrayObject);
        scriptArray = scriptArray.setElement(arrayObject, index, this.parseJSONValue(), false);
        while (this.get() == ',') {
            this.read();
            scriptArray = scriptArray.setElement(arrayObject, ++index, this.parseJSONValue(), false);
        }
        JSAbstractArray.arraySetArrayType(arrayObject, scriptArray);
        return scriptArray;
    }

    protected String parseJSONString() {
        if (!TruffleJSONParser.isStringQuote(this.get())) {
            this.error("String quote expected");
        }
        ++this.pos;
        String str = this.parseJSONStringCharacters();
        if (!TruffleJSONParser.isStringQuote(this.get())) {
            this.error("String quote expected");
        }
        this.read();
        return str;
    }

    protected static boolean isStringQuote(char c) {
        return c == '\"';
    }

    protected String parseJSONStringCharacters() {
        int startPos = this.pos;
        boolean hasEscapes = false;
        boolean curIsEscaped = false;
        char c = this.get();
        while (c != '\"' || curIsEscaped) {
            if (c < ' ') {
                this.error("invalid string");
            } else if (c == '\\') {
                hasEscapes = true;
                curIsEscaped = !curIsEscaped;
            } else {
                curIsEscaped = false;
            }
            ++this.pos;
            c = this.get();
        }
        String s = this.parseStr.substring(startPos, this.pos);
        if (hasEscapes) {
            return this.unquoteJSON(s);
        }
        return s;
    }

    protected String unquoteJSON(String string) {
        int posBackslash = string.indexOf(92);
        if (posBackslash >= 0) {
            int curPos = 0;
            StringBuilder builder = new StringBuilder(string.length());
            while (posBackslash >= 0) {
                builder.append(string, curPos, posBackslash);
                curPos = posBackslash;
                char c = string.charAt(posBackslash + 1);
                switch (c) {
                    case '\"': {
                        builder.append('\"');
                        break;
                    }
                    case '\\': {
                        builder.append('\\');
                        break;
                    }
                    case 'b': {
                        builder.append('\b');
                        break;
                    }
                    case 'f': {
                        builder.append('\f');
                        break;
                    }
                    case 'n': {
                        builder.append('\n');
                        break;
                    }
                    case 'r': {
                        builder.append('\r');
                        break;
                    }
                    case 't': {
                        builder.append('\t');
                        break;
                    }
                    case '/': {
                        builder.append('/');
                        break;
                    }
                    case 'u': {
                        this.unquoteJSONUnicode(string, posBackslash, builder);
                        curPos += 4;
                        break;
                    }
                    default: {
                        this.error("wrong escape sequence");
                    }
                }
                posBackslash = string.indexOf(92, curPos += 2);
            }
            if (curPos < string.length()) {
                builder.append(string, curPos, string.length());
            }
            return builder.toString();
        }
        return string;
    }

    protected int hexDigitValue(char c) {
        int value = JSRuntime.valueInHex(c);
        if (value < 0) {
            this.error("invalid string");
            return -1;
        }
        return value;
    }

    protected void unquoteJSONUnicode(String string, int posBackslash, StringBuilder builder) {
        char c1 = string.charAt(posBackslash + 2);
        char c2 = string.charAt(posBackslash + 3);
        char c3 = string.charAt(posBackslash + 4);
        char c4 = string.charAt(posBackslash + 5);
        char unencodedC = (char)(this.hexDigitValue(c1) << 12 | this.hexDigitValue(c2) << 8 | this.hexDigitValue(c3) << 4 | this.hexDigitValue(c4));
        builder.append(unencodedC);
    }

    protected Number parseJSONNumber() {
        int sign = 1;
        if (this.get() == '-') {
            this.read();
            sign = -1;
        }
        if (!this.posValid()) {
            this.error(MALFORMED_NUMBER);
        }
        int startPos = this.pos;
        int fractionPos = -1;
        boolean firstPosIsZero = false;
        char c = this.get();
        while (JSRuntime.isAsciiDigit(c) || c == '.') {
            if (c == '.') {
                if (fractionPos >= 0) {
                    this.error(MALFORMED_NUMBER);
                }
                fractionPos = this.pos;
            } else if (this.pos == startPos && c == '0') {
                firstPosIsZero = true;
            }
            ++this.pos;
            if (!this.posValid()) break;
            c = this.get(this.pos);
        }
        if (this.pos == startPos) {
            this.error("Expected number but found ident");
        } else if (firstPosIsZero && startPos + 1 < this.len && ((c = this.get(startPos + 1)) == 'x' || c == 'X' || JSRuntime.isAsciiDigit(c))) {
            this.error("octal and hexadecimal not allowed");
        }
        if (fractionPos == startPos || fractionPos == this.pos - 1) {
            this.error(MALFORMED_NUMBER);
        }
        boolean hasExponent = false;
        if (this.posValid() && this.isExponentPart()) {
            hasExponent = true;
            ++this.pos;
            this.readDigits();
        }
        int endPos = this.pos;
        this.skipWhitespace();
        if (firstPosIsZero && endPos - startPos == 1) {
            if (sign == 1) {
                return 0;
            }
            return -0.0;
        }
        if (fractionPos == -1 && !hasExponent && endPos - startPos <= 16) {
            int radix = 10;
            long safeInt = JSRuntime.parseSafeInteger(this.parseStr, startPos, endPos, 10);
            assert (safeInt != 0L);
            if (safeInt != Long.MIN_VALUE) {
                if (JSRuntime.longIsRepresentableAsInt(safeInt *= (long)sign)) {
                    return (int)safeInt;
                }
                return (double)safeInt;
            }
        }
        String valueStr = this.parseStr.substring(startPos, endPos);
        return TruffleJSONParser.parseAsDouble(sign, valueStr);
    }

    protected static Number parseAsDouble(int sign, String valueStr) {
        return Double.parseDouble(valueStr) * (double)sign;
    }

    protected int readDigits() {
        int sign = 1;
        char cur = this.get();
        if (cur == '-') {
            this.read();
            sign = -1;
        } else if (cur == '+') {
            this.read();
            sign = 1;
        }
        if (!this.posValid()) {
            this.error(MALFORMED_NUMBER);
        }
        cur = this.get();
        int startPos = this.pos;
        while (JSRuntime.isAsciiDigit(cur)) {
            ++this.pos;
            if (!this.posValid()) break;
            cur = this.get(this.pos);
        }
        if (this.pos == startPos) {
            this.error("Expected number but found ident");
        }
        return sign * Integer.parseInt(this.parseStr.substring(startPos, this.pos));
    }

    protected boolean isExponentPart() {
        return this.get() == 'e' || this.get() == 'E';
    }

    protected boolean isNullLiteral() {
        return this.isLiteral(NullLiteral);
    }

    protected Object parseNullLiteral() {
        assert (this.isNullLiteral());
        this.read("null");
        return Null.instance;
    }

    protected boolean isBooleanLiteral() {
        return this.isLiteral(BooleanTrueLiteral) || this.isLiteral(BooleanFalseLiteral);
    }

    protected Object parseBooleanLiteral() {
        assert (this.isBooleanLiteral());
        if (this.get() == 't') {
            this.read("true");
            return true;
        }
        if (this.get() == 'f') {
            this.read("false");
            return false;
        }
        return this.error("cannot parse JSONBooleanLiteral");
    }

    protected static boolean isWhitespace(char c) {
        return c == ' ' || c == '\n' || c == '\r' || c == '\t';
    }

    protected Object error(String message) {
        this.context.getEvaluator().parseJSON(this.context, this.parseStr);
        throw Errors.createError("Internal error: " + message);
    }

    @CompilerDirectives.TruffleBoundary
    public static RuntimeException createSyntaxError(Exception ex, JSContext context) {
        throw context.isOptionV8CompatibilityMode() ? Errors.createSyntaxError(ex.getMessage().replace("\r\n", "\n")) : Errors.createSyntaxError("Invalid JSON: " + ex.getMessage().replace("\r\n", "\n"));
    }

    protected char get() {
        return this.get(this.pos);
    }

    protected char get(int posParam) {
        return this.parseStr.charAt(posParam);
    }

    protected void read() {
        assert (this.len > this.pos);
        ++this.pos;
        this.skipWhitespace();
    }

    protected void read(String expected) {
        assert (this.len >= this.pos + expected.length());
        assert (this.parseStr.substring(this.pos, this.pos + expected.length()).equals(expected));
        this.pos += expected.length();
        this.skipWhitespace();
    }

    protected void read(char expected) {
        if (this.get(this.pos) != expected) {
            this.error(expected + " expected");
        }
        ++this.pos;
        this.skipWhitespace();
    }

    protected void skipWhitespace() {
        while (this.posValid() && TruffleJSONParser.isWhitespace(this.get())) {
            ++this.pos;
        }
    }

    protected boolean posValid() {
        return this.pos < this.len;
    }

    protected boolean isLiteral(char[] literal) {
        if (this.len < this.pos + literal.length) {
            return false;
        }
        if (this.get() != literal[0]) {
            return false;
        }
        for (int i = 1; i < literal.length; ++i) {
            if (this.get(this.pos + i) == literal[i]) continue;
            return false;
        }
        return true;
    }

    protected final class Member {
        private final String key;
        private final Object value;

        public Member(String key, Object value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

