/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.array;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.IsArrayNode;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSTruffleOptions;
import com.oracle.truffle.js.runtime.array.ScriptArray;
import com.oracle.truffle.js.runtime.builtins.JSArgumentsObject;
import com.oracle.truffle.js.runtime.builtins.JSArray;
import com.oracle.truffle.js.runtime.builtins.JSArrayBufferView;
import com.oracle.truffle.js.runtime.builtins.JSProxy;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.Null;

@ReportPolymorphism
public abstract class JSArrayElementIndexNode
extends JavaScriptBaseNode {
    protected static final int MAX_CACHED_ARRAY_TYPES = 4;
    protected final JSContext context;
    @Node.Child
    private IsArrayNode isArrayNode;

    protected JSArrayElementIndexNode(JSContext context) {
        this.context = context;
    }

    protected static boolean hasHoles(DynamicObject object, boolean isArray) {
        return JSObject.getArray(object).hasHoles(object, isArray);
    }

    protected static ScriptArray getArrayType(DynamicObject object, boolean arrayCondition) {
        return JSObject.getArray(object, arrayCondition);
    }

    protected static ScriptArray getArrayTypeIfArray(DynamicObject object, boolean arrayCondition) {
        if (!arrayCondition) {
            return null;
        }
        return JSArrayElementIndexNode.getArrayType(object, arrayCondition);
    }

    protected final boolean isSuitableForEnumBasedProcessingUsingOwnKeys(Object object, long length) {
        return length > (long)JSTruffleOptions.BigArrayThreshold && !JSArrayBufferView.isJSArrayBufferView(object) && !JSProxy.isProxy(object) && (JSArray.isJSArray(object) && this.context.getArrayPrototypeNoElementsAssumption().isValid() || !JSObject.isJSObject(object) || JSObject.getPrototype((DynamicObject)object) == Null.instance);
    }

    protected static final boolean isSuitableForEnumBasedProcessing(Object object, long length) {
        if (length <= (long)JSTruffleOptions.BigArrayThreshold || !JSObject.isJSObject(object)) {
            return false;
        }
        DynamicObject chainObject = (DynamicObject)object;
        do {
            if (!JSArrayBufferView.isJSArrayBufferView(chainObject) && !JSProxy.isProxy(chainObject)) continue;
            return false;
        } while ((chainObject = JSObject.getPrototype(chainObject)) != Null.instance);
        return true;
    }

    protected final boolean hasPrototypeElements(DynamicObject object) {
        return !this.context.getArrayPrototypeNoElementsAssumption().isValid();
    }

    protected final boolean isArray(Object obj) {
        if (this.isArrayNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.isArrayNode = (IsArrayNode)this.insert(IsArrayNode.createIsFastOrTypedArray());
        }
        return this.isArrayNode.execute(obj);
    }

    protected static boolean isSupportedArray(DynamicObject object) {
        return JSArray.isJSFastArray(object) || JSArgumentsObject.isJSFastArgumentsObject(object) || JSArrayBufferView.isJSArrayBufferView(object);
    }
}

