/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.truffleinterop;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.CachedContext;
import com.oracle.truffle.api.dsl.CachedLanguage;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.nodes.interop.ExportValueNode;
import com.oracle.truffle.js.nodes.interop.JSInteropExecuteNode;
import com.oracle.truffle.js.nodes.promise.UnwrapPromiseNode;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSTruffleOptions;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.truffleinterop.InteropFunction;

@ExportLibrary(value=InteropLibrary.class)
public final class InteropAsyncFunction
extends InteropFunction {
    public InteropAsyncFunction(DynamicObject function) {
        super(function);
        assert (JSTruffleOptions.InteropCompletePromises);
    }

    public int hashCode() {
        return this.function.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof InteropAsyncFunction) {
            InteropAsyncFunction other = (InteropAsyncFunction)obj;
            return this.function.equals(other.function);
        }
        return false;
    }

    @ExportMessage
    boolean isExecutable() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    Object execute(Object[] arguments, @CachedLanguage JavaScriptLanguage language, @CachedContext(value=JavaScriptLanguage.class) JSRealm realm, @Cached JSInteropExecuteNode callNode, @Cached ExportValueNode exportNode, @Cached(value="create(realm.getContext())") UnwrapPromiseNode unwrapPromise) throws UnsupportedMessageException {
        Object result;
        language.interopBoundaryEnter(realm);
        try {
            result = callNode.execute(this.function, Undefined.instance, arguments);
            result = exportNode.execute(result);
        }
        finally {
            language.interopBoundaryExit(realm);
        }
        return unwrapPromise.execute((DynamicObject)result);
    }
}

