/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.matchers;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.regex.tregex.matchers.InvertibleCharMatcher;
import com.oracle.truffle.regex.tregex.matchers.MultiBitSetMatcherNodeGen;
import com.oracle.truffle.regex.util.CompilationFinalBitSet;
import java.util.Arrays;

public abstract class MultiBitSetMatcher
extends InvertibleCharMatcher {
    private static final int BYTE_RANGE = 256;
    private static final int BYTE_MAX_VALUE = 255;
    private static final int BYTE_MIN_VALUE = 0;
    private static final CompilationFinalBitSet MATCH_NONE = new CompilationFinalBitSet(256);
    private static final CompilationFinalBitSet MATCH_ALL = new CompilationFinalBitSet(256);
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final CompilationFinalBitSet[] bitSets;

    public static MultiBitSetMatcher fromRanges(boolean inverse, char[] ranges) {
        Object[] bitSets = new CompilationFinalBitSet[256];
        Arrays.fill(bitSets, MATCH_NONE);
        CompilationFinalBitSet cur = new CompilationFinalBitSet(256);
        int curByte = MultiBitSetMatcher.highByte(ranges[0]);
        for (int i = 0; i < ranges.length; i += 2) {
            char rangeLo = ranges[i];
            char rangeHi = ranges[i + 1];
            if (MultiBitSetMatcher.highByte(rangeLo) > curByte) {
                bitSets[curByte] = cur;
                cur = new CompilationFinalBitSet(256);
                curByte = MultiBitSetMatcher.highByte(rangeLo);
            }
            if (MultiBitSetMatcher.highByte(rangeLo) == MultiBitSetMatcher.highByte(rangeHi)) {
                cur.setRange(MultiBitSetMatcher.lowByte(rangeLo), MultiBitSetMatcher.lowByte(rangeHi));
                continue;
            }
            cur.setRange(MultiBitSetMatcher.lowByte(rangeLo), 255);
            bitSets[curByte] = cur;
            for (int j = MultiBitSetMatcher.highByte(rangeLo) + 1; j < MultiBitSetMatcher.highByte(rangeHi); ++j) {
                bitSets[j] = MATCH_ALL;
            }
            cur = new CompilationFinalBitSet(256);
            curByte = MultiBitSetMatcher.highByte(rangeHi);
            cur.setRange(0, MultiBitSetMatcher.lowByte(rangeHi));
        }
        bitSets[curByte] = cur;
        return MultiBitSetMatcherNodeGen.create(inverse, (CompilationFinalBitSet[])bitSets);
    }

    MultiBitSetMatcher(boolean invert, CompilationFinalBitSet[] bitSets) {
        super(invert);
        this.bitSets = bitSets;
    }

    @Specialization
    protected boolean match(char c, boolean compactString) {
        return this.result(this.bitSets[compactString ? 0 : MultiBitSetMatcher.highByte(c)].get(MultiBitSetMatcher.lowByte(c)));
    }

    @Override
    public int estimatedCost() {
        return 8;
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        StringBuilder sb = new StringBuilder(this.modifiersToString()).append("[\n");
        for (int i = 0; i < this.bitSets.length; ++i) {
            sb.append(String.format("    %02x: ", i)).append(this.bitSets[i]).append("\n");
        }
        return sb.append("  ]").toString();
    }

    static {
        MATCH_ALL.invert();
    }
}

