/*
 * Decompiled with CFR 0.152.
 */
package japa.parser;

import japa.parser.ASTParser;
import japa.parser.ParseException;
import japa.parser.ast.CompilationUnit;
import japa.parser.ast.ImportDeclaration;
import japa.parser.ast.body.BodyDeclaration;
import japa.parser.ast.expr.AnnotationExpr;
import japa.parser.ast.expr.Expression;
import japa.parser.ast.stmt.BlockStmt;
import japa.parser.ast.stmt.Statement;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;

public final class JavaParser {
    private static ASTParser parser;
    private static boolean cacheParser;

    private JavaParser() {
    }

    public static void setCacheParser(boolean value) {
        cacheParser = value;
        if (!value) {
            parser = null;
        }
    }

    public static CompilationUnit parse(InputStream in, String encoding) throws ParseException {
        if (cacheParser) {
            if (parser == null) {
                parser = new ASTParser(in, encoding);
            } else {
                parser.reset(in, encoding);
            }
            return parser.CompilationUnit();
        }
        return new ASTParser(in, encoding).CompilationUnit();
    }

    public static CompilationUnit parse(InputStream in) throws ParseException {
        return JavaParser.parse(in, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CompilationUnit parse(File file, String encoding) throws ParseException, IOException {
        FileInputStream in = new FileInputStream(file);
        try {
            CompilationUnit compilationUnit = JavaParser.parse(in, encoding);
            return compilationUnit;
        }
        finally {
            in.close();
        }
    }

    public static CompilationUnit parse(File file) throws ParseException, IOException {
        return JavaParser.parse(file, null);
    }

    public static CompilationUnit parse(Reader reader) throws ParseException {
        return new ASTParser(reader).CompilationUnit();
    }

    public static BlockStmt parseBlock(String blockStatement) throws ParseException {
        StringReader sr = new StringReader(blockStatement);
        BlockStmt result = new ASTParser(sr).Block();
        sr.close();
        return result;
    }

    public static Statement parseStatement(String statement) throws ParseException {
        StringReader sr = new StringReader(statement);
        Statement stmt = new ASTParser(sr).Statement();
        sr.close();
        return stmt;
    }

    public static ImportDeclaration parseImport(String importDeclaration) throws ParseException {
        StringReader sr = new StringReader(importDeclaration);
        ImportDeclaration id = new ASTParser(sr).ImportDeclaration();
        sr.close();
        return id;
    }

    public static Expression parseExpression(String expression) throws ParseException {
        StringReader sr = new StringReader(expression);
        Expression e = new ASTParser(sr).Expression();
        sr.close();
        return e;
    }

    public static AnnotationExpr parseAnnotation(String annotation) throws ParseException {
        StringReader sr = new StringReader(annotation);
        AnnotationExpr ae = new ASTParser(sr).Annotation();
        sr.close();
        return ae;
    }

    public static BodyDeclaration parseBodyDeclaration(String body) throws ParseException {
        StringReader sr = new StringReader(body);
        BodyDeclaration bd = new ASTParser(sr).AnnotationBodyDeclaration();
        sr.close();
        return bd;
    }

    static {
        cacheParser = true;
    }
}

