/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.cmd.models.SimplifiedType;
import io.apicurio.datamodels.cmd.util.SimplifiedTypeUtil;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.compat.MarshallCompat;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.NodePath;
import io.apicurio.datamodels.openapi.models.OasHeader;
import io.apicurio.datamodels.openapi.v3.models.Oas30Header;

public class ChangeHeaderTypeCommand
extends AbstractCommand {
    public NodePath _headerPath;
    public String _headerName;
    public SimplifiedType _newType;
    public boolean _changed;
    @JsonDeserialize(using=MarshallCompat.NullableJsonNodeDeserializer.class)
    public Object _oldHeaderTypeSchema;

    ChangeHeaderTypeCommand() {
    }

    ChangeHeaderTypeCommand(OasHeader header, SimplifiedType newType) {
        this._headerName = header.getName();
        this._headerPath = Library.createNodePath(header);
        this._newType = newType;
    }

    @Override
    public void execute(Document document) {
        LoggerCompat.info("[ChangeHeaderTypeCommand] Executing.", new Object[0]);
        this._changed = false;
        Oas30Header header = (Oas30Header)this._headerPath.resolve(document);
        if (this.isNullOrUndefined(header)) {
            return;
        }
        if (this.isNullOrUndefined(header.schema)) {
            this._oldHeaderTypeSchema = null;
            header.schema = header.createSchema();
        } else {
            this._oldHeaderTypeSchema = Library.writeNode(header.schema);
        }
        SimplifiedTypeUtil.setSimplifiedType(header.schema, this._newType);
        this._changed = true;
    }

    @Override
    public void undo(Document document) {
        LoggerCompat.info("[ChangeHeaderTypeCommand] Reverting.", new Object[0]);
        if (!this._changed) {
            return;
        }
        Oas30Header header = (Oas30Header)this._headerPath.resolve(document);
        if (this.isNullOrUndefined(header)) {
            return;
        }
        if (this.isNullOrUndefined(this._oldHeaderTypeSchema)) {
            header.schema = null;
        } else {
            header.schema = header.createSchema();
            Library.readNode(this._oldHeaderTypeSchema, header.schema);
        }
    }
}

