/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.cmd.util.ModelUtils;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.Node;
import io.apicurio.datamodels.core.models.NodePath;
import io.apicurio.datamodels.openapi.models.IOasHeaderParent;
import io.apicurio.datamodels.openapi.models.OasHeader;

public class NewHeaderCommand
extends AbstractCommand {
    public NodePath _nodePath;
    public String _name;
    public Object _newHeader;
    public boolean _created;

    NewHeaderCommand() {
    }

    NewHeaderCommand(IOasHeaderParent parent, String name) {
        this._nodePath = Library.createNodePath((Node)((Object)parent));
        this._name = name;
    }

    @Override
    public void execute(Document document) {
        LoggerCompat.info("[NewHttpHeaderCommand] Executing.", new Object[0]);
        this._created = false;
        IOasHeaderParent node = (IOasHeaderParent)((Object)this._nodePath.resolve(document));
        if (this.isNullOrUndefined(node)) {
            return;
        }
        OasHeader header = node.getHeader(this._name);
        if (ModelUtils.isDefined(header)) {
            return;
        }
        OasHeader nodeHeader = node.createHeader(this._name);
        node.addHeader(this._name, nodeHeader);
        this._created = true;
    }

    @Override
    public void undo(Document document) {
        LoggerCompat.info("[NewHeaderCommand] Reverting.", new Object[0]);
        if (!this._created) {
            LoggerCompat.info("[NewHeaderCommand]  header already existed, nothing done so no rollback necessary.", new Object[0]);
            return;
        }
        IOasHeaderParent node = (IOasHeaderParent)((Object)this._nodePath.resolve(document));
        if (this.isNullOrUndefined(node)) {
            return;
        }
        node.removeHeader(this._name);
    }
}

