/*
 * Decompiled with CFR 0.152.
 */
package org.jsonschema2pojo.rules;

import com.fasterxml.jackson.databind.JsonNode;
import com.sun.codemodel.JAnnotationArrayMember;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JConditional;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jsonschema2pojo.GenerationConfig;
import org.jsonschema2pojo.Schema;
import org.jsonschema2pojo.rules.Rule;
import org.jsonschema2pojo.rules.RuleFactory;
import org.jsonschema2pojo.util.NameHelper;
import org.jsonschema2pojo.util.ReflectionHelper;

public class ConstructorRule
implements Rule<JDefinedClass, JDefinedClass> {
    private final RuleFactory ruleFactory;
    private final ReflectionHelper reflectionHelper;

    ConstructorRule(RuleFactory ruleFactory, ReflectionHelper reflectionHelper) {
        this.ruleFactory = ruleFactory;
        this.reflectionHelper = reflectionHelper;
    }

    @Override
    public JDefinedClass apply(String nodeName, JsonNode node, JsonNode parent, JDefinedClass instanceClass, Schema currentSchema) {
        GenerationConfig generationConfig = this.ruleFactory.getGenerationConfig();
        if (generationConfig.isConstructorsRequiredPropertiesOnly()) {
            this.handleLegacyConfiguration(node, instanceClass, currentSchema);
        } else {
            this.handleMultiChoiceConstructorConfiguration(node, instanceClass, currentSchema);
        }
        return instanceClass;
    }

    private JDefinedClass handleLegacyConfiguration(JsonNode node, JDefinedClass instanceClass, Schema currentSchema) {
        LinkedHashSet<String> requiredClassProperties = this.getConstructorProperties(node, true);
        LinkedHashSet<String> requiredCombinedSuperProperties = this.getSuperTypeConstructorPropertiesRecursive(node, currentSchema, true);
        if (!requiredClassProperties.isEmpty() || !requiredCombinedSuperProperties.isEmpty()) {
            this.generateNoArgsConstructor(instanceClass);
            this.addFieldsConstructor(instanceClass, requiredClassProperties, requiredCombinedSuperProperties);
        }
        return instanceClass;
    }

    private void handleMultiChoiceConstructorConfiguration(JsonNode node, JDefinedClass instanceClass, Schema currentSchema) {
        boolean requiresConstructors = false;
        LinkedHashSet<String> requiredClassProperties = null;
        LinkedHashSet<String> classProperties = null;
        LinkedHashSet<String> requiredCombinedSuperProperties = null;
        LinkedHashSet<String> combinedSuperProperties = null;
        GenerationConfig generationConfig = this.ruleFactory.getGenerationConfig();
        boolean includeCopyConstructor = generationConfig.isIncludeCopyConstructor();
        boolean includeAllPropertiesConstructor = generationConfig.isIncludeAllPropertiesConstructor();
        boolean includeRequiredPropertiesConstructor = generationConfig.isIncludeRequiredPropertiesConstructor();
        if (includeAllPropertiesConstructor || includeCopyConstructor) {
            classProperties = this.getConstructorProperties(node, false);
            combinedSuperProperties = this.getSuperTypeConstructorPropertiesRecursive(node, currentSchema, false);
            boolean bl = requiresConstructors = requiresConstructors || !classProperties.isEmpty() || !combinedSuperProperties.isEmpty();
        }
        if (includeRequiredPropertiesConstructor) {
            requiredClassProperties = this.getConstructorProperties(node, true);
            requiredCombinedSuperProperties = this.getSuperTypeConstructorPropertiesRecursive(node, currentSchema, true);
            boolean bl = requiresConstructors = requiresConstructors || !requiredClassProperties.isEmpty() || !requiredCombinedSuperProperties.isEmpty();
        }
        if (requiresConstructors) {
            this.generateNoArgsConstructor(instanceClass);
            if (includeCopyConstructor) {
                this.addCopyConstructor(instanceClass, classProperties, combinedSuperProperties);
            }
            if (includeAllPropertiesConstructor && classProperties.size() + combinedSuperProperties.size() > 0) {
                this.addFieldsConstructor(instanceClass, classProperties, combinedSuperProperties);
            }
            if (includeRequiredPropertiesConstructor && requiredClassProperties.size() + requiredCombinedSuperProperties.size() > 0) {
                this.addFieldsConstructor(instanceClass, requiredClassProperties, requiredCombinedSuperProperties);
            }
        }
    }

    private void addFieldsConstructor(JDefinedClass instanceClass, Set<String> classProperties, Set<String> combinedSuperProperties) {
        GenerationConfig generationConfig = this.ruleFactory.getGenerationConfig();
        JMethod instanceConstructor = this.generateFieldsConstructor(instanceClass, classProperties, combinedSuperProperties);
        if (generationConfig.isGenerateBuilders() && generationConfig.isUseInnerClassBuilders()) {
            JDefinedClass baseBuilderClass = this.ruleFactory.getReflectionHelper().getBaseBuilderClass(instanceClass);
            JDefinedClass concreteBuilderClass = this.ruleFactory.getReflectionHelper().getConcreteBuilderClass(instanceClass);
            this.generateFieldsBuilderConstructor(baseBuilderClass, concreteBuilderClass, instanceClass, instanceConstructor);
        }
    }

    private void addCopyConstructor(JDefinedClass instanceClass, Set<String> classProperties, Set<String> combinedSuperProperties) {
        GenerationConfig generationConfig = this.ruleFactory.getGenerationConfig();
        JMethod instanceConstructor = this.generateCopyConstructor(instanceClass, classProperties, combinedSuperProperties);
        if (generationConfig.isGenerateBuilders() && generationConfig.isUseInnerClassBuilders()) {
            JDefinedClass baseBuilderClass = this.ruleFactory.getReflectionHelper().getBaseBuilderClass(instanceClass);
            JDefinedClass concreteBuilderClass = this.ruleFactory.getReflectionHelper().getConcreteBuilderClass(instanceClass);
            this.generateFieldsBuilderConstructor(baseBuilderClass, concreteBuilderClass, instanceClass, instanceConstructor);
        }
    }

    private LinkedHashSet<String> getConstructorProperties(JsonNode node, boolean onlyRequired) {
        JsonNode requiredArray;
        if (!node.has("properties")) {
            return new LinkedHashSet<String>();
        }
        LinkedHashSet<String> rtn = new LinkedHashSet<String>();
        HashSet<String> draft4RequiredProperties = new HashSet<String>();
        if (onlyRequired && node.has("required") && (requiredArray = node.get("required")).isArray()) {
            for (JsonNode requiredEntry : requiredArray) {
                if (!requiredEntry.isTextual()) continue;
                draft4RequiredProperties.add(requiredEntry.asText());
            }
        }
        NameHelper nameHelper = this.ruleFactory.getNameHelper();
        Iterator properties = node.get("properties").fields();
        while (properties.hasNext()) {
            Map.Entry property = (Map.Entry)properties.next();
            JsonNode propertyObj = (JsonNode)property.getValue();
            if (onlyRequired) {
                if (propertyObj.has("required") && propertyObj.get("required").asBoolean()) {
                    rtn.add(nameHelper.getPropertyName((String)property.getKey(), (JsonNode)property.getValue()));
                }
                if (!draft4RequiredProperties.contains(property.getKey())) continue;
                rtn.add(nameHelper.getPropertyName((String)property.getKey(), (JsonNode)property.getValue()));
                continue;
            }
            rtn.add(nameHelper.getPropertyName((String)property.getKey(), (JsonNode)property.getValue()));
        }
        return rtn;
    }

    private LinkedHashSet<String> getSuperTypeConstructorPropertiesRecursive(JsonNode node, Schema schema, boolean onlyRequired) {
        Schema superTypeSchema = this.reflectionHelper.getSuperSchema(node, schema, true);
        if (superTypeSchema == null) {
            return new LinkedHashSet<String>();
        }
        JsonNode superSchemaNode = superTypeSchema.getContent();
        LinkedHashSet<String> rtn = this.getConstructorProperties(superSchemaNode, onlyRequired);
        rtn.addAll(this.getSuperTypeConstructorPropertiesRecursive(superSchemaNode, superTypeSchema, onlyRequired));
        return rtn;
    }

    private void generateFieldsBuilderConstructor(JDefinedClass builderClass, JDefinedClass concreteBuilderClass, JDefinedClass instanceClass, JMethod instanceConstructor) {
        JFieldVar instanceField = this.reflectionHelper.searchClassAndSuperClassesForField("instance", builderClass);
        JMethod builderConstructor = builderClass.constructor(1);
        builderConstructor.annotate(SuppressWarnings.class).param("value", "unchecked");
        JBlock constructorBlock = builderConstructor.body();
        for (JVar param : instanceConstructor.params()) {
            builderConstructor.param(param.type(), param.name());
        }
        JClass parentClass = builderClass._extends();
        if (!(parentClass.isPrimitive() || this.reflectionHelper.isFinal((JType)parentClass) || Objects.equals(parentClass.fullName(), "java.lang.Object"))) {
            constructorBlock.invoke("super");
        }
        JInvocation instanceConstructorInvocation = JExpr._new((JClass)instanceClass);
        for (JVar param : instanceConstructor.params()) {
            instanceConstructorInvocation.arg((JExpression)param);
        }
        constructorBlock.directStatement("// Skip initialization when called from subclass");
        JInvocation comparison = JExpr._this().invoke("getClass").invoke("equals").arg(JExpr.dotclass((JClass)concreteBuilderClass));
        JConditional ifNotSubclass = constructorBlock._if((JExpression)comparison);
        ifNotSubclass._then().assign((JAssignmentTarget)JExpr._this().ref((JVar)instanceField), (JExpression)JExpr.cast((JType)instanceField.type(), (JExpression)instanceConstructorInvocation));
        this.generateFieldsConcreteBuilderConstructor(builderClass, concreteBuilderClass, instanceConstructor);
    }

    private void generateFieldsConcreteBuilderConstructor(JDefinedClass baseBuilderClass, JDefinedClass builderClass, JMethod instanceConstructor) {
        JMethod builderConstructor = builderClass.constructor(1);
        JBlock builderConstructorBlock = builderConstructor.body();
        for (JVar param : instanceConstructor.params()) {
            builderConstructor.param(param.type(), param.name());
        }
        if (!(baseBuilderClass.isPrimitive() || this.reflectionHelper.isFinal((JType)baseBuilderClass) || Objects.equals(baseBuilderClass.fullName(), "java.lang.Object"))) {
            JInvocation superMethod = builderConstructorBlock.invoke("super");
            for (JVar param : builderConstructor.params()) {
                superMethod.arg((JExpression)param);
            }
        }
    }

    private JMethod generateCopyConstructor(JDefinedClass jclass, Set<String> classProperties, Set<String> combinedSuperProperties) {
        JMethod copyConstructorResult = jclass.constructor(1);
        copyConstructorResult.javadoc().addParam("source");
        JVar copyConstructorParam = copyConstructorResult.param((JType)jclass, "source");
        JBlock constructorBody = copyConstructorResult.body();
        JInvocation superInvocation = constructorBody.invoke("super");
        if (!combinedSuperProperties.isEmpty()) {
            superInvocation.arg((JExpression)copyConstructorParam);
        }
        Map fields = jclass.fields();
        for (String property : classProperties) {
            JFieldVar field = (JFieldVar)fields.get(property);
            if (field == null) {
                throw new IllegalStateException("Property " + property + " hasn't been added to JDefinedClass before calling addConstructors");
            }
            constructorBody.assign((JAssignmentTarget)JExpr._this().ref((JVar)field), (JExpression)copyConstructorParam.ref((JVar)field));
        }
        return copyConstructorResult;
    }

    private JMethod generateFieldsConstructor(JDefinedClass jclass, Set<String> classProperties, Set<String> combinedSuperProperties) {
        JMethod fieldsConstructor = jclass.constructor(1);
        GenerationConfig generationConfig = this.ruleFactory.getGenerationConfig();
        JAnnotationArrayMember constructorPropertiesAnnotation = generationConfig.isIncludeConstructorPropertiesAnnotation() ? fieldsConstructor.annotate(ConstructorProperties.class).paramArray("value") : null;
        JBlock constructorBody = fieldsConstructor.body();
        JInvocation superInvocation = constructorBody.invoke("super");
        Map fields = jclass.fields();
        HashMap<String, JVar> classFieldParams = new HashMap<String, JVar>();
        for (String property : classProperties) {
            JFieldVar field = (JFieldVar)fields.get(property);
            if (field == null) {
                throw new IllegalStateException("Property " + property + " hasn't been added to JDefinedClass before calling addConstructors");
            }
            fieldsConstructor.javadoc().addParam(property);
            if (generationConfig.isIncludeConstructorPropertiesAnnotation() && constructorPropertiesAnnotation != null) {
                constructorPropertiesAnnotation.param(field.name());
            }
            JVar param = fieldsConstructor.param(field.type(), field.name());
            constructorBody.assign((JAssignmentTarget)JExpr._this().ref((JVar)field), (JExpression)param);
            classFieldParams.put(property, param);
        }
        ArrayList<JVar> superConstructorParams = new ArrayList<JVar>();
        for (String property : combinedSuperProperties) {
            JFieldVar field = this.reflectionHelper.searchSuperClassesForField(property, jclass);
            if (field == null) {
                throw new IllegalStateException("Property " + property + " hasn't been added to JDefinedClass before calling addConstructors");
            }
            JVar param = (JVar)classFieldParams.get(property);
            if (param == null) {
                param = fieldsConstructor.param(field.type(), field.name());
            }
            fieldsConstructor.javadoc().addParam(property);
            if (generationConfig.isIncludeConstructorPropertiesAnnotation() && constructorPropertiesAnnotation != null) {
                constructorPropertiesAnnotation.param(param.name());
            }
            superConstructorParams.add(param);
        }
        for (JVar param : superConstructorParams) {
            superInvocation.arg((JExpression)param);
        }
        return fieldsConstructor;
    }

    private void generateNoArgsConstructor(JDefinedClass jclass) {
        JMethod noargsConstructor = jclass.constructor(1);
        noargsConstructor.javadoc().add((Object)"No args constructor for use in serialization");
    }
}

