/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.api;

import io.nats.client.Message;
import io.nats.client.api.AccountLimits;
import io.nats.client.api.AccountTier;
import io.nats.client.api.ApiResponse;
import io.nats.client.api.ApiStats;
import io.nats.client.support.ApiConstants;
import io.nats.client.support.JsonUtils;
import java.util.HashMap;
import java.util.Map;

public class AccountStatistics
extends ApiResponse<AccountStatistics> {
    private final AccountTier rollup;
    private final String domain;
    private final ApiStats api;
    private final Map<String, AccountTier> tiers;

    public AccountStatistics(Message msg) {
        super(msg);
        this.rollup = new AccountTier(this.json);
        this.domain = JsonUtils.readString(this.json, ApiConstants.DOMAIN_RE);
        this.api = new ApiStats(JsonUtils.getJsonObject("api", this.json));
        String tiersJson = JsonUtils.getJsonObject("tiers", this.json);
        Map<String, String> jsonByKey = JsonUtils.getMapOfObjects(tiersJson);
        this.tiers = new HashMap<String, AccountTier>();
        for (String key : jsonByKey.keySet()) {
            this.tiers.put(key, new AccountTier(jsonByKey.get(key)));
        }
    }

    public long getMemory() {
        return this.rollup.getMemory();
    }

    public long getStorage() {
        return this.rollup.getStorage();
    }

    public long getStreams() {
        return this.rollup.getStreams();
    }

    public long getConsumers() {
        return this.rollup.getConsumers();
    }

    public AccountLimits getLimits() {
        return this.rollup.getLimits();
    }

    public String getDomain() {
        return this.domain;
    }

    public ApiStats getApi() {
        return this.api;
    }

    public Map<String, AccountTier> getTiers() {
        return this.tiers;
    }

    public String toString() {
        return "AccountStatsImpl{memory=" + this.rollup.getMemory() + ", storage=" + this.rollup.getStorage() + ", streams=" + this.rollup.getStreams() + ", consumers=" + this.rollup.getConsumers() + ", " + JsonUtils.objectString("limits", this.rollup.getLimits()) + ", domain=" + this.domain + ", " + JsonUtils.objectString("api", this.api) + ", tiers=" + this.tiers.keySet() + '}';
    }
}

