/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.gms;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.gms.EndpointState;
import org.apache.cassandra.gms.GossipDigest;
import org.apache.cassandra.gms.GossipDigestAck;
import org.apache.cassandra.gms.GossipDigestAck2;
import org.apache.cassandra.gms.GossipVerbHandler;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.net.Verb;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GossipDigestAckVerbHandler
extends GossipVerbHandler<GossipDigestAck> {
    public static final GossipDigestAckVerbHandler instance = new GossipDigestAckVerbHandler();
    private static final Logger logger = LoggerFactory.getLogger(GossipDigestAckVerbHandler.class);

    @Override
    public void doVerb(Message<GossipDigestAck> message) {
        InetAddressAndPort from = message.from();
        if (logger.isTraceEnabled()) {
            logger.trace("Received a GossipDigestAckMessage from {}", (Object)from);
        }
        if (!Gossiper.instance.isEnabled() && !Gossiper.instance.isInShadowRound()) {
            if (logger.isTraceEnabled()) {
                logger.trace("Ignoring GossipDigestAckMessage because gossip is disabled");
            }
            return;
        }
        GossipDigestAck gDigestAckMessage = (GossipDigestAck)message.payload;
        List<GossipDigest> gDigestList = gDigestAckMessage.getGossipDigestList();
        Map<InetAddressAndPort, EndpointState> epStateMap = gDigestAckMessage.getEndpointStateMap();
        logger.trace("Received ack with {} digests and {} states", (Object)gDigestList.size(), (Object)epStateMap.size());
        if (Gossiper.instance.isInShadowRound()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Received an ack from {}, which may trigger exit from shadow round", (Object)from);
            }
            Gossiper.instance.maybeFinishShadowRound(from, gDigestList.isEmpty() && epStateMap.isEmpty(), epStateMap);
            return;
        }
        if (epStateMap.size() > 0) {
            if (System.nanoTime() - Gossiper.instance.firstSynSendAt < 0L || Gossiper.instance.firstSynSendAt == 0L) {
                if (logger.isTraceEnabled()) {
                    logger.trace("Ignoring unrequested GossipDigestAck from {}", (Object)from);
                }
                return;
            }
            Gossiper.instance.notifyFailureDetector(epStateMap);
            Gossiper.instance.applyStateLocally(epStateMap);
        }
        HashMap<InetAddressAndPort, EndpointState> deltaEpStateMap = new HashMap<InetAddressAndPort, EndpointState>();
        for (GossipDigest gDigest : gDigestList) {
            InetAddressAndPort addr = gDigest.getEndpoint();
            EndpointState localEpStatePtr = Gossiper.instance.getStateForVersionBiggerThan(addr, gDigest.getMaxVersion());
            if (localEpStatePtr == null) continue;
            deltaEpStateMap.put(addr, localEpStatePtr);
        }
        Message<GossipDigestAck2> gDigestAck2Message = Message.out(Verb.GOSSIP_DIGEST_ACK2, new GossipDigestAck2(deltaEpStateMap));
        if (logger.isTraceEnabled()) {
            logger.trace("Sending a GossipDigestAck2Message to {}", (Object)from);
        }
        MessagingService.instance().send(gDigestAck2Message, from);
        super.doVerb(message);
    }
}

