/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.cassandra.streaming.SessionInfo;
import org.apache.cassandra.streaming.SessionSummary;
import org.apache.cassandra.streaming.StreamOperation;

public class StreamState
implements Serializable {
    public final UUID planId;
    public final StreamOperation streamOperation;
    public final Set<SessionInfo> sessions;

    public StreamState(UUID planId, StreamOperation streamOperation, Set<SessionInfo> sessions) {
        this.planId = planId;
        this.sessions = sessions;
        this.streamOperation = streamOperation;
    }

    public boolean hasFailedSession() {
        return Iterables.any(this.sessions, (Predicate)new Predicate<SessionInfo>(){

            public boolean apply(SessionInfo session) {
                return session.isFailed();
            }
        });
    }

    public List<SessionSummary> createSummaries() {
        return Lists.newArrayList((Iterable)Iterables.transform(this.sessions, SessionInfo::createSummary));
    }
}

