/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools.nodetool;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import io.airlift.airline.Arguments;
import io.airlift.airline.Command;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.db.ColumnFamilyStoreMBean;
import org.apache.cassandra.metrics.CassandraMetricsRegistry;
import org.apache.cassandra.tools.NodeProbe;
import org.apache.cassandra.tools.NodeTool;
import org.apache.cassandra.utils.EstimatedHistogram;
import org.apache.commons.lang3.ArrayUtils;

@Command(name="tablehistograms", description="Print statistic histograms for a given table")
public class TableHistograms
extends NodeTool.NodeToolCmd {
    @Arguments(usage="[<keyspace> <table> | <keyspace.table>]", description="The keyspace and table name")
    private List<String> args = new ArrayList<String>();

    @Override
    public void execute(NodeProbe probe) {
        PrintStream out = probe.output().out;
        HashMultimap tablesList = HashMultimap.create();
        HashMultimap allTables = HashMultimap.create();
        Iterator<Map.Entry<String, ColumnFamilyStoreMBean>> tableMBeans = probe.getColumnFamilyStoreMBeanProxies();
        while (tableMBeans.hasNext()) {
            Map.Entry<String, ColumnFamilyStoreMBean> entry = tableMBeans.next();
            allTables.put((Object)entry.getKey(), (Object)entry.getValue().getTableName());
        }
        if (this.args.size() == 2) {
            tablesList.put((Object)this.args.get(0), (Object)this.args.get(1));
        } else if (this.args.size() == 1) {
            String[] input = this.args.get(0).split("\\.");
            Preconditions.checkArgument((input.length == 2 ? 1 : 0) != 0, (Object)"tablehistograms requires keyspace and table name arguments");
            tablesList.put((Object)input[0], (Object)input[1]);
        } else {
            tablesList = allTables;
        }
        for (String keyspace : tablesList.keys()) {
            for (String table : tablesList.get((Object)keyspace)) {
                if (allTables.containsEntry((Object)keyspace, (Object)table)) continue;
                throw new IllegalArgumentException("Unknown table " + keyspace + '.' + table);
            }
        }
        for (String keyspace : tablesList.keys()) {
            for (String table : tablesList.get((Object)keyspace)) {
                long[] estimatedPartitionSize = (long[])probe.getColumnFamilyMetric(keyspace, table, "EstimatedPartitionSizeHistogram");
                long[] estimatedColumnCount = (long[])probe.getColumnFamilyMetric(keyspace, table, "EstimatedColumnCountHistogram");
                double[] estimatedRowSizePercentiles = new double[7];
                double[] estimatedColumnCountPercentiles = new double[7];
                double[] offsetPercentiles = new double[]{0.5, 0.75, 0.95, 0.98, 0.99};
                if (ArrayUtils.isEmpty((long[])estimatedPartitionSize) || ArrayUtils.isEmpty((long[])estimatedColumnCount)) {
                    out.println("No SSTables exists, unable to calculate 'Partition Size' and 'Cell Count' percentiles");
                    for (int i = 0; i < 7; ++i) {
                        estimatedRowSizePercentiles[i] = Double.NaN;
                        estimatedColumnCountPercentiles[i] = Double.NaN;
                    }
                } else {
                    int i;
                    EstimatedHistogram partitionSizeHist = new EstimatedHistogram(estimatedPartitionSize);
                    EstimatedHistogram columnCountHist = new EstimatedHistogram(estimatedColumnCount);
                    if (partitionSizeHist.isOverflowed()) {
                        out.println(String.format("Row sizes are larger than %s, unable to calculate percentiles", partitionSizeHist.getLargestBucketOffset()));
                        for (i = 0; i < offsetPercentiles.length; ++i) {
                            estimatedRowSizePercentiles[i] = Double.NaN;
                        }
                    } else {
                        for (i = 0; i < offsetPercentiles.length; ++i) {
                            estimatedRowSizePercentiles[i] = partitionSizeHist.percentile(offsetPercentiles[i]);
                        }
                    }
                    if (columnCountHist.isOverflowed()) {
                        out.println(String.format("Column counts are larger than %s, unable to calculate percentiles", columnCountHist.getLargestBucketOffset()));
                        for (i = 0; i < estimatedColumnCountPercentiles.length; ++i) {
                            estimatedColumnCountPercentiles[i] = Double.NaN;
                        }
                    } else {
                        for (i = 0; i < offsetPercentiles.length; ++i) {
                            estimatedColumnCountPercentiles[i] = columnCountHist.percentile(offsetPercentiles[i]);
                        }
                    }
                    estimatedRowSizePercentiles[5] = partitionSizeHist.min();
                    estimatedColumnCountPercentiles[5] = columnCountHist.min();
                    estimatedRowSizePercentiles[6] = partitionSizeHist.max();
                    estimatedColumnCountPercentiles[6] = columnCountHist.max();
                }
                String[] percentiles = new String[]{"50%", "75%", "95%", "98%", "99%", "Min", "Max"};
                Double[] readLatency = probe.metricPercentilesAsArray((CassandraMetricsRegistry.JmxTimerMBean)probe.getColumnFamilyMetric(keyspace, table, "ReadLatency"));
                Double[] writeLatency = probe.metricPercentilesAsArray((CassandraMetricsRegistry.JmxTimerMBean)probe.getColumnFamilyMetric(keyspace, table, "WriteLatency"));
                Double[] sstablesPerRead = probe.metricPercentilesAsArray((CassandraMetricsRegistry.JmxHistogramMBean)probe.getColumnFamilyMetric(keyspace, table, "SSTablesPerReadHistogram"));
                out.println(String.format("%s/%s histograms", keyspace, table));
                out.println(String.format("%-10s%18s%18s%18s%18s%18s", "Percentile", "Read Latency", "Write Latency", "SSTables", "Partition Size", "Cell Count"));
                out.println(String.format("%-10s%18s%18s%18s%18s%18s", "", "(micros)", "(micros)", "", "(bytes)", ""));
                for (int i = 0; i < percentiles.length; ++i) {
                    out.println(String.format("%-10s%18.2f%18.2f%18.2f%18.0f%18.0f", percentiles[i], readLatency[i], writeLatency[i], sstablesPerRead[i], estimatedRowSizePercentiles[i], estimatedColumnCountPercentiles[i]));
                }
                out.println();
            }
        }
    }
}

