/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.agent;

import java.io.PrintWriter;
import org.jboss.byteman.rule.Rule;

public class Transform {
    private ClassLoader loader;
    private String internalClassName;
    private String triggerMethodName;
    private Rule rule;
    private Throwable throwable;
    private boolean compiled;
    private boolean installed;
    private boolean successful;
    private String detail;

    public Transform(ClassLoader loader, String internalClassName, String triggerMethodName, Rule rule, Throwable th) {
        this.loader = loader;
        this.internalClassName = internalClassName;
        this.triggerMethodName = triggerMethodName;
        this.rule = rule;
        this.compiled = false;
        this.installed = false;
        this.throwable = th;
        this.successful = false;
        this.detail = "";
    }

    public ClassLoader getLoader() {
        return this.loader;
    }

    public String getInternalClassName() {
        return this.internalClassName;
    }

    public String getTriggerMethodName() {
        return this.triggerMethodName;
    }

    public Rule getRule() {
        return this.rule;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public String getDetail() {
        return this.detail;
    }

    public void setCompiled(boolean successful, String detail) {
        this.compiled = true;
        this.successful = successful;
        this.detail = detail;
    }

    public boolean isTransformed() {
        return this.throwable == null;
    }

    public boolean isCompiledOk() {
        return this.compiled && this.successful;
    }

    public boolean isInstalled() {
        return this.installed;
    }

    public void setInstalled() {
        this.installed = true;
    }

    public void writeTo(PrintWriter writer) {
        writer.print("Transformed in:\n");
        writer.print("loader: ");
        writer.println(this.loader);
        if (this.triggerMethodName == null) {
            writer.print("trigger class: ");
            writer.println(this.internalClassName);
        } else {
            writer.print("trigger method: ");
            writer.print(this.internalClassName);
            writer.print('.');
            writer.println(this.triggerMethodName);
        }
        if (this.throwable != null) {
            writer.print("threw ");
            writer.println(this.throwable);
            this.throwable.printStackTrace(writer);
        } else if (this.compiled) {
            if (this.successful) {
                writer.println("compiled successfully");
            } else {
                writer.println("failed to compile");
                writer.println(this.detail);
            }
        }
    }
}

