/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common.concurrent;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ExecutorServiceFactory {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExecutorServiceFactory.class);
    @VisibleForTesting
    static final String DETECTION_LEVEL_PROPERTY_NAME = "ThreadLeakDetectionLevel";
    @VisibleForTesting
    private final ThreadLeakDetectionLevel detectionLevel;
    private final CreateScheduledExecutor createScheduledExecutor;
    private final CreateShrinkingExecutor createShrinkingExecutor;
    private final Runnable onLeakDetected;

    ExecutorServiceFactory() {
        this(ExecutorServiceFactory.getDetectionLevel(), () -> System.exit(99));
    }

    @VisibleForTesting
    ExecutorServiceFactory(@NonNull ThreadLeakDetectionLevel level, @NonNull Runnable onLeakDetected) {
        if (level == null) {
            throw new NullPointerException("level is marked non-null but is null");
        }
        if (onLeakDetected == null) {
            throw new NullPointerException("onLeakDetected is marked non-null but is null");
        }
        this.detectionLevel = level;
        this.onLeakDetected = onLeakDetected;
        if (this.detectionLevel == ThreadLeakDetectionLevel.None) {
            this.createScheduledExecutor = (size, factory) -> new ScheduledThreadPoolExecutor(size, factory, new CallerRuns(factory.toString()));
            this.createShrinkingExecutor = (maxThreadCount, threadTimeout, factory) -> new ThreadPoolExecutor(0, maxThreadCount, threadTimeout, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), factory, new CallerRuns(factory.toString()));
        } else {
            this.createScheduledExecutor = (size, factory) -> {
                this.logNewThreadPoolCreated(factory.toString());
                return new LeakDetectorScheduledExecutorService(size, factory, new CallerRuns(factory.toString()));
            };
            this.createShrinkingExecutor = (maxThreadCount, threadTimeout, factory) -> {
                this.logNewThreadPoolCreated(factory.toString());
                return new LeakDetectorThreadPoolExecutor(0, maxThreadCount, threadTimeout, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), factory, new CallerRuns(factory.toString()));
            };
        }
    }

    @VisibleForTesting
    static ThreadLeakDetectionLevel getDetectionLevel() {
        return ThreadLeakDetectionLevel.valueOf(System.getProperty(DETECTION_LEVEL_PROPERTY_NAME, ThreadLeakDetectionLevel.None.name()));
    }

    ThreadFactory getThreadFactory(String groupName) {
        return this.getThreadFactory(groupName, 5);
    }

    ThreadFactory getThreadFactory(final String groupName, final int priority) {
        return new ThreadFactory(){
            final AtomicInteger threadCount = new AtomicInteger();

            public String toString() {
                return groupName;
            }

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r, groupName + "-" + this.threadCount.incrementAndGet());
                thread.setUncaughtExceptionHandler(new LogUncaughtExceptions());
                thread.setDaemon(true);
                thread.setPriority(priority);
                return thread;
            }
        };
    }

    ScheduledExecutorService newScheduledThreadPool(int size, String poolName, int threadPriority) {
        ThreadFactory threadFactory = this.getThreadFactory(poolName, threadPriority);
        ScheduledThreadPoolExecutor result = this.createScheduledExecutor.apply(size, threadFactory);
        result.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
        result.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        result.setRemoveOnCancelPolicy(true);
        return result;
    }

    ThreadPoolExecutor newShrinkingExecutor(int maxThreadCount, int threadTimeout, String poolName) {
        ThreadFactory factory = this.getThreadFactory(poolName);
        return this.createShrinkingExecutor.apply(maxThreadCount, threadTimeout, factory);
    }

    private void logNewThreadPoolCreated(String poolName) {
        if (this.detectionLevel == ThreadLeakDetectionLevel.Light) {
            log.debug("Created Thread Pool '{}' with leak detection level set to '{}'.", (Object)poolName, (Object)this.detectionLevel);
        } else if (this.detectionLevel == ThreadLeakDetectionLevel.Aggressive) {
            log.warn("Created Thread Pool '{}' with leak detection level set to '{}'. THE VM WILL BE HALTED IF A LEAK IS DETECTED. DO NOT USE IN PRODUCTION.", (Object)poolName, (Object)this.detectionLevel);
        }
    }

    @VisibleForTesting
    void checkThreadPoolLeak(ThreadPoolExecutor e, Exception stackTraceEx) {
        if (this.detectionLevel == ThreadLeakDetectionLevel.None) {
            return;
        }
        if (!e.isShutdown() || !e.isTerminated()) {
            log.warn("THREAD POOL LEAK: {} (ShutDown={}, Terminated={}) finalized without being properly shut down.", new Object[]{e.getThreadFactory(), e.isShutdown(), e.isTerminated(), stackTraceEx});
            if (this.detectionLevel == ThreadLeakDetectionLevel.Aggressive) {
                stackTraceEx.printStackTrace(System.err);
                log.error("THREAD POOL LEAK DETECTED WITH LEVEL SET TO {}. SHUTTING DOWN.", (Object)ThreadLeakDetectionLevel.Aggressive);
                this.onLeakDetected.run();
            }
        }
    }

    @FunctionalInterface
    private static interface CreateShrinkingExecutor {
        public ThreadPoolExecutor apply(int var1, int var2, ThreadFactory var3);
    }

    @FunctionalInterface
    private static interface CreateScheduledExecutor {
        public ScheduledThreadPoolExecutor apply(int var1, ThreadFactory var2);
    }

    static enum ThreadLeakDetectionLevel {
        None,
        Light,
        Aggressive;

    }

    private class LeakDetectorThreadPoolExecutor
    extends ThreadPoolExecutor {
        private final Exception stackTraceEx;

        LeakDetectorThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
            super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
            this.stackTraceEx = new Exception();
        }

        @Override
        protected void finalize() {
            ExecutorServiceFactory.this.checkThreadPoolLeak(this, this.stackTraceEx);
            super.finalize();
        }
    }

    private class LeakDetectorScheduledExecutorService
    extends ScheduledThreadPoolExecutor {
        private final Exception stackTraceEx;

        LeakDetectorScheduledExecutorService(int corePoolSize, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
            super(corePoolSize, threadFactory, handler);
            this.stackTraceEx = new Exception();
        }

        @Override
        protected void finalize() {
            ExecutorServiceFactory.this.checkThreadPoolLeak(this, this.stackTraceEx);
            super.finalize();
        }
    }

    private static class CallerRuns
    implements RejectedExecutionHandler {
        private final String poolName;

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            log.debug("Caller to executor: " + this.poolName + " rejected and run in the caller.");
            r.run();
        }

        @ConstructorProperties(value={"poolName"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public CallerRuns(String poolName) {
            this.poolName = poolName;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getPoolName() {
            return this.poolName;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CallerRuns)) {
                return false;
            }
            CallerRuns other = (CallerRuns)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$poolName = this.getPoolName();
            String other$poolName = other.getPoolName();
            return !(this$poolName == null ? other$poolName != null : !this$poolName.equals(other$poolName));
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CallerRuns;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $poolName = this.getPoolName();
            result = result * 59 + ($poolName == null ? 43 : $poolName.hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "ExecutorServiceFactory.CallerRuns(poolName=" + this.getPoolName() + ")";
        }
    }

    private static final class LogUncaughtExceptions
    implements Thread.UncaughtExceptionHandler {
        private LogUncaughtExceptions() {
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            log.error("Exception thrown out of root of thread: " + t.getName(), e);
        }
    }
}

