/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.cmd.util.ModelUtils;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.compat.MarshallCompat;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.ExtensibleNode;
import io.apicurio.datamodels.core.models.Extension;
import io.apicurio.datamodels.core.models.NodePath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DeleteAllExtensionsCommand
extends AbstractCommand {
    public NodePath _parentPath;
    @JsonDeserialize(contentUsing=MarshallCompat.NullableJsonNodeDeserializer.class)
    public List<Object> _oldExtensions;

    DeleteAllExtensionsCommand() {
    }

    DeleteAllExtensionsCommand(ExtensibleNode parent) {
        this._parentPath = Library.createNodePath(parent);
    }

    @Override
    public void execute(Document document) {
        LoggerCompat.info("[DeleteAllExtensionsCommand] Executing.", new Object[0]);
        this._oldExtensions = new ArrayList<Object>();
        ExtensibleNode parent = (ExtensibleNode)this._parentPath.resolve(document);
        Collection<Extension> extensions = parent.getExtensions();
        if (!this.isNullOrUndefined(extensions)) {
            extensions.forEach(extension -> this._oldExtensions.add(ModelUtils.marshalExtension(extension)));
        }
        parent.clearExtensions();
    }

    @Override
    public void undo(Document document) {
        LoggerCompat.info("[DeleteAllExtensionsCommand] Reverting.", new Object[0]);
        if (this._oldExtensions.size() == 0) {
            return;
        }
        ExtensibleNode parent = (ExtensibleNode)this._parentPath.resolve(document);
        this._oldExtensions.forEach(oldExtension -> {
            Extension extension = parent.createExtension();
            ModelUtils.unmarshalExtension(oldExtension, extension);
            parent.addExtension(extension.name, extension);
        });
    }
}

