/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.asyncapi.models.AaiServer;
import io.apicurio.datamodels.asyncapi.v2.models.Aai20Document;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.compat.MarshallCompat;
import io.apicurio.datamodels.compat.NodeCompat;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.Node;
import java.util.LinkedHashMap;
import java.util.Map;

public class DeleteAllServersCommand_Aai20
extends AbstractCommand {
    @JsonDeserialize(contentUsing=MarshallCompat.NullableJsonNodeDeserializer.class)
    public Map<String, Object> _oldServers;

    DeleteAllServersCommand_Aai20() {
    }

    @Override
    public void execute(Document document) {
        LoggerCompat.info("[DeleteAllServersCommand_Aai20] Executing.", new Object[0]);
        this._oldServers = new LinkedHashMap<String, Object>();
        Aai20Document parent = (Aai20Document)document;
        if (this.isNullOrUndefined(parent.servers)) {
            return;
        }
        Map servers = parent.servers;
        if (!this.isNullOrUndefined(servers)) {
            servers.keySet().forEach(serverName -> this._oldServers.put((String)serverName, Library.writeNode((Node)servers.get(serverName))));
        }
        NodeCompat.setProperty(parent, "servers", new LinkedHashMap());
    }

    @Override
    public void undo(Document document) {
        LoggerCompat.info("[DeleteAllServersCommand_Aai20] Reverting.", new Object[0]);
        if (this._oldServers.size() == 0) {
            return;
        }
        Aai20Document parent = (Aai20Document)document;
        if (this.isNullOrUndefined(parent.servers)) {
            return;
        }
        LinkedHashMap servers = parent.servers;
        if (this.isNullOrUndefined(servers)) {
            servers = new LinkedHashMap();
            NodeCompat.setProperty(parent, "servers", servers);
        }
        this._oldServers.keySet().forEach(serverName -> {
            AaiServer server = parent.createServer((String)serverName);
            Library.readNode(this._oldServers.get(serverName), server);
            parent.servers.put(serverName, server);
        });
    }
}

