/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.compat.MarshallCompat;
import io.apicurio.datamodels.core.models.Document;

public abstract class DeleteSchemaDefinitionCommand
extends AbstractCommand {
    public String _definitionName;
    @JsonDeserialize(using=MarshallCompat.NullableJsonNodeDeserializer.class)
    public Object _oldDefinition;

    DeleteSchemaDefinitionCommand() {
    }

    DeleteSchemaDefinitionCommand(String definitionName) {
        this._definitionName = definitionName;
    }

    @Override
    public void execute(Document document) {
        LoggerCompat.info("[DeleteDefinitionSchemaCommand] Executing.", new Object[0]);
        this._oldDefinition = this.doDeleteSchemaDefinition(document);
    }

    @Override
    public void undo(Document document) {
        LoggerCompat.info("[DeleteDefinitionSchemaCommand] Reverting.", new Object[0]);
        if (this.isNullOrUndefined(this._oldDefinition)) {
            return;
        }
        this.doRestoreSchemaDefinition(document, this._oldDefinition);
    }

    protected abstract Object doDeleteSchemaDefinition(Document var1);

    protected abstract void doRestoreSchemaDefinition(Document var1, Object var2);
}

