/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.ExtensibleNode;
import io.apicurio.datamodels.core.models.Extension;
import io.apicurio.datamodels.core.models.NodePath;

public class NewExtensionCommand
extends AbstractCommand {
    public NodePath _parentPath;
    public String _name;
    public Object _value;
    public boolean _created;

    NewExtensionCommand() {
    }

    NewExtensionCommand(ExtensibleNode parent, String name, Object value) {
        this._parentPath = Library.createNodePath(parent);
        this._name = name;
        this._value = value;
    }

    @Override
    public void execute(Document document) {
        LoggerCompat.info("[NewExtensionCommand] Executing.", new Object[0]);
        this._created = false;
        ExtensibleNode parent = (ExtensibleNode)this._parentPath.resolve(document);
        Extension extension = parent.getExtension(this._name);
        if (!this.isNullOrUndefined(extension)) {
            return;
        }
        extension = parent.createExtension();
        extension.name = this._name;
        extension.value = this._value;
        parent.addExtension(this._name, extension);
        this._created = true;
    }

    @Override
    public void undo(Document document) {
        LoggerCompat.info("[NewExtensionCommand] Reverting.", new Object[0]);
        if (!this._created) {
            return;
        }
        ExtensibleNode parent = (ExtensibleNode)this._parentPath.resolve(document);
        if (!this._created) {
            return;
        }
        parent.removeExtension(this._name);
    }
}

