/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.util;

import com.fasterxml.jackson.databind.node.ObjectNode;
import io.apicurio.datamodels.compat.JsonCompat;
import io.apicurio.datamodels.compat.NodeCompat;
import io.apicurio.datamodels.compat.RegexCompat;
import io.apicurio.datamodels.core.models.Extension;
import java.util.ArrayList;
import java.util.List;

public class ModelUtils {
    public static boolean isNullOrUndefined(Object object) {
        return NodeCompat.isNullOrUndefined(object);
    }

    public static boolean isDefined(Object object) {
        return NodeCompat.isDefined(object);
    }

    public static List<String> detectPathParamNames(String path) {
        ArrayList<String> paramNames = new ArrayList<String>();
        List<String[]> matches = RegexCompat.findMatches(path, "\\{([^\\}]+)\\}");
        for (String[] match : matches) {
            String name = match[1];
            paramNames.add(name.trim());
        }
        return paramNames;
    }

    public static Object marshalExtension(Extension extension) {
        ObjectNode wrapper = JsonCompat.objectNode();
        JsonCompat.setProperty(wrapper, extension.name, extension.value);
        return wrapper;
    }

    public static void unmarshalExtension(Object oldExtension, Extension extension) {
        String name = JsonCompat.keys(oldExtension).get(0);
        Object value = JsonCompat.getPropertyObject(oldExtension, name);
        extension.name = name;
        extension.value = value;
    }
}

