/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.core.models;

import io.apicurio.datamodels.compat.NodeCompat;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.ExtensibleNode;
import io.apicurio.datamodels.core.models.IIndexedNode;
import io.apicurio.datamodels.core.models.IVisitable;
import io.apicurio.datamodels.core.models.Node;
import io.apicurio.datamodels.core.visitors.IVisitor;
import java.util.ArrayList;
import java.util.List;

public class NodePath {
    private static final int SCAN_TYPE_PATH = 0;
    private static final int SCAN_TYPE_INDEX = 1;
    private List<NodePathSegment> segments = new ArrayList<NodePathSegment>();

    public NodePath() {
    }

    public NodePath(String path) {
        if (path != null && path.indexOf("/") == 0 && !path.equals("/")) {
            boolean currentScanType = false;
            int currentIdx = 1;
            while (currentIdx < path.length()) {
                int segEnd;
                int segStart = currentIdx;
                if (!currentScanType) {
                    int nextPathSep = path.indexOf("/", segStart);
                    int nextBrace = path.indexOf("[", segStart);
                    if (nextPathSep == -1) {
                        nextPathSep = path.length();
                    }
                    if (nextBrace == -1) {
                        nextBrace = path.length();
                    }
                    segEnd = nextPathSep <= nextBrace ? nextPathSep : nextBrace;
                } else {
                    int nextCloseBrace = path.indexOf("]", segStart);
                    if (nextCloseBrace == -1) {
                        nextCloseBrace = path.length();
                    }
                    segEnd = nextCloseBrace + 1;
                }
                String seg = path.substring(segStart, segEnd);
                NodePathSegment segment = NodePathSegment.fromString(seg);
                this.segments.add(segment);
                currentScanType = false;
                currentIdx = segEnd + 1;
                if (segEnd >= path.length()) continue;
                if (path.charAt(segEnd) == '/') {
                    currentScanType = false;
                    currentIdx = segEnd + 1;
                    continue;
                }
                if (path.charAt(segEnd) == '[') {
                    currentScanType = true;
                    currentIdx = segEnd;
                    continue;
                }
                if (path.charAt(segEnd) != ']') continue;
                if (path.charAt(segEnd + 1) == '[') {
                    currentScanType = true;
                    currentIdx = segEnd + 1;
                    continue;
                }
                if (path.charAt(segEnd + 1) != '/') continue;
                currentScanType = false;
                currentIdx = segEnd + 1;
            }
        }
    }

    public void prependSegment(String value, boolean index) {
        this.segments.add(0, new NodePathSegment(value, index));
    }

    public void prependSegment(String value) {
        this.prependSegment(value, false);
    }

    public void appendSegment(String value, boolean index) {
        this.segments.add(new NodePathSegment(value, index));
    }

    public void appendSegment(String value) {
        this.appendSegment(value, false);
    }

    public Node resolve(Document document) {
        return this.resolveWithVisitor(document, null);
    }

    public Node resolveWithVisitor(Document document, IVisitor visitor) {
        Document node = document;
        if (visitor != null) {
            ((Node)node).accept(visitor);
        }
        Object oNode = node;
        for (NodePathSegment segment : this.segments) {
            oNode = segment.resolve(oNode);
            if (visitor == null || oNode == null || !(oNode instanceof IVisitable)) continue;
            ((IVisitable)oNode).accept(visitor);
        }
        return (Node)oNode;
    }

    public boolean contains(Node node) {
        Object tnode = node.ownerDocument();
        if (tnode == node) {
            return true;
        }
        for (NodePathSegment segment : this.segments) {
            tnode = segment.resolve(tnode);
            if (tnode != node) continue;
            return true;
        }
        return false;
    }

    public List<String> toSegments() {
        ArrayList<String> rval = new ArrayList<String>();
        this.segments.forEach(segment -> rval.add(segment.getValue()));
        return rval;
    }

    public String toString() {
        if (this.segments.size() == 0) {
            return "/";
        }
        String rval = "";
        for (NodePathSegment segment : this.segments) {
            if (segment.isIndex()) {
                rval = rval + '[' + segment.asString() + ']';
                continue;
            }
            rval = rval + '/' + segment.asString();
        }
        return rval;
    }

    private static class NodePathSegment {
        private String value;
        private boolean index;

        public NodePathSegment(String value) {
            this.value = value;
            this.index = false;
        }

        public NodePathSegment(String value, boolean index) {
            this(value);
            this.index = index;
        }

        public String getValue() {
            return this.value;
        }

        public boolean isIndex() {
            return this.index;
        }

        public Object resolve(Object from) {
            Node fromNode;
            if (from == null) {
                return null;
            }
            Object childNode = null;
            childNode = this.isIndex() && from instanceof IIndexedNode ? (Object)((IIndexedNode)from).getItem(this.getValue()) : (this.getValue().indexOf("x-") == 0 ? ((fromNode = (Node)from).isExtensible() ? ((ExtensibleNode)from).getExtension(this.getValue()) : null) : NodeCompat.getProperty(from, this.getValue()));
            return childNode;
        }

        public String asString() {
            if (this.getValue() == null) {
                return null;
            }
            return NodePathSegment.escapePathSegmentValue(this.getValue(), !this.isIndex());
        }

        public static NodePathSegment fromString(String segment) {
            if (segment == null) {
                return new NodePathSegment(null);
            }
            boolean isIndex = false;
            if (segment.indexOf("[") == 0 && segment.indexOf("]") == segment.length() - 1) {
                segment = segment.substring(1, segment.length() - 1);
                isIndex = true;
            }
            segment = NodePathSegment.unescapePathSegmentValue(segment);
            return new NodePathSegment(segment, isIndex);
        }

        private static String escapePathSegmentValue(String rawValue, boolean escapeSlash) {
            String res = rawValue.replace("~", "~0");
            if (escapeSlash) {
                res = res.replace("/", "~1");
            }
            res = res.replace("[", "~2");
            res = res.replace("]", "~3");
            return res;
        }

        private static String unescapePathSegmentValue(String escapedValue) {
            String res = escapedValue.replace("~3", "]");
            res = res.replace("~2", "[");
            res = res.replace("~1", "/");
            res = res.replace("~0", "~");
            return res;
        }
    }
}

