/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.core.util;

import io.apicurio.datamodels.core.models.Node;
import io.apicurio.datamodels.core.util.IReferenceResolver;
import io.apicurio.datamodels.core.util.LocalReferenceResolver;
import java.util.LinkedList;
import java.util.List;

public class ReferenceResolverChain
implements IReferenceResolver {
    private static final ReferenceResolverChain instance = new ReferenceResolverChain();
    private final List<IReferenceResolver> resolvers = new LinkedList<IReferenceResolver>();

    public static ReferenceResolverChain getInstance() {
        return instance;
    }

    public ReferenceResolverChain() {
        this.addResolver(new LocalReferenceResolver());
    }

    public List<IReferenceResolver> getResolvers() {
        return this.resolvers;
    }

    public void addResolver(IReferenceResolver resolver) {
        this.resolvers.add(0, resolver);
    }

    public void removeResolver(IReferenceResolver resolver) {
        this.resolvers.remove(resolver);
    }

    @Override
    public Node resolveRef(String reference, Node from) {
        for (IReferenceResolver resolver : this.resolvers) {
            Node resolvedNode = resolver.resolveRef(reference, from);
            if (resolvedNode == null) continue;
            return resolvedNode;
        }
        return null;
    }
}

