/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.core.validation.rules.other;

import io.apicurio.datamodels.core.models.common.ISecurityRequirementParent;
import io.apicurio.datamodels.core.models.common.SecurityRequirement;
import io.apicurio.datamodels.core.validation.ValidationRule;
import io.apicurio.datamodels.core.validation.ValidationRuleMetaData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SecurityRequirementUniquenessValidationRule
extends ValidationRule {
    public SecurityRequirementUniquenessValidationRule(ValidationRuleMetaData ruleInfo) {
        super(ruleInfo);
    }

    private static boolean isEqualTo(SecurityRequirement currentSecurityRequirement, SecurityRequirement otherSecurityRequirement) {
        List<String> currentSecurityRequirementNames = currentSecurityRequirement.getSecurityRequirementNames();
        List<String> otherSecurityRequirementNames = otherSecurityRequirement.getSecurityRequirementNames();
        Collections.sort(currentSecurityRequirementNames);
        Collections.sort(otherSecurityRequirementNames);
        if (!currentSecurityRequirementNames.equals(otherSecurityRequirementNames)) {
            return false;
        }
        for (String secReqName : currentSecurityRequirementNames) {
            List<String> secReqScopes = currentSecurityRequirement.getScopes(secReqName);
            List<String> otherSecReqScopes = otherSecurityRequirement.getScopes(secReqName);
            Collections.sort(secReqScopes);
            Collections.sort(otherSecReqScopes);
            if (secReqScopes.equals(otherSecReqScopes)) continue;
            return false;
        }
        return true;
    }

    private static boolean checkForDuplicates(SecurityRequirement currentSecurityRequirement, List<SecurityRequirement> allRequirements) {
        ArrayList<SecurityRequirement> clonedList = new ArrayList<SecurityRequirement>(allRequirements);
        clonedList.remove(currentSecurityRequirement);
        for (SecurityRequirement otherSecurityRequirement : clonedList) {
            if (!SecurityRequirementUniquenessValidationRule.isEqualTo(currentSecurityRequirement, otherSecurityRequirement)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void visitSecurityRequirement(SecurityRequirement node) {
        ISecurityRequirementParent parent = (ISecurityRequirementParent)((Object)node.parent());
        List<SecurityRequirement> securityRequirements = parent.getSecurityRequirements();
        if (securityRequirements.size() <= 1) {
            return;
        }
        if (SecurityRequirementUniquenessValidationRule.checkForDuplicates(node, securityRequirements)) {
            this.report(node, "security", this.map("securityReq", node.getSecurityRequirementNames().toString()));
        }
    }
}

