/*
 * Decompiled with CFR 0.152.
 */
package com.datadoghq.sketch.ddsketch.store;

import com.datadoghq.sketch.ddsketch.Serializer;
import com.datadoghq.sketch.ddsketch.encoding.BinEncodingMode;
import com.datadoghq.sketch.ddsketch.encoding.Flag;
import com.datadoghq.sketch.ddsketch.encoding.Input;
import com.datadoghq.sketch.ddsketch.encoding.Output;
import com.datadoghq.sketch.ddsketch.encoding.VarEncodingHelper;
import com.datadoghq.sketch.ddsketch.store.Bin;
import com.datadoghq.sketch.ddsketch.store.BinAcceptor;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public interface Store {
    default public void add(int index) {
        this.add(index, 1L);
    }

    default public void add(int index, long count) {
        this.add(index, (double)count);
    }

    public void add(int var1, double var2);

    default public void add(Bin bin) {
        this.add(bin.getIndex(), bin.getCount());
    }

    default public void mergeWith(Store store) {
        store.forEach(this::add);
    }

    public Store copy();

    public void clear();

    default public boolean isEmpty() {
        return this.getStream().mapToDouble(Bin::getCount).allMatch(count -> count == 0.0);
    }

    default public double getTotalCount() {
        return this.getStream().mapToDouble(Bin::getCount).sum();
    }

    default public int getMinIndex() {
        return this.getAscendingStream().filter(bin -> bin.getCount() > 0.0).findFirst().orElseThrow(NoSuchElementException::new).getIndex();
    }

    default public int getMaxIndex() {
        return this.getDescendingStream().filter(bin -> bin.getCount() > 0.0).findFirst().orElseThrow(NoSuchElementException::new).getIndex();
    }

    default public void forEach(BinAcceptor acceptor) {
        this.getStream().forEach((? super T bin) -> acceptor.accept(bin.getIndex(), bin.getCount()));
    }

    default public Stream<Bin> getStream() {
        return this.getAscendingStream();
    }

    default public Stream<Bin> getAscendingStream() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.getAscendingIterator(), 0), false);
    }

    default public Stream<Bin> getDescendingStream() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.getDescendingIterator(), 0), false);
    }

    public Iterator<Bin> getAscendingIterator();

    public Iterator<Bin> getDescendingIterator();

    public void encode(Output var1, Flag.Type var2) throws IOException;

    default public void decodeAndMergeWith(Input input, BinEncodingMode encodingMode) throws IOException {
        switch (encodingMode) {
            case INDEX_DELTAS_AND_COUNTS: {
                long numBins = VarEncodingHelper.decodeUnsignedVarLong(input);
                long index = 0L;
                for (long i = 0L; i != numBins; ++i) {
                    long indexDelta = VarEncodingHelper.decodeSignedVarLong(input);
                    double count = VarEncodingHelper.decodeVarDouble(input);
                    this.add(Math.toIntExact(index += indexDelta), count);
                }
                break;
            }
            case INDEX_DELTAS: {
                long numBins = VarEncodingHelper.decodeUnsignedVarLong(input);
                long index = 0L;
                for (long i = 0L; i != numBins; ++i) {
                    long indexDelta = VarEncodingHelper.decodeSignedVarLong(input);
                    this.add(Math.toIntExact(index += indexDelta));
                }
                break;
            }
            case CONTIGUOUS_COUNTS: {
                long numBins = VarEncodingHelper.decodeUnsignedVarLong(input);
                long index = VarEncodingHelper.decodeSignedVarLong(input);
                long indexDelta = VarEncodingHelper.decodeSignedVarLong(input);
                long i = 0L;
                while (i != numBins) {
                    double count = VarEncodingHelper.decodeVarDouble(input);
                    this.add(Math.toIntExact(index), count);
                    ++i;
                    index += indexDelta;
                }
                break;
            }
            default: {
                throw new IllegalStateException("The bin encoding mode is not handled.");
            }
        }
    }

    default public int serializedSize() {
        int[] size = new int[]{0};
        this.forEach((index, count) -> {
            size[0] = size[0] + Serializer.sizeOfBin(1, index, count);
        });
        return size[0];
    }

    default public void serialize(Serializer serializer) {
        this.forEach((index, count) -> serializer.writeBin(1, index, count));
    }
}

