/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.api;

import io.nats.client.support.ApiConstants;
import io.nats.client.support.JsonSerializable;
import io.nats.client.support.JsonUtils;
import io.nats.client.support.Validator;

public class ObjectLink
implements JsonSerializable {
    private final String bucket;
    private final String objectName;

    static ObjectLink optionalInstance(String fullJson) {
        String objJson = JsonUtils.getJsonObject("link", fullJson, null);
        return objJson == null ? null : new ObjectLink(objJson);
    }

    ObjectLink(String json) {
        this.bucket = JsonUtils.readString(json, ApiConstants.BUCKET_RE);
        this.objectName = JsonUtils.readString(json, ApiConstants.NAME_RE);
    }

    private ObjectLink(String bucket, String objectName) {
        this.bucket = Validator.validateBucketName(bucket, true);
        this.objectName = objectName;
    }

    @Override
    public String toJson() {
        StringBuilder sb = JsonUtils.beginJson();
        JsonUtils.addField(sb, "bucket", this.bucket);
        JsonUtils.addField(sb, "name", this.objectName);
        return JsonUtils.endJson(sb).toString();
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public boolean isObjectLink() {
        return this.objectName != null;
    }

    public boolean isBucketLink() {
        return this.objectName == null;
    }

    public static ObjectLink bucket(String bucket) {
        return new ObjectLink(bucket, null);
    }

    public static ObjectLink object(String bucket, String objectName) {
        return new ObjectLink(bucket, objectName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObjectLink that = (ObjectLink)o;
        if (!this.bucket.equals(that.bucket)) {
            return false;
        }
        return this.objectName != null ? this.objectName.equals(that.objectName) : that.objectName == null;
    }

    public int hashCode() {
        return this.bucket.hashCode() * 31 + (this.objectName == null ? 0 : this.objectName.hashCode());
    }

    public String toString() {
        return "ObjectLink{bucket='" + this.bucket + '\'' + ", objectName='" + this.objectName + '\'' + '}';
    }
}

