/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.api;

import io.nats.client.support.ApiConstants;
import io.nats.client.support.JsonUtils;
import java.util.Arrays;
import java.util.List;

public class ServerInfo {
    private final String serverId;
    private final String serverName;
    private final String version;
    private final String go;
    private final String host;
    private final int port;
    private final boolean headersSupported;
    private final boolean authRequired;
    private final boolean tlsRequired;
    private final long maxPayload;
    private final List<String> connectURLs;
    private final int protocolVersion;
    private final byte[] nonce;
    private final boolean lameDuckMode;
    private final boolean jetStream;
    private final int clientId;
    private final String clientIp;
    private final String cluster;

    public ServerInfo(String json) {
        if (json == null || json.length() < 6 || '{' != json.charAt(0) && '{' != json.charAt(5)) {
            throw new IllegalArgumentException("Invalid Server Info");
        }
        this.serverId = JsonUtils.readString(json, ApiConstants.SERVER_ID_RE);
        this.serverName = JsonUtils.readString(json, ApiConstants.SERVER_NAME_RE);
        this.version = JsonUtils.readString(json, ApiConstants.VERSION_RE);
        this.go = JsonUtils.readString(json, ApiConstants.GO_RE);
        this.host = JsonUtils.readString(json, ApiConstants.HOST_RE);
        this.headersSupported = JsonUtils.readBoolean(json, ApiConstants.HEADERS_RE);
        this.authRequired = JsonUtils.readBoolean(json, ApiConstants.AUTH_REQUIRED_RE);
        this.nonce = JsonUtils.readBytes(json, ApiConstants.NONCE_RE);
        this.tlsRequired = JsonUtils.readBoolean(json, ApiConstants.TLS_RE);
        this.lameDuckMode = JsonUtils.readBoolean(json, ApiConstants.LAME_DUCK_MODE_RE);
        this.jetStream = JsonUtils.readBoolean(json, ApiConstants.JET_STREAM_RE);
        this.port = JsonUtils.readInt(json, ApiConstants.PORT_RE, 0);
        this.protocolVersion = JsonUtils.readInt(json, ApiConstants.PROTO_RE, 0);
        this.maxPayload = JsonUtils.readLong(json, ApiConstants.MAX_PAYLOAD_RE, 0L);
        this.clientId = JsonUtils.readInt(json, ApiConstants.CLIENT_ID_RE, 0);
        this.clientIp = JsonUtils.readString(json, ApiConstants.CLIENT_IP_RE);
        this.cluster = JsonUtils.readString(json, ApiConstants.CLUSTER_RE);
        this.connectURLs = JsonUtils.getStringList("connect_urls", json);
    }

    public boolean isLameDuckMode() {
        return this.lameDuckMode;
    }

    public String getServerId() {
        return this.serverId;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getVersion() {
        return this.version;
    }

    public String getGoVersion() {
        return this.go;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    public boolean isHeadersSupported() {
        return this.headersSupported;
    }

    public boolean isAuthRequired() {
        return this.authRequired;
    }

    public boolean isTLSRequired() {
        return this.tlsRequired;
    }

    public long getMaxPayload() {
        return this.maxPayload;
    }

    public List<String> getConnectURLs() {
        return this.connectURLs;
    }

    public byte[] getNonce() {
        return this.nonce;
    }

    public boolean isJetStreamAvailable() {
        return this.jetStream;
    }

    public int getClientId() {
        return this.clientId;
    }

    public String getClientIp() {
        return this.clientIp;
    }

    public String getCluster() {
        return this.cluster;
    }

    private String getComparableVersion(String vString) {
        try {
            String[] v = vString.replaceAll("v", "").replaceAll("-", ".").split("\\Q.\\E");
            int at = vString.indexOf("-");
            return "" + Integer.parseInt(v[0]) * 10000 + Integer.parseInt(v[1]) * 100 + Integer.parseInt(v[2]) + (at == -1 ? "~" : vString.substring(at));
        }
        catch (NumberFormatException nfe) {
            return "";
        }
    }

    public boolean isNewerVersionThan(String vTarget) {
        return this.getComparableVersion(this.version).compareTo(this.getComparableVersion(vTarget)) > 0;
    }

    public boolean isSameVersion(String vTarget) {
        return this.getComparableVersion(this.version).compareTo(this.getComparableVersion(vTarget)) == 0;
    }

    public boolean isOlderThanVersion(String vTarget) {
        return this.getComparableVersion(this.version).compareTo(this.getComparableVersion(vTarget)) < 0;
    }

    public boolean isSameOrOlderThanVersion(String vTarget) {
        return this.getComparableVersion(this.version).compareTo(this.getComparableVersion(vTarget)) <= 0;
    }

    public boolean isSameOrNewerThanVersion(String vTarget) {
        return this.getComparableVersion(this.version).compareTo(this.getComparableVersion(vTarget)) >= 0;
    }

    public String toString() {
        return "ServerInfo{serverId='" + this.serverId + '\'' + ", serverName='" + this.serverName + '\'' + ", version='" + this.version + '\'' + ", go='" + this.go + '\'' + ", host='" + this.host + '\'' + ", port=" + this.port + ", headersSupported=" + this.headersSupported + ", authRequired=" + this.authRequired + ", tlsRequired=" + this.tlsRequired + ", maxPayload=" + this.maxPayload + ", connectURLs=" + this.connectURLs + ", protocolVersion=" + this.protocolVersion + ", nonce=" + Arrays.toString(this.nonce) + ", lameDuckMode=" + this.lameDuckMode + ", jetStream=" + this.jetStream + ", clientId=" + this.clientId + ", clientIp='" + this.clientIp + '\'' + ", cluster='" + this.cluster + '\'' + '}';
    }
}

