/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.support;

import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.util.Random;

public abstract class RandomUtils {
    public static final SecureRandom SRAND = new SecureRandom();
    public static final Random PRAND = new Random(RandomUtils.bytesToLong(SRAND.generateSeed(8)));

    private RandomUtils() {
    }

    public static long nextLong(Random rng, long maxValue) {
        long val;
        long bits;
        while ((bits = rng.nextLong() << 1 >>> 1) - (val = bits % maxValue) + (maxValue - 1L) < 0L) {
        }
        return val;
    }

    public static long bytesToLong(byte[] bytes) {
        ByteBuffer buffer = ByteBuffer.allocate(64);
        buffer.put(bytes);
        buffer.flip();
        return buffer.getLong();
    }
}

