/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.server.kafka;

import io.debezium.DebeziumException;
import io.debezium.engine.ChangeEvent;
import io.debezium.engine.DebeziumEngine;
import io.debezium.engine.Header;
import io.debezium.server.BaseChangeConsumer;
import io.debezium.server.CustomConsumerBuilder;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="kafka")
@Dependent
public class KafkaChangeConsumer
extends BaseChangeConsumer
implements DebeziumEngine.ChangeConsumer<ChangeEvent<Object, Object>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(KafkaChangeConsumer.class);
    private static final String PROP_PREFIX = "debezium.sink.kafka.";
    private static final String PROP_PREFIX_PRODUCER = "debezium.sink.kafka.producer.";
    private KafkaProducer<Object, Object> producer;
    @Inject
    @CustomConsumerBuilder
    Instance<KafkaProducer<Object, Object>> customKafkaProducer;

    @PostConstruct
    void start() {
        if (this.customKafkaProducer.isResolvable()) {
            this.producer = (KafkaProducer)this.customKafkaProducer.get();
            LOGGER.info("Obtained custom configured KafkaProducer '{}'", this.producer);
            return;
        }
        Config config = ConfigProvider.getConfig();
        this.producer = new KafkaProducer(this.getConfigSubset(config, PROP_PREFIX_PRODUCER));
        LOGGER.info("consumer started...");
    }

    @PreDestroy
    void stop() {
        LOGGER.info("consumer destroyed...");
        if (this.producer != null) {
            try {
                this.producer.close(Duration.ofSeconds(5L));
            }
            catch (Throwable t) {
                LOGGER.warn("Could not close producer", t);
            }
        }
    }

    public void handleBatch(List<ChangeEvent<Object, Object>> records, DebeziumEngine.RecordCommitter<ChangeEvent<Object, Object>> committer) throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(records.size());
        for (ChangeEvent<Object, Object> record : records) {
            try {
                LOGGER.trace("Received event '{}'", record);
                Headers headers = this.convertKafkaHeaders(record);
                this.producer.send(new ProducerRecord(record.destination(), null, null, record.key(), record.value(), (Iterable)headers), (metadata, exception) -> {
                    if (exception != null) {
                        LOGGER.error("Failed to send record to {}:", (Object)record.destination(), (Object)exception);
                        throw new DebeziumException((Throwable)exception);
                    }
                    LOGGER.trace("Sent message with offset: {}", (Object)metadata.offset());
                    latch.countDown();
                });
                committer.markProcessed(record);
            }
            catch (Exception e) {
                throw new DebeziumException((Throwable)e);
            }
        }
        latch.await();
        committer.markBatchFinished();
    }

    private Headers convertKafkaHeaders(ChangeEvent<Object, Object> record) {
        List headers = record.headers();
        RecordHeaders kafkaHeaders = new RecordHeaders();
        for (Header header : headers) {
            kafkaHeaders.add(header.getKey(), this.getBytes(header.getValue()));
        }
        return kafkaHeaders;
    }
}

