/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.connector.AbstractSourceInfo;
import io.debezium.connector.AbstractSourceInfoStructMaker;
import io.debezium.connector.spanner.context.source.SourceInfo;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;

public class SpannerSourceInfoStructMaker
extends AbstractSourceInfoStructMaker<SourceInfo> {
    private final Schema schema = this.commonSchemaBuilder().name("com.google.spanner.connector.Source").field("project_id", Schema.STRING_SCHEMA).field("instance_id", Schema.STRING_SCHEMA).field("database_id", Schema.STRING_SCHEMA).field("change_stream_name", Schema.STRING_SCHEMA).field("table", Schema.STRING_SCHEMA).field("server_transaction_id", Schema.OPTIONAL_STRING_SCHEMA).field("low_watermark", Schema.OPTIONAL_INT64_SCHEMA).field("read_at_timestamp", Schema.OPTIONAL_INT64_SCHEMA).field("number_records_in_transaction", Schema.OPTIONAL_INT64_SCHEMA).field("transaction_tag", Schema.OPTIONAL_STRING_SCHEMA).field("system_transaction", Schema.OPTIONAL_BOOLEAN_SCHEMA).field("value_capture_type", Schema.OPTIONAL_STRING_SCHEMA).field("partition_token", Schema.OPTIONAL_STRING_SCHEMA).field("mod_number", Schema.OPTIONAL_INT32_SCHEMA).field("is_last_record_in_transaction_in_partition", Schema.OPTIONAL_BOOLEAN_SCHEMA).field("number_of_partitions_in_transaction", Schema.OPTIONAL_INT64_SCHEMA).build();

    public SpannerSourceInfoStructMaker(String connector, String version, CommonConnectorConfig connectorConfig) {
        super(connector, version, connectorConfig);
    }

    public Schema schema() {
        return this.schema;
    }

    public Struct struct(SourceInfo sourceInfo) {
        if (sourceInfo.getDatabaseId() == null || sourceInfo.database() == null) {
            throw new IllegalStateException("databaseId is null");
        }
        if (sourceInfo.getTableName() == null) {
            throw new IllegalStateException("table name is null");
        }
        if (sourceInfo.getInstanceId() == null) {
            throw new IllegalStateException("instanceId is null");
        }
        if (sourceInfo.getProjectId() == null) {
            throw new IllegalStateException("projectId is null");
        }
        return this.buildStruct(sourceInfo);
    }

    private Struct buildStruct(SourceInfo sourceInfo) {
        Struct result = super.commonStruct((AbstractSourceInfo)sourceInfo);
        result.put("project_id", (Object)sourceInfo.getProjectId());
        result.put("instance_id", (Object)sourceInfo.getInstanceId());
        result.put("database_id", (Object)sourceInfo.getDatabaseId());
        result.put("table", (Object)sourceInfo.getTableName());
        result.put("change_stream_name", (Object)sourceInfo.getChangeStreamName());
        if (sourceInfo.getReadAtTimestamp() != null) {
            result.put("read_at_timestamp", (Object)sourceInfo.getReadAtTimestamp().toEpochMilli());
        }
        if (sourceInfo.getLowWatermark() != null) {
            result.put("low_watermark", (Object)sourceInfo.getLowWatermark().toEpochMilli());
        }
        if (sourceInfo.getServerTransactionId() != null) {
            result.put("server_transaction_id", (Object)sourceInfo.getServerTransactionId());
        }
        if (sourceInfo.getNumberRecordsInTransaction() != null) {
            result.put("number_records_in_transaction", (Object)sourceInfo.getNumberRecordsInTransaction());
        }
        if (sourceInfo.getTransactionTag() != null) {
            result.put("transaction_tag", (Object)sourceInfo.getTransactionTag());
        }
        if (sourceInfo.isSystemTransaction() != null) {
            result.put("system_transaction", (Object)sourceInfo.isSystemTransaction());
        }
        if (sourceInfo.getValueCaptureType() != null) {
            result.put("value_capture_type", (Object)sourceInfo.getValueCaptureType());
        }
        if (sourceInfo.getPartitionToken() != null) {
            result.put("partition_token", (Object)sourceInfo.getPartitionToken());
        }
        if (sourceInfo.getModNumber() != null) {
            result.put("mod_number", (Object)sourceInfo.getModNumber());
        }
        if (sourceInfo.getLastRecordInTransactionInPartition() != null) {
            result.put("is_last_record_in_transaction_in_partition", (Object)sourceInfo.getLastRecordInTransactionInPartition());
        }
        if (sourceInfo.getNumberOfPartitionsInTransaction() != null) {
            result.put("number_of_partitions_in_transaction", (Object)sourceInfo.getNumberOfPartitionsInTransaction());
        }
        return result;
    }
}

