/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.task;

import io.debezium.connector.spanner.kafka.internal.TaskSyncPublisher;
import io.debezium.connector.spanner.kafka.internal.model.MessageTypeEnum;
import io.debezium.connector.spanner.kafka.internal.model.RebalanceState;
import io.debezium.connector.spanner.kafka.internal.model.SyncEventMetadata;
import io.debezium.connector.spanner.kafka.internal.model.TaskState;
import io.debezium.connector.spanner.kafka.internal.model.TaskSyncEvent;
import io.debezium.connector.spanner.task.SyncEventMerger;
import io.debezium.connector.spanner.task.TaskSyncContextHolder;
import io.debezium.connector.spanner.task.state.SyncEvent;
import io.debezium.connector.spanner.task.state.TaskStateChangeEvent;
import io.debezium.function.BlockingConsumer;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncEventHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncEventHandler.class);
    private final TaskSyncContextHolder taskSyncContextHolder;
    private final TaskSyncPublisher taskSyncPublisher;
    private final BlockingConsumer<TaskStateChangeEvent> eventConsumer;

    public SyncEventHandler(TaskSyncContextHolder taskSyncContextHolder, TaskSyncPublisher taskSyncPublisher, BlockingConsumer<TaskStateChangeEvent> eventConsumer) {
        this.taskSyncContextHolder = taskSyncContextHolder;
        this.taskSyncPublisher = taskSyncPublisher;
        this.eventConsumer = eventConsumer;
    }

    public void updateCurrentOffset(TaskSyncEvent inSync, SyncEventMetadata metadata) {
        if (inSync == null) {
            return;
        }
        if (this.skipFromPreviousGeneration(inSync)) {
            return;
        }
        this.taskSyncContextHolder.update(oldContext -> oldContext.toBuilder().currentKafkaRecordOffset(metadata.getOffset()).build());
        LOGGER.debug("Task {} - update task sync topic offset with {}", (Object)this.taskSyncContextHolder.get().getTaskUid(), (Object)metadata.getOffset());
    }

    public void processPreviousStates(TaskSyncEvent inSync, SyncEventMetadata metadata) {
        if (!RebalanceState.START_INITIAL_SYNC.equals((Object)this.taskSyncContextHolder.get().getRebalanceState())) {
            return;
        }
        if (this.skipFromPreviousGeneration(inSync)) {
            return;
        }
        this.taskSyncContextHolder.lock();
        try {
            if (inSync != null) {
                LOGGER.debug("Task {} - processPreviousStates - merge", (Object)this.taskSyncContextHolder.get().getTaskUid());
                this.taskSyncContextHolder.update(context -> SyncEventMerger.merge(context, inSync));
            }
            if (metadata.isCanInitiateRebalancing()) {
                LOGGER.debug("Task {} - processPreviousStates - switch state to INITIAL_INCREMENTED_STATE_COMPLETED", (Object)this.taskSyncContextHolder.get().getTaskUid());
                this.taskSyncContextHolder.update(context -> context.toBuilder().rebalanceState(RebalanceState.INITIAL_INCREMENTED_STATE_COMPLETED).epochOffsetHolder(context.getEpochOffsetHolder().nextOffset(context.getCurrentKafkaRecordOffset())).build());
            }
        }
        finally {
            this.taskSyncContextHolder.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processNewEpoch(TaskSyncEvent inSync, SyncEventMetadata metadata) throws InterruptedException {
        if (inSync == null) {
            return;
        }
        if (this.skipFromPreviousGeneration(inSync)) {
            return;
        }
        this.taskSyncContextHolder.lock();
        try {
            long currentGeneration = this.taskSyncContextHolder.get().getRebalanceGenerationId();
            long inGeneration = inSync.getRebalanceGenerationId();
            if (this.taskSyncContextHolder.get().getRebalanceState() == RebalanceState.INITIAL_INCREMENTED_STATE_COMPLETED && inSync.getMessageType() == MessageTypeEnum.NEW_EPOCH && inGeneration >= currentGeneration) {
                LOGGER.debug("Task {} - processNewEpoch : {} metadata {}, rebalanceId: {}", new Object[]{this.taskSyncContextHolder.get().getTaskUid(), inSync, metadata, this.taskSyncContextHolder.get().getRebalanceGenerationId()});
                HashMap<String, TaskState> taskStates = new HashMap<String, TaskState>(inSync.getTaskStates());
                taskStates.remove(this.taskSyncContextHolder.get().getTaskUid());
                this.taskSyncContextHolder.update(context -> context.toBuilder().rebalanceState(RebalanceState.NEW_EPOCH_STARTED).createdTimestamp(inSync.getMessageTimestamp()).taskStates(taskStates).currentTaskState(context.getCurrentTaskState().toBuilder().stateTimestamp(inSync.getMessageTimestamp()).build()).build());
                LOGGER.debug("Task {} - SyncEventHandler sent response for new epoch", (Object)this.taskSyncContextHolder.get().getTaskUid());
                this.taskSyncPublisher.send(this.taskSyncContextHolder.get().buildTaskSyncEvent());
            }
        }
        finally {
            this.taskSyncContextHolder.unlock();
        }
    }

    public void process(TaskSyncEvent inSync, SyncEventMetadata metadata) throws InterruptedException {
        if (inSync == null) {
            return;
        }
        if (this.skipFromPreviousGeneration(inSync)) {
            return;
        }
        this.taskSyncContextHolder.lock();
        try {
            if (!this.taskSyncContextHolder.get().getRebalanceState().equals((Object)RebalanceState.NEW_EPOCH_STARTED)) {
                return;
            }
            LOGGER.debug("Task {} - process sync event", (Object)this.taskSyncContextHolder.get().getTaskUid());
            this.taskSyncContextHolder.update(context -> SyncEventMerger.merge(context, inSync));
            this.eventConsumer.accept((Object)new SyncEvent());
        }
        finally {
            this.taskSyncContextHolder.unlock();
        }
    }

    public void processRebalanceAnswer(TaskSyncEvent inSync, SyncEventMetadata metadata) {
        if (inSync == null) {
            return;
        }
        if (this.skipFromPreviousGeneration(inSync)) {
            return;
        }
        this.taskSyncContextHolder.lock();
        try {
            if (!this.taskSyncContextHolder.get().isLeader() || !this.taskSyncContextHolder.get().getRebalanceState().equals((Object)RebalanceState.INITIAL_INCREMENTED_STATE_COMPLETED)) {
                return;
            }
            LOGGER.debug("Task {} - process sync event - rebalance answer", (Object)this.taskSyncContextHolder.get().getTaskUid());
            this.taskSyncContextHolder.update(context -> SyncEventMerger.merge(context, inSync));
        }
        finally {
            this.taskSyncContextHolder.unlock();
        }
    }

    private boolean skipFromPreviousGeneration(TaskSyncEvent inSync) {
        long currentGeneration;
        long inGeneration;
        if (inSync != null && (inGeneration = inSync.getRebalanceGenerationId()) < (currentGeneration = this.taskSyncContextHolder.get().getRebalanceGenerationId())) {
            LOGGER.debug("skipFromPreviousGeneration: currentGen: {}, inGen: {}, inTaskUid: {}", new Object[]{currentGeneration, inGeneration, inSync.getTaskUid()});
            return true;
        }
        return false;
    }
}

