/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.task.scaler;

import io.debezium.connector.spanner.kafka.internal.model.PartitionState;
import io.debezium.connector.spanner.kafka.internal.model.TaskState;
import io.debezium.connector.spanner.kafka.internal.model.TaskSyncEvent;
import io.debezium.connector.spanner.task.TaskStateUtil;

public class TaskScalerUtil {
    private TaskScalerUtil() {
    }

    public static long partitionsInWorkCount(TaskSyncEvent taskSyncEvent) {
        if (taskSyncEvent == null) {
            return 0L;
        }
        return taskSyncEvent.getTaskStates().values().stream().flatMap(t -> t.getPartitions().stream()).filter(p -> TaskStateUtil.inProgressPartitionState(p.getState())).map(PartitionState::getToken).distinct().count();
    }

    public static int tasksCount(TaskSyncEvent taskSyncEvent) {
        if (taskSyncEvent == null) {
            return 0;
        }
        return taskSyncEvent.getTaskStates().size();
    }

    public static long idlingTaskCount(TaskSyncEvent taskSyncEvent) {
        if (taskSyncEvent == null) {
            return 0L;
        }
        return taskSyncEvent.getTaskStates().values().stream().filter(TaskScalerUtil::isIdlingTask).count();
    }

    private static boolean isIdlingTask(TaskState task) {
        boolean hasInProgressPartition = task.getPartitions().stream().anyMatch(p -> TaskStateUtil.inProgressPartitionState(p.getState()));
        return !hasInProgressPartition;
    }
}

