/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.task.utils;

import java.time.Duration;

public class ResettableDelayedAction {
    private final Duration timeOut;
    private volatile Thread thread;
    private final String name;

    public ResettableDelayedAction(String name, Duration timeOut) {
        this.timeOut = timeOut;
        this.name = name;
    }

    public void set(Runnable action) {
        this.clear();
        this.thread = new Thread(() -> {
            try {
                Thread.sleep(this.timeOut.toMillis());
                action.run();
                this.clear();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }, "SpannerConnector-" + this.name);
        this.thread.start();
    }

    public void clear() {
        if (this.thread != null) {
            this.thread.interrupt();
            this.thread = null;
        }
    }
}

