/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metrics;

import com.codahale.metrics.MetricRegistry;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metadata.NodeState;
import com.datastax.oss.driver.api.core.metrics.Metrics;
import com.datastax.oss.driver.api.core.metrics.NodeMetric;
import com.datastax.oss.driver.api.core.metrics.SessionMetric;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.metadata.NodeStateEvent;
import com.datastax.oss.driver.internal.core.metrics.DefaultMetrics;
import com.datastax.oss.driver.internal.core.metrics.DropwizardNodeMetricUpdater;
import com.datastax.oss.driver.internal.core.metrics.DropwizardSessionMetricUpdater;
import com.datastax.oss.driver.internal.core.metrics.MetricPaths;
import com.datastax.oss.driver.internal.core.metrics.MetricsFactory;
import com.datastax.oss.driver.internal.core.metrics.NodeMetricUpdater;
import com.datastax.oss.driver.internal.core.metrics.NoopNodeMetricUpdater;
import com.datastax.oss.driver.internal.core.metrics.NoopSessionMetricUpdater;
import com.datastax.oss.driver.internal.core.metrics.SessionMetricUpdater;
import com.datastax.oss.driver.internal.core.util.concurrent.RunOrSchedule;
import com.datastax.oss.driver.shaded.netty.util.concurrent.EventExecutor;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Optional;
import java.util.Set;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class DropwizardMetricsFactory
implements MetricsFactory {
    private static final Logger LOG = LoggerFactory.getLogger(DropwizardMetricsFactory.class);
    private final InternalDriverContext context;
    private final Set<NodeMetric> enabledNodeMetrics;
    private final MetricRegistry registry;
    @Nullable
    private final Metrics metrics;
    private final SessionMetricUpdater sessionUpdater;

    public DropwizardMetricsFactory(DriverContext context) {
        this.context = (InternalDriverContext)context;
        String logPrefix = context.getSessionName();
        DriverExecutionProfile config = context.getConfig().getDefaultProfile();
        Set<SessionMetric> enabledSessionMetrics = MetricPaths.parseSessionMetricPaths(config.getStringList(DefaultDriverOption.METRICS_SESSION_ENABLED), logPrefix);
        this.enabledNodeMetrics = MetricPaths.parseNodeMetricPaths(config.getStringList(DefaultDriverOption.METRICS_NODE_ENABLED), logPrefix);
        if (enabledSessionMetrics.isEmpty() && this.enabledNodeMetrics.isEmpty()) {
            LOG.debug("[{}] All metrics are disabled, Session.getMetrics will be empty", (Object)logPrefix);
            this.registry = null;
            this.sessionUpdater = NoopSessionMetricUpdater.INSTANCE;
            this.metrics = null;
        } else {
            Object possibleMetricRegistry = this.context.getMetricRegistry();
            if (possibleMetricRegistry == null) {
                possibleMetricRegistry = new MetricRegistry();
            }
            if (!(possibleMetricRegistry instanceof MetricRegistry)) {
                throw new IllegalArgumentException("Unexpected Metrics registry object. Expected registry object to be of type '" + MetricRegistry.class.getName() + "', but was '" + possibleMetricRegistry.getClass().getName() + "'");
            }
            this.registry = (MetricRegistry)possibleMetricRegistry;
            DropwizardSessionMetricUpdater dropwizardSessionUpdater = new DropwizardSessionMetricUpdater(this.context, enabledSessionMetrics, this.registry);
            this.sessionUpdater = dropwizardSessionUpdater;
            this.metrics = new DefaultMetrics(this.registry, dropwizardSessionUpdater);
            if (!this.enabledNodeMetrics.isEmpty()) {
                EventExecutor adminEventExecutor = this.context.getNettyOptions().adminEventExecutorGroup().next();
                this.context.getEventBus().register(NodeStateEvent.class, RunOrSchedule.on(adminEventExecutor, this::processNodeStateEvent));
            }
        }
    }

    @Override
    public Optional<Metrics> getMetrics() {
        return Optional.ofNullable(this.metrics);
    }

    @Override
    public SessionMetricUpdater getSessionUpdater() {
        return this.sessionUpdater;
    }

    @Override
    public NodeMetricUpdater newNodeUpdater(Node node) {
        if (this.registry == null) {
            return NoopNodeMetricUpdater.INSTANCE;
        }
        return new DropwizardNodeMetricUpdater(node, this.context, this.enabledNodeMetrics, this.registry);
    }

    protected void processNodeStateEvent(NodeStateEvent event) {
        if (event.newState == NodeState.DOWN || event.newState == NodeState.FORCED_DOWN || event.newState == null) {
            ((DropwizardNodeMetricUpdater)event.node.getMetricUpdater()).startMetricsExpirationTimeout();
        } else if (event.newState == NodeState.UP || event.newState == NodeState.UNKNOWN) {
            ((DropwizardNodeMetricUpdater)event.node.getMetricUpdater()).cancelMetricsExpirationTimeout();
        }
    }
}

