/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.amqp.implementation;

import java.time.Duration;

public final class ClientConstants {
    public static final String NOT_APPLICABLE = "n/a";
    public static final String PLATFORM_INFO = ClientConstants.getOSInformation();
    public static final String FRAMEWORK_INFO = ClientConstants.getFrameworkInfo();
    public static final Duration SERVER_BUSY_WAIT_TIME = Duration.ofSeconds(4L);
    public static final String CONNECTION_ID_KEY = "connectionId";
    public static final String LINK_NAME_KEY = "linkName";
    public static final String ENTITY_PATH_KEY = "entityPath";
    public static final String SESSION_NAME_KEY = "sessionName";
    public static final String FULLY_QUALIFIED_NAMESPACE_KEY = "namespace";
    public static final String ERROR_CONDITION_KEY = "errorCondition";
    public static final String ERROR_DESCRIPTION_KEY = "errorDescription";
    public static final String EMIT_RESULT_KEY = "emitResult";
    public static final String SIGNAL_TYPE_KEY = "signalType";
    public static final String HOSTNAME_KEY = "hostName";
    public static final String INTERVAL_KEY = "interval_ms";
    static final int MAX_MESSAGE_LENGTH_BYTES = 262144;
    static final int MAX_AMQP_HEADER_SIZE_BYTES = 512;
    static final int SERVER_BUSY_BASE_SLEEP_TIME_IN_SECS = 4;

    private ClientConstants() {
    }

    private static String getOSInformation() {
        return String.join((CharSequence)" ", System.getProperty("os.name"), System.getProperty("os.version"));
    }

    private static String getFrameworkInfo() {
        Package javaRuntimeClassPkg = Runtime.class.getPackage();
        return "jre:" + javaRuntimeClassPkg.getImplementationVersion() + ";vendor:" + javaRuntimeClassPkg.getImplementationVendor() + ";jvm" + System.getProperty("java.vm.version");
    }
}

