/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.converters;

import io.debezium.data.SpecialValueDecimal;
import io.debezium.jdbc.JdbcValueConverters;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.spi.converter.CustomConverter;
import io.debezium.spi.converter.RelationalColumn;
import io.debezium.util.Strings;
import java.math.BigDecimal;
import java.util.Properties;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NumberToZeroScaleConverter
implements CustomConverter<SchemaBuilder, RelationalColumn> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NumberToZeroScaleConverter.class);
    public static final String DECIMAL_MODE_PROPERTY = "decimal.mode";
    private JdbcValueConverters.DecimalMode decimalMode;

    public void configure(Properties props) {
        String decimalModeConfig = props.getProperty(DECIMAL_MODE_PROPERTY);
        this.decimalMode = !Strings.isNullOrEmpty((String)decimalModeConfig) ? RelationalDatabaseConnectorConfig.DecimalHandlingMode.parse((String)decimalModeConfig).asDecimalMode() : RelationalDatabaseConnectorConfig.DecimalHandlingMode.PRECISE.asDecimalMode();
    }

    public void converterFor(RelationalColumn field, CustomConverter.ConverterRegistration<SchemaBuilder> registration) {
        int scale = field.scale().orElse(0);
        if ("NUMBER".equalsIgnoreCase(field.typeName()) && scale < 0 && field.length().getAsInt() - scale >= 19) {
            SchemaBuilder schemaBuilder = SpecialValueDecimal.builder((JdbcValueConverters.DecimalMode)this.decimalMode, (int)field.length().getAsInt(), (int)0);
            registration.register((Object)schemaBuilder, x -> x == null ? null : SpecialValueDecimal.fromLogical((SpecialValueDecimal)new SpecialValueDecimal((BigDecimal)x), (JdbcValueConverters.DecimalMode)this.decimalMode, (String)field.name()));
        }
    }
}

