/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.shared.segment;

import io.pravega.common.Exceptions;
import io.pravega.common.hash.HashHelper;
import io.pravega.shared.NameUtils;

public final class SegmentToContainerMapper {
    private final HashHelper hasher = HashHelper.seededWith((String)"SegmentToContainerMapper");
    private final int containerCount;

    public SegmentToContainerMapper(int containerCount) {
        Exceptions.checkArgument((containerCount > 0 ? 1 : 0) != 0, (String)"containerCount", (String)"containerCount must be a positive integer.", (Object[])new Object[0]);
        this.containerCount = containerCount;
    }

    public int getTotalContainerCount() {
        return this.containerCount;
    }

    public int getContainerId(String streamSegmentName) {
        String primaryStreamSegmentName = NameUtils.extractPrimaryStreamSegmentName(streamSegmentName);
        if (primaryStreamSegmentName != null) {
            return this.mapStreamSegmentNameToContainerId(primaryStreamSegmentName);
        }
        return this.mapStreamSegmentNameToContainerId(streamSegmentName);
    }

    private int mapStreamSegmentNameToContainerId(String streamSegmentName) {
        return this.hasher.hashToBucket(streamSegmentName, this.containerCount);
    }
}

